/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DAOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pro.fessional.mirana.page.PageQuery;
import pro.fessional.mirana.page.PageResult;
import pro.fessional.wings.faceless.database.jooq.WingsJooqUtil;
import pro.fessional.wings.faceless.database.jooq.helper.PageJooqHelper;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.jackson.JacksonHelper;
import pro.fessional.wings.tiny.mail.database.autogen.tables.WinMailSenderTable;
import pro.fessional.wings.tiny.mail.database.autogen.tables.daos.WinMailSenderDao;
import pro.fessional.wings.tiny.mail.database.autogen.tables.pojos.WinMailSender;
import pro.fessional.wings.tiny.mail.service.TinyMailListService;
import pro.fessional.wings.tiny.mail.service.TinyMailPlain;

@Service
@ConditionalWingsEnabled
public class TinyMailListServiceImpl
implements TinyMailListService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TinyMailListServiceImpl.class);
    protected WinMailSenderDao winMailSenderDao;
    protected SelectField<?>[] plainFields = new SelectField[0];
    protected Map<String, Field<?>> sortsFields = new HashMap();
    private final RecordMapper<Record, TinyMailPlain> mapper = rd -> {
        TinyMailPlain bo = new TinyMailPlain();
        WinMailSender po = (WinMailSender)rd.into(WinMailSender.class);
        bo.setId(po.getId());
        bo.setApps(po.getMailApps());
        bo.setRuns(po.getMailRuns());
        bo.setConf(po.getMailConf());
        bo.setFrom(po.getMailFrom());
        bo.setTo(po.getMailTo());
        bo.setCc(po.getMailCc());
        bo.setBcc(po.getMailBcc());
        bo.setReply(po.getMailReply());
        bo.setSubject(po.getMailSubj());
        bo.setContent(po.getMailText());
        bo.setContent(po.getMailText());
        if (StringUtils.isNotEmpty((CharSequence)po.getMailFile())) {
            bo.setAttachment((Map)JacksonHelper.object((String)po.getMailFile(), Map.class));
        }
        bo.setHtml(po.getMailHtml());
        bo.setMark(po.getMailMark());
        bo.setDate(po.getMailDate());
        bo.setCreateDt(po.getCreateDt());
        bo.setLastSend(po.getLastSend());
        bo.setLastFail(po.getLastFail());
        bo.setLastDone(po.getLastDone());
        bo.setNextSend(po.getNextSend());
        bo.setSumSend(po.getSumSend());
        bo.setSumFail(po.getSumFail());
        bo.setSumDone(po.getSumDone());
        bo.setMaxFail(po.getMaxFail());
        bo.setMaxDone(po.getMaxDone());
        bo.setRefType(po.getRefType());
        bo.setRefKey1(po.getRefKey1());
        bo.setRefKey2(po.getRefKey2());
        return bo;
    };

    @Override
    public PageResult<TinyMailPlain> listAll(PageQuery pq) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winMailSenderDao, (PageQuery)pq).count().from(new TableLike[]{t}).whereTrue().order(this.sortsFields, new OrderField[]{t.Id.desc()}).fetch(this.plainFields).into(this.mapper);
    }

    @Override
    public PageResult<TinyMailPlain> listFailed(PageQuery pq) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winMailSenderDao, (PageQuery)pq).count().from(new TableLike[]{t}).where(t.SumDone.eq((Object)0).and(t.SumFail.gt((Object)0))).order(this.sortsFields, new OrderField[]{t.Id.desc()}).fetch(this.plainFields).into(this.mapper);
    }

    @Override
    public PageResult<TinyMailPlain> listUndone(PageQuery pq) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winMailSenderDao, (PageQuery)pq).count().from(new TableLike[]{t}).where(t.SumDone.eq((Object)0)).order(this.sortsFields, new OrderField[]{t.Id.desc()}).fetch(this.plainFields).into(this.mapper);
    }

    @Override
    public PageResult<TinyMailPlain> listByBizMark(String mark, PageQuery pq) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winMailSenderDao, (PageQuery)pq).count().from(new TableLike[]{t}).where(WingsJooqUtil.condMatch((String)mark, (Field[])new Field[]{t.MailMark})).order(this.sortsFields, new OrderField[]{t.Id.desc()}).fetch(this.plainFields).into(this.mapper);
    }

    @Override
    public PageResult<TinyMailPlain> listByRecipient(String mailRegex, PageQuery pq) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        Condition cond = WingsJooqUtil.concatWs((String)",", (Object[])new Object[]{t.MailTo, t.MailCc, t.MailBcc}).likeRegex(mailRegex);
        return PageJooqHelper.use((DAOImpl)this.winMailSenderDao, (PageQuery)pq).count().from(new TableLike[]{t}).where(cond).order(this.sortsFields, new OrderField[]{t.Id.desc()}).fetch(this.plainFields).into(this.mapper);
    }

    @Override
    public PageResult<TinyMailPlain> listBySender(String mail, PageQuery pq) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winMailSenderDao, (PageQuery)pq).count().from(new TableLike[]{t}).where(t.MailFrom.eq((Object)mail)).order(this.sortsFields, new OrderField[]{t.Id.desc()}).fetch(this.plainFields).into(this.mapper);
    }

    @Override
    public PageResult<TinyMailPlain> listBySubject(String subjRegex, PageQuery pq) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winMailSenderDao, (PageQuery)pq).count().from(new TableLike[]{t}).where(t.MailSubj.eq((Object)subjRegex)).order(this.sortsFields, new OrderField[]{t.Id.desc()}).fetch(this.plainFields).into(this.mapper);
    }

    @Override
    public TinyMailPlain loadDetail(long id) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        return (TinyMailPlain)this.winMailSenderDao.ctx().selectFrom((TableLike)t).where(t.Id.eq((Object)id)).fetchOne(this.mapper);
    }

    public void afterPropertiesSet() {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        this.plainFields = new SelectField[]{t.Id, t.MailApps, t.MailRuns, t.MailConf, t.MailFrom, t.MailTo, t.MailCc, t.MailBcc, t.MailReply, t.MailSubj, t.MailFile, t.MailHtml, t.MailMark, t.MailDate, t.CreateDt, t.LastSend, t.LastDone, t.NextSend, t.SumSend, t.SumFail, t.SumDone, t.MaxFail, t.MaxDone};
        this.sortsFields.put("id", (Field<?>)t.Id);
        this.sortsFields.put("done", (Field<?>)t.LastDone);
        this.sortsFields.put("fail", (Field<?>)t.LastFail);
    }

    @Autowired
    public void setWinMailSenderDao(WinMailSenderDao winMailSenderDao) {
        this.winMailSenderDao = winMailSenderDao;
    }
}

