/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.controller;

import io.swagger.v3.oas.annotations.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.Q;
import pro.fessional.mirana.data.R;
import pro.fessional.mirana.page.PageQuery;
import pro.fessional.mirana.page.PageResult;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.mail.service.TinyMailListService;
import pro.fessional.wings.tiny.mail.service.TinyMailPlain;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.tiny.mail.mvc-list")
public class MailListController {
    protected TinyMailListService tinyMailListService;

    @Operation(summary="list summary of all messages, in reverse order by default.")
    @PostMapping(value={"${wings.tiny.mail.urlmap.list-all}"})
    @ResponseBody
    public PageResult<TinyMailPlain> listAll(PageQuery pq) {
        return this.tinyMailListService.listAll(pq);
    }

    @Operation(summary="list summary of failed emails, in reverse order by default.")
    @PostMapping(value={"${wings.tiny.mail.urlmap.list-failed}"})
    @ResponseBody
    public PageResult<TinyMailPlain> listFailed(PageQuery pq) {
        return this.tinyMailListService.listFailed(pq);
    }

    @Operation(summary="list summary of unsuccessful emails, in reverse order by default.")
    @PostMapping(value={"${wings.tiny.mail.urlmap.list-undone}"})
    @ResponseBody
    public PageResult<TinyMailPlain> listUndone(PageQuery pq) {
        return this.tinyMailListService.listUndone(pq);
    }

    @Operation(summary="find summary of the email by Biz-Mark, in reverse order by default.")
    @PostMapping(value={"${wings.tiny.mail.urlmap.by-bizmark}"})
    @ResponseBody
    public PageResult<TinyMailPlain> byBizMark(@RequestBody Q<String> q, PageQuery pq) {
        return this.tinyMailListService.listByBizMark((String)q.getQ(), pq);
    }

    @Operation(summary="find summary of the email by RegExp of to/cc/bcc, reverse order by default.")
    @PostMapping(value={"${wings.tiny.mail.urlmap.by-recipient}"})
    @ResponseBody
    public PageResult<TinyMailPlain> byRecipient(@RequestBody Q<String> q, PageQuery pq) {
        return this.tinyMailListService.listByRecipient((String)q.getQ(), pq);
    }

    @Operation(summary="find summary of the email by from, in reverse order by default.")
    @PostMapping(value={"${wings.tiny.mail.urlmap.by-sender}"})
    @ResponseBody
    public PageResult<TinyMailPlain> bySender(@RequestBody Q<String> q, PageQuery pq) {
        return this.tinyMailListService.listBySender((String)q.getQ(), pq);
    }

    @Operation(summary="find summary of the email by RegExp of subject, reverse order by default.")
    @PostMapping(value={"${wings.tiny.mail.urlmap.by-subject}"})
    @ResponseBody
    public PageResult<TinyMailPlain> bySubject(@RequestBody Q<String> q, PageQuery pq) {
        return this.tinyMailListService.listBySubject((String)q.getQ(), pq);
    }

    @Operation(summary="get mail detail", description="# Usage\nget mail detail\n## Params\n* @param id - required, Mailid\n")
    @PostMapping(value={"${wings.tiny.mail.urlmap.load-detail}"})
    @ResponseBody
    public R<TinyMailPlain> loadDetail(@RequestBody Q.Id ins) {
        return R.okData((Object)this.tinyMailListService.loadDetail(ins.getId()));
    }

    @Autowired
    public void setTinyMailListService(TinyMailListService tinyMailListService) {
        this.tinyMailListService = tinyMailListService;
    }
}

