/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.sender;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pro.fessional.wings.silencer.notice.SmallNotice;
import pro.fessional.wings.tiny.mail.sender.MailConfigProvider;
import pro.fessional.wings.tiny.mail.sender.MailSenderManager;
import pro.fessional.wings.tiny.mail.sender.TinyMailConfig;
import pro.fessional.wings.tiny.mail.sender.TinyMailMessage;

public class MailNotice
implements SmallNotice<TinyMailConfig>,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailNotice.class);
    @NotNull
    protected final MailConfigProvider configProvider;
    @NotNull
    protected final MailSenderManager senderManager;
    private Executor executor;
    private Map<String, TinyMailConfig> configs = Collections.emptyMap();

    @NotNull
    public TinyMailConfig defaultConfig() {
        return this.configProvider.defaultConfig();
    }

    public TinyMailConfig combineConfig(@Nullable TinyMailConfig that) {
        return this.configProvider.combineConfig(that);
    }

    public TinyMailConfig provideConfig(@Nullable String name, boolean combine) {
        TinyMailConfig conf = this.configProvider.bynamedConfig(name);
        if (combine) {
            return this.combineConfig(conf == null ? this.configProvider.defaultConfig() : conf);
        }
        return conf;
    }

    public boolean send(TinyMailConfig config, String subject, String content) {
        TinyMailMessage message = new TinyMailMessage();
        message.adopt(config);
        message.setSubject(subject);
        message.setContent(content);
        this.senderManager.singleSend(message);
        return true;
    }

    public boolean post(TinyMailConfig config, String subject, String content) {
        try {
            return this.send(config, subject, content);
        }
        catch (Exception e) {
            log.error("failed to post mail notice", (Throwable)e);
            return false;
        }
    }

    public void emit(TinyMailConfig config, String subject, String content) {
        this.executor.execute(() -> this.send(config, subject, content));
    }

    public void afterPropertiesSet() {
        if (this.executor == null) {
            log.warn("should reuse autowired thread pool");
            this.executor = Executors.newSingleThreadExecutor();
        }
    }

    @Generated
    public MailNotice(@NotNull MailConfigProvider configProvider, @NotNull MailSenderManager senderManager) {
        if (configProvider == null) {
            throw new NullPointerException("configProvider is marked non-null but is null");
        }
        if (senderManager == null) {
            throw new NullPointerException("senderManager is marked non-null but is null");
        }
        this.configProvider = configProvider;
        this.senderManager = senderManager;
    }

    @NotNull
    @Generated
    public MailConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    @NotNull
    @Generated
    public MailSenderManager getSenderManager() {
        return this.senderManager;
    }

    @Autowired(required=false)
    @Qualifier(value="taskScheduler")
    @Generated
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Generated
    public void setConfigs(Map<String, TinyMailConfig> configs) {
        this.configs = configs;
    }

    @Generated
    public Map<String, TinyMailConfig> getConfigs() {
        return this.configs;
    }
}

