/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.sender;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.mail.MailAuthenticationException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import pro.fessional.mirana.time.Sleep;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.convention.EmptySugar;
import pro.fessional.wings.tiny.mail.sender.MailSenderProvider;
import pro.fessional.wings.tiny.mail.sender.MailWaitException;
import pro.fessional.wings.tiny.mail.sender.TinyMailConfig;
import pro.fessional.wings.tiny.mail.sender.TinyMailMessage;
import pro.fessional.wings.tiny.mail.spring.prop.TinyMailSenderProp;

public class MailSenderManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailSenderManager.class);
    protected final TinyMailSenderProp senderProp;
    protected final MailSenderProvider senderProvider;
    protected final ConcurrentHashMap<String, Long> mailHostWait = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Long> mailHostIdle = new ConcurrentHashMap();

    public void removeHostWait(String host) {
        this.mailHostWait.remove(host);
    }

    public void removeCachingSender(String name) {
        this.senderProvider.removeCaching(name);
    }

    public Map<String, Long> listHostWait() {
        return new HashMap<String, Long>(this.mailHostWait);
    }

    public void singleSend(@NotNull TinyMailMessage message) {
        this.singleSend(message, 0L, null);
    }

    public void checkMessage(@NotNull TinyMailMessage message) {
        JavaMailSender sender = this.senderProvider.singletonSender(message);
        this.prepareMimeMessage(message, null, sender);
    }

    public void singleSend(@NotNull TinyMailMessage message, long maxWait) {
        this.singleSend(message, maxWait, null);
    }

    public void singleSend(@NotNull TinyMailMessage message, @Nullable MimeMessagePrepareHelper preparer) {
        this.singleSend(message, 0L, preparer);
    }

    public void singleSend(@NotNull TinyMailMessage message, long maxWait, @Nullable MimeMessagePrepareHelper preparer) {
        String host = message.getHost();
        this.checkHostWaitOrIdle(host, maxWait);
        JavaMailSender sender = this.senderProvider.singletonSender(message);
        MimeMessage mimeMessage = this.prepareMimeMessage(message, preparer, sender);
        if (this.isDryrun(message)) {
            long slp = Sleep.ignoreInterrupt((long)10L, (long)2000L);
            log.info("single mail dryrun and sleep {} ms", (Object)slp);
            return;
        }
        long now = -1L;
        try {
            sender.send(mimeMessage);
        }
        catch (Exception me) {
            now = ThreadNow.millis();
            Wait wt = this.dealErrorWait(me, now);
            if (wt != null) {
                if (wt.host) {
                    this.mailHostWait.put(host, wt.wait);
                }
                log.warn("failed to send and host wait for " + (wt.wait - now) + "ms, message=" + message.toMainString(), (Throwable)me);
                throw new MailWaitException(wt.wait, wt.host, wt.stop, me);
            }
            log.warn("failed to send message= " + message.toMainString(), (Throwable)me);
            throw me;
        }
        finally {
            this.treatHostIdle(host, now);
        }
    }

    public List<BatchResult> batchSend(Collection<? extends TinyMailMessage> messages) {
        return this.batchSend(messages, 0L, null);
    }

    public List<BatchResult> batchSend(Collection<? extends TinyMailMessage> messages, long maxWait) {
        return this.batchSend(messages, maxWait, null);
    }

    public List<BatchResult> batchSend(Collection<? extends TinyMailMessage> messages, @Nullable MimeMessagePrepareHelper preparer) {
        return this.batchSend(messages, 0L, preparer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BatchResult> batchSend(Collection<? extends TinyMailMessage> messages, long maxWait, @Nullable MimeMessagePrepareHelper preparer) {
        if (messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BatchResult> results = new ArrayList<BatchResult>(messages.size());
        for (String host : messages.stream().map(MailProperties::getHost).collect(Collectors.toSet())) {
            this.checkHostWaitOrIdle(host, maxWait);
        }
        HashMap<JavaMailSender, ArrayList> senderGroup = new HashMap<JavaMailSender, ArrayList>();
        int dryrunCount = 0;
        for (TinyMailMessage tinyMailMessage : messages) {
            BatchResult temp = new BatchResult();
            temp.tinyMessage = tinyMailMessage;
            temp.costMillis = 0L;
            try {
                temp.mailSender = this.senderProvider.singletonSender(tinyMailMessage);
                temp.mimeMessage = this.prepareMimeMessage(tinyMailMessage, preparer, temp.mailSender);
            }
            catch (Exception e) {
                temp.exception = e;
            }
            results.add(temp);
            if (temp.mimeMessage == null) continue;
            if (this.isDryrun(tinyMailMessage)) {
                temp.costMillis = -1L;
                ++dryrunCount;
                continue;
            }
            senderGroup.computeIfAbsent(temp.mailSender, ignored -> new ArrayList()).add(temp);
        }
        if (dryrunCount > 0) {
            long slp = Sleep.ignoreInterrupt((long)10L, (long)2000L);
            log.info("batch mail dryrun and sleep {} ms", (Object)slp);
            long avg = slp / (long)dryrunCount;
            for (BatchResult rst : results) {
                if (rst.costMillis >= 0L) continue;
                rst.costMillis = avg;
            }
        }
        for (Map.Entry entry : senderGroup.entrySet()) {
            long avg;
            long now;
            long start;
            HashSet<String> hosts;
            int len;
            List result;
            block27: {
                JavaMailSender sender = (JavaMailSender)entry.getKey();
                result = (List)entry.getValue();
                if (result.isEmpty()) continue;
                len = result.size();
                MimeMessage[] mineMessages = new MimeMessage[len];
                hosts = new HashSet<String>();
                for (int i = 0; i < len; ++i) {
                    BatchResult temp = (BatchResult)result.get(i);
                    mineMessages[i] = temp.mimeMessage;
                    hosts.add(temp.tinyMessage.getHost());
                }
                start = ThreadNow.millis();
                now = -1L;
                try {
                    sender.send(mineMessages);
                    if (now >= 0L) break block27;
                }
                catch (Exception me) {
                    block28: {
                        try {
                            now = ThreadNow.millis();
                            Wait wt = this.dealErrorWait(me, now);
                            if (wt != null) {
                                for (String string : hosts) {
                                    this.mailHostWait.put(string, wt.wait);
                                }
                                log.warn("failed to send and host wait for " + (wt.wait - now) + "ms, hosts=" + String.valueOf(hosts), (Throwable)me);
                            }
                            if (me instanceof MailSendException) {
                                Map fms = ((MailSendException)me).getFailedMessages();
                                for (BatchResult br : result) {
                                    Exception ex = (Exception)fms.get(br.mimeMessage);
                                    if (ex == null) continue;
                                    br.exception = wt != null ? new MailWaitException(wt.wait, wt.host, wt.stop, ex) : ex;
                                }
                            } else {
                                Object mw = wt != null ? new MailWaitException(wt.wait, wt.host, wt.stop, me) : me;
                                for (BatchResult br : result) {
                                    br.exception = mw;
                                }
                            }
                            if (now >= 0L) break block28;
                        }
                        catch (Throwable throwable) {
                            if (now < 0L) {
                                now = ThreadNow.millis();
                            }
                            long avg2 = (now - start) / (long)len;
                            for (BatchResult br : result) {
                                br.costMillis = avg2;
                                br.doneMillis = now;
                                if (br.exception == null) continue;
                                log.warn("failed to batch send message, " + br.tinyMessage.toMainString());
                            }
                            for (String host : hosts) {
                                this.treatHostIdle(host, now);
                            }
                            throw throwable;
                        }
                        now = ThreadNow.millis();
                    }
                    avg = (now - start) / (long)len;
                    for (BatchResult batchResult : result) {
                        batchResult.costMillis = avg;
                        batchResult.doneMillis = now;
                        if (batchResult.exception == null) continue;
                        log.warn("failed to batch send message, " + batchResult.tinyMessage.toMainString());
                    }
                    for (String string : hosts) {
                        this.treatHostIdle(string, now);
                    }
                    continue;
                }
                now = ThreadNow.millis();
            }
            avg = (now - start) / (long)len;
            for (BatchResult batchResult : result) {
                batchResult.costMillis = avg;
                batchResult.doneMillis = now;
                if (batchResult.exception == null) continue;
                log.warn("failed to batch send message, " + batchResult.tinyMessage.toMainString());
            }
            for (String string : hosts) {
                this.treatHostIdle(string, now);
            }
        }
        return results;
    }

    private boolean isDryrun(TinyMailMessage message) {
        String dr;
        boolean dryrun = this.senderProp.isDryrun();
        if (!dryrun && (dr = message.getDryrun()) != null && !dr.isEmpty()) {
            String title = message.getSubject();
            boolean bl = dryrun = title != null && title.startsWith(dr);
        }
        if (dryrun) {
            log.info("mail-send dryrun. subject={}, bizId={}", (Object)message.subject, (Object)message.bizId);
        }
        return dryrun;
    }

    private void treatHostIdle(String host, long now) {
        long idle = this.senderProp.getPerIdle().getOrDefault(host, Duration.ZERO).toMillis();
        if (idle > 0L) {
            if (now < 0L) {
                now = ThreadNow.millis();
            }
            this.mailHostIdle.put(host, now + idle);
        }
    }

    private void checkHostWaitOrIdle(String host, long maxWait) {
        Long idle;
        long perIdle;
        Long wait = this.mailHostWait.get(host);
        long now = -1L;
        if (wait != null) {
            now = ThreadNow.millis();
            if (wait > now) {
                log.warn("mail need wait {}ms, host={}", (Object)host, (Object)(wait - now));
                throw new MailWaitException(wait, true, false, null);
            }
            this.mailHostWait.remove(host);
        }
        if ((perIdle = this.senderProp.getPerIdle().getOrDefault(host, Duration.ZERO).toMillis()) > 0L && (idle = this.mailHostIdle.get(host)) != null && idle > 0L) {
            if (now < 0L) {
                now = ThreadNow.millis();
            }
            if (idle > now) {
                long maxIdle = maxWait > 0L ? maxWait : this.senderProp.getMaxIdle().getOrDefault(host, Duration.ZERO).toMillis();
                long tm = idle - now;
                log.warn("mail need idle {}ms, host={} ", (Object)host, (Object)tm);
                if (maxIdle > 0L && idle > now + maxIdle) {
                    throw new MailWaitException(idle, true, false, null);
                }
                Sleep.ignoreInterrupt((long)tm);
            }
            this.mailHostIdle.put(host, 0L);
        }
    }

    private MimeMessage prepareMimeMessage(TinyMailMessage message, MimeMessagePrepareHelper preparer, JavaMailSender sender) throws MessagingException {
        String bizMark;
        Map<String, Resource> files;
        String[] fcc;
        if (sender == null) {
            sender = this.senderProvider.singletonSender(message);
        }
        MimeMessage mineMessage = sender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mineMessage, true);
        String[] fto = this.senderProp.getForceTo();
        if (fto != null && fto.length > 0) {
            helper.setTo(fto);
        } else {
            String[] to = message.getTo();
            helper.setTo(to);
        }
        String from = message.getFrom();
        if (StringUtils.isNotEmpty((CharSequence)from)) {
            helper.setFrom(from);
        }
        if ((fcc = this.senderProp.getForceCc()) != null && fcc.length > 0) {
            helper.setCc(fcc);
        } else {
            String[] cc = message.getCc();
            if (cc != null) {
                helper.setCc(cc);
            }
        }
        String[] fbcc = this.senderProp.getForceBcc();
        if (fbcc != null && fbcc.length > 0) {
            helper.setBcc(fbcc);
        } else {
            String[] bcc = message.getBcc();
            if (bcc != null) {
                helper.setBcc(bcc);
            }
        }
        String reply = message.getReply();
        if (StringUtils.isNotEmpty((CharSequence)reply)) {
            helper.setReplyTo(reply);
        }
        if ((files = message.getAttachment()) != null) {
            for (Map.Entry<String, Resource> en : files.entrySet()) {
                helper.addAttachment(en.getKey(), (InputStreamSource)en.getValue());
            }
        }
        String fpre = this.senderProp.getForcePrefix();
        String subject = EmptySugar.nullToEmpty((String)message.getSubject());
        if (fpre != null && !fpre.isEmpty()) {
            helper.setSubject(fpre + " " + subject);
        } else {
            helper.setSubject(subject);
        }
        helper.setText(EmptySugar.nullToEmpty((String)message.getContent()), message.asHtml());
        String bizId = this.senderProp.getBizId();
        if (StringUtils.isNotEmpty((CharSequence)bizId) && message.getBizId() != null) {
            mineMessage.addHeader(bizId, String.valueOf(message.getBizId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(bizMark = this.senderProp.getBizMark())) && StringUtils.isNotEmpty((CharSequence)message.getBizMark())) {
            mineMessage.addHeader(bizMark, message.getBizMark());
        }
        if (preparer != null) {
            preparer.prepare(message, helper);
        }
        return mineMessage;
    }

    private Wait dealErrorWait(Exception me, long now) {
        Duration dur;
        String msg = me.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            for (Map.Entry<BigDecimal, String> en : this.senderProp.getErrHost().entrySet()) {
                if (!msg.contains(en.getValue())) continue;
                return Wait.host(now, en.getKey().longValue() * 1000L);
            }
            for (Map.Entry<BigDecimal, String> en : this.senderProp.getErrMail().entrySet()) {
                if (!msg.contains(en.getValue())) continue;
                return Wait.mail(now, en.getKey().longValue() * 1000L);
            }
        }
        if (me instanceof MailAuthenticationException && (dur = this.senderProp.getErrAuth()) != null) {
            return Wait.mail(now, dur.toMillis());
        }
        if (me instanceof MailSendException && (dur = this.senderProp.getErrSend()) != null) {
            return Wait.mail(now, dur.toMillis());
        }
        return null;
    }

    @Generated
    public MailSenderManager(TinyMailSenderProp senderProp, MailSenderProvider senderProvider) {
        this.senderProp = senderProp;
        this.senderProvider = senderProvider;
    }

    @Generated
    public TinyMailSenderProp getSenderProp() {
        return this.senderProp;
    }

    @Generated
    public MailSenderProvider getSenderProvider() {
        return this.senderProvider;
    }

    public static interface MimeMessagePrepareHelper {
        public void prepare(TinyMailConfig var1, MimeMessageHelper var2) throws MessagingException;
    }

    private static class Wait {
        private final long wait;
        private final boolean host;
        private final boolean stop;

        public Wait(long wait, boolean host, boolean stop) {
            this.wait = wait;
            this.host = host;
            this.stop = stop;
        }

        private static Wait host(long now, long dur) {
            return new Wait(now + Math.abs(dur), true, dur < 0L);
        }

        private static Wait mail(long now, long dur) {
            return new Wait(now + Math.abs(dur), false, dur < 0L);
        }
    }

    public static class BatchResult {
        private TinyMailMessage tinyMessage;
        private long costMillis = 0L;
        private long doneMillis = 0L;
        private Exception exception;
        private JavaMailSender mailSender;
        private MimeMessage mimeMessage;

        @Generated
        public TinyMailMessage getTinyMessage() {
            return this.tinyMessage;
        }

        @Generated
        public long getCostMillis() {
            return this.costMillis;
        }

        @Generated
        public long getDoneMillis() {
            return this.doneMillis;
        }

        @Generated
        public Exception getException() {
            return this.exception;
        }
    }
}

