/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.sender;

import jakarta.mail.Session;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import pro.fessional.wings.tiny.mail.sender.TinyMailConfig;

public class MailSenderProvider {
    @NotNull
    private final JavaMailSender defaultSender;
    private final ConcurrentHashMap<String, JavaMailSender> senders = new ConcurrentHashMap();

    public MailSenderProvider(@NotNull JavaMailSender defaultSender) {
        this.defaultSender = defaultSender;
        this.senders.put("default", defaultSender);
    }

    @NotNull
    public JavaMailSender defaultSender() {
        return this.defaultSender;
    }

    @NotNull
    public JavaMailSender singletonSender(@NotNull TinyMailConfig config) {
        String name = config.getName();
        return name == null || name.isEmpty() ? this.defaultSender : this.senders.computeIfAbsent(name, ignored -> this.newSender(config));
    }

    public JavaMailSender removeCaching(TinyMailConfig config) {
        if (config == null) {
            return null;
        }
        return this.senders.remove(config.getName());
    }

    public JavaMailSender removeCaching(String name) {
        if (name == null) {
            return null;
        }
        return this.senders.remove(name);
    }

    @NotNull
    public JavaMailSender newSender(MailProperties prop) {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        String jndiName = prop.getJndiName();
        if (StringUtils.isNotEmpty((CharSequence)jndiName)) {
            try {
                Session session = (Session)JndiLocatorDelegate.createDefaultResourceRefLocator().lookup(jndiName, Session.class);
                sender.setDefaultEncoding(prop.getDefaultEncoding().name());
                sender.setSession(session);
            }
            catch (NamingException ex) {
                throw new IllegalStateException("Unable to find Session in JNDI location " + jndiName, ex);
            }
        } else {
            Map mailProp;
            sender.setHost(prop.getHost());
            if (prop.getPort() != null) {
                sender.setPort(prop.getPort().intValue());
            }
            sender.setUsername(prop.getUsername());
            sender.setPassword(prop.getPassword());
            sender.setProtocol(prop.getProtocol());
            if (prop.getDefaultEncoding() != null) {
                sender.setDefaultEncoding(prop.getDefaultEncoding().name());
            }
            if (!(mailProp = prop.getProperties()).isEmpty()) {
                Properties pp = new Properties();
                pp.putAll((Map<?, ?>)mailProp);
                sender.setJavaMailProperties(pp);
            }
        }
        return sender;
    }
}

