/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.mail.MessagingException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailSendException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.pain.ThrowableUtil;
import pro.fessional.mirana.time.DateLocaling;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.convention.EmptyValue;
import pro.fessional.wings.faceless.service.journal.JournalAware;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.silencer.modulate.RunMode;
import pro.fessional.wings.silencer.modulate.RuntimeMode;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.spring.help.CommonPropHelper;
import pro.fessional.wings.slardar.jackson.JacksonHelper;
import pro.fessional.wings.tiny.mail.database.autogen.tables.WinMailSenderTable;
import pro.fessional.wings.tiny.mail.database.autogen.tables.daos.WinMailSenderDao;
import pro.fessional.wings.tiny.mail.database.autogen.tables.pojos.WinMailSender;
import pro.fessional.wings.tiny.mail.sender.MailConfigProvider;
import pro.fessional.wings.tiny.mail.sender.MailSenderManager;
import pro.fessional.wings.tiny.mail.sender.MailWaitException;
import pro.fessional.wings.tiny.mail.sender.TinyMailConfig;
import pro.fessional.wings.tiny.mail.sender.TinyMailMessage;
import pro.fessional.wings.tiny.mail.service.TinyMail;
import pro.fessional.wings.tiny.mail.service.TinyMailPlain;
import pro.fessional.wings.tiny.mail.service.TinyMailService;
import pro.fessional.wings.tiny.mail.spring.prop.TinyMailServiceProp;

@Service
@ConditionalWingsEnabled
public class TinyMailServiceImpl
implements TinyMailService,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyMailServiceImpl.class);
    protected String appName;
    protected LightIdService lightIdService;
    protected JournalService journalService;
    protected WinMailSenderDao winMailSenderDao;
    protected MailConfigProvider mailConfigProvider;
    protected MailSenderManager mailSenderManager;
    protected TinyMailServiceProp tinyMailServiceProp;
    protected ResourceLoader resourceLoader;
    protected List<TinyMailService.StatusHook> statusHooks;
    private ThreadPoolTaskScheduler taskScheduler;
    private final PriorityBlockingQueue<AsyncMail> asyncMails = new PriorityBlockingQueue();

    @Override
    public boolean send(@NotNull TinyMail message, boolean retry) {
        String conf = message.getConf();
        TinyMailConfig config = this.mailConfigProvider.bynamedConfig(conf);
        AssertArgs.notNull((Object)((Object)config), (String)"mail conf={} not found", (Object[])new Object[]{conf});
        WinMailSender po = this.saveMailSender(config, message);
        TinyMailMessage mailMessage = this.makeMailMessage(config, po, message);
        return this.doSyncSend(po, mailMessage, retry, true);
    }

    @Override
    public boolean post(@NotNull TinyMail message, boolean retry) {
        try {
            return this.send(message, retry);
        }
        catch (Exception e) {
            log.error("fail to post mail, subject=" + message.getSubject(), (Throwable)e);
            return false;
        }
    }

    @Override
    public long emit(@NotNull TinyMail message, boolean retry) {
        String conf = message.getConf();
        TinyMailConfig config = this.mailConfigProvider.bynamedConfig(conf);
        AssertArgs.notNull((Object)((Object)config), (String)"mail conf={} not found", (Object[])new Object[]{conf});
        WinMailSender po = this.saveMailSender(config, message);
        TinyMailMessage mailMessage = this.makeMailMessage(config, po, message);
        return this.doAsyncFreshSend(po, mailMessage, retry, true);
    }

    @Override
    public boolean send(long id, boolean retry, boolean check) {
        WinMailSender po = this.winMailSenderDao.fetchOneById(id);
        if (po == null) {
            log.warn("mail not found by id={}, skip send", (Object)id);
            return false;
        }
        String conf = po.getMailConf();
        TinyMailConfig config = this.mailConfigProvider.bynamedConfig(conf);
        if (config == null) {
            log.warn("mail conf={} not found", (Object)conf);
            return false;
        }
        TinyMailMessage mailMessage = this.makeMailMessage(config, po, null);
        return this.doSyncSend(po, mailMessage, retry, check);
    }

    @Override
    public boolean post(long id, boolean retry, boolean check) {
        try {
            return this.send(id, retry, check);
        }
        catch (Exception e) {
            log.error("fail to post mail, id=" + id, (Throwable)e);
            return false;
        }
    }

    @Override
    public long emit(long id, boolean retry, boolean check) {
        WinMailSender po = this.winMailSenderDao.fetchOneById(id);
        if (po == null) {
            log.warn("mail not found by id={}, skip emit", (Object)id);
            return -1L;
        }
        return this.doAsyncFreshSend(po, null, retry, check);
    }

    @Override
    public long save(@NotNull TinyMailPlain msg) {
        long id;
        String conf = msg.getConf();
        TinyMailConfig config = this.mailConfigProvider.bynamedConfig(conf);
        AssertArgs.notNull((Object)((Object)config), (String)"mail conf={} not found", (Object[])new Object[]{conf});
        WinMailSender po = new WinMailSender();
        boolean isNew = msg.getId() == null || msg.getId() <= 0L;
        RunMode rm = RuntimeMode.getRunMode();
        String crm = rm == RunMode.Nothing ? "" : rm.name().toLowerCase();
        LocalDateTime md = msg.getDate();
        if (isNew) {
            id = this.lightIdService.getId((LightIdAware)this.winMailSenderDao.getTable());
            po.setNextLock(0);
            po.setNextSend(md != null ? md : ThreadNow.localDateTime());
            po.setSumSend(0);
            po.setSumFail(0);
            po.setSumDone(0);
        } else {
            id = msg.getId();
            Null.notNull((Object)msg.getNextSend(), po::setNextSend);
        }
        po.setId(id);
        po.setMailApps(this.toString(msg.getApps(), this.appName));
        po.setMailRuns(this.toString(msg.getRuns(), crm));
        po.setMailConf(msg.getConf());
        po.setMailFrom(this.toString(msg.getFrom(), config.getFrom()));
        po.setMailTo(this.toString(msg.getTo(), config.getTo()));
        po.setMailCc(this.toString(msg.getCc(), config.getCc()));
        po.setMailBcc(this.toString(msg.getBcc(), config.getBcc()));
        po.setMailReply(this.toString(msg.getReply(), config.getReply()));
        po.setMailSubj(msg.getSubject());
        po.setMailText(msg.getContent());
        po.setMailHtml((Boolean)BoxedCastUtil.orElse((Object)msg.getHtml(), (Object)config.getHtml()));
        po.setMailFile(this.toStringMap(msg.getAttachment()));
        po.setMailMark(msg.getMark());
        po.setMailDate(md);
        Null.notNull((Object)msg.getMaxFail(), po::setMaxFail);
        Null.notNull((Object)msg.getMaxDone(), po::setMaxDone);
        Null.notNull((Object)msg.getRefType(), po::setRefType);
        Null.notNull((Object)msg.getRefKey1(), po::setRefKey1);
        Null.notNull((Object)msg.getRefKey2(), po::setRefKey2);
        TinyMailMessage tms = this.makeMailMessage(config, po, null);
        this.mailSenderManager.checkMessage(tms);
        this.journalService.commit((Enum)Jane.Insert, journal -> {
            if (isNew) {
                journal.create((JournalAware)po);
                this.winMailSenderDao.insert(po);
            } else {
                journal.modify((JournalAware)po);
                this.winMailSenderDao.update(po, false);
            }
        });
        return id;
    }

    @Override
    public int scan() {
        long now = ThreadNow.millis();
        LocalDateTime min = DateLocaling.sysLdt((long)(now - this.tinyMailServiceProp.getMaxNext().toMillis()));
        LocalDateTime max = DateLocaling.sysLdt((long)(now + this.tinyMailServiceProp.getTryNext().toMillis()));
        log.info("scan misfire-mail to queue, min={}, max={}", (Object)min, (Object)max);
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        List<AsyncMail> pos = this.winMailSenderDao.ctx().selectFrom((TableLike)t).where(t.NextSend.gt((Object)min).and(t.NextSend.lt((Object)max))).fetch().into(WinMailSender.class).stream().filter(po -> !this.notMatchProp((WinMailSender)po)).map(it -> new AsyncMail(it.getId(), DateLocaling.sysEpoch((LocalDateTime)it.getNextSend()), true, true, (WinMailSender)it, null)).toList();
        int size = pos.size();
        log.info("plan misfire-mail, size={}", (Object)size);
        if (size > 0) {
            this.asyncMails.addAll(pos);
            this.taskScheduler.schedule(this::doAsyncBatchSend, Instant.ofEpochMilli(now));
        }
        return size;
    }

    public void afterPropertiesSet() {
        long bms = this.tinyMailServiceProp.getBootScan().toMillis();
        if (bms > 0L) {
            this.taskScheduler.schedule(this::scan, Instant.ofEpochMilli(ThreadNow.millis() + bms));
        }
    }

    private TinyMailMessage makeMailMessage(@NotNull TinyMailConfig config, @NotNull WinMailSender po, @Nullable TinyMail msg) {
        TinyMailMessage message = new TinyMailMessage();
        message.adopt(config);
        message.setBizId(po.getId());
        if (msg == null) {
            message.setFrom(po.getMailFrom());
            message.setTo(CommonPropHelper.arrayOrNull((String)po.getMailTo(), (boolean)true));
            message.setCc(CommonPropHelper.arrayOrNull((String)po.getMailCc(), (boolean)true));
            message.setBcc(CommonPropHelper.arrayOrNull((String)po.getMailBcc(), (boolean)true));
            message.setReply(this.toStrOrNull(po.getMailReply()));
            message.setHtml(po.getMailHtml());
            message.setSubject(po.getMailSubj());
            message.setContent(po.getMailText());
            Map<String, Resource> files = this.toResource(po.getMailFile());
            if (!files.isEmpty()) {
                message.setAttachment(files);
            }
            message.setBizMark(this.toStrOrNull(po.getMailMark()));
        } else {
            if (msg.getFrom() != null) {
                message.setFrom(msg.getFrom());
            }
            if (msg.getTo() != null) {
                message.setTo(msg.getTo());
            }
            if (msg.getCc() != null) {
                message.setCc(msg.getCc());
            }
            if (msg.getBcc() != null) {
                message.setBcc(msg.getBcc());
            }
            if (msg.getReply() != null) {
                message.setReply(msg.getReply());
            }
            if (msg.getHtml() != null) {
                message.setHtml(msg.getHtml());
            }
            message.setSubject(msg.getSubject());
            message.setContent(msg.getContent());
            message.setAttachment(msg.getAttachment());
            message.setBizMark(msg.getMark());
        }
        return message;
    }

    private WinMailSender saveMailSender(@NotNull TinyMailConfig config, @NotNull TinyMail msg) {
        WinMailSender po = new WinMailSender();
        long id = this.lightIdService.getId((LightIdAware)this.winMailSenderDao.getTable());
        po.setId(id);
        po.setMailApps(this.appName);
        RunMode rm = RuntimeMode.getRunMode();
        po.setMailRuns(rm == RunMode.Nothing ? "" : rm.name().toLowerCase());
        po.setMailConf(config.getName());
        po.setMailFrom(this.toString(msg.getFrom(), config.getFrom()));
        po.setMailTo(this.toString(msg.getTo(), config.getTo()));
        po.setMailCc(this.toString(msg.getCc(), config.getCc()));
        po.setMailBcc(this.toString(msg.getBcc(), config.getBcc()));
        po.setMailReply(this.toString(msg.getReply(), config.getReply()));
        po.setMailSubj(msg.getSubject());
        po.setMailText(msg.getContent());
        po.setMailHtml((Boolean)BoxedCastUtil.orElse((Object)msg.getHtml(), (Object)config.getHtml()));
        po.setMailFile(this.toString(msg.getAttachment()));
        po.setMailMark(msg.getMark());
        LocalDateTime md = msg.getDate();
        po.setMailDate(md);
        po.setMaxFail(BoxedCastUtil.orElse((Integer)msg.getMaxFail(), (int)this.tinyMailServiceProp.getMaxFail()));
        po.setMaxDone(BoxedCastUtil.orElse((Integer)msg.getMaxDone(), (int)this.tinyMailServiceProp.getMaxDone()));
        Null.notNull((Object)msg.getRefType(), po::setRefType);
        Null.notNull((Object)msg.getRefKey1(), po::setRefKey1);
        Null.notNull((Object)msg.getRefKey2(), po::setRefKey2);
        po.setNextLock(0);
        po.setNextSend(md != null ? md : ThreadNow.localDateTime());
        po.setSumSend(0);
        po.setSumFail(0);
        po.setSumDone(0);
        this.journalService.commit((Enum)Jane.Insert, journal -> {
            journal.create((JournalAware)po);
            this.winMailSenderDao.insert(po);
        });
        return po;
    }

    private boolean notMatchProp(WinMailSender po) {
        String mrs;
        String ma;
        if (this.tinyMailServiceProp.isOnlyApp() && StringUtils.isNotEmpty((CharSequence)(ma = po.getMailApps())) && !this.appName.equalsIgnoreCase(ma)) {
            log.debug("skip only send app-mail app={}, id={}", (Object)this.appName, (Object)po.getId());
            return true;
        }
        if (this.tinyMailServiceProp.isOnlyRun() && StringUtils.isNotEmpty((CharSequence)(mrs = po.getMailRuns()))) {
            RunMode rmd = RuntimeMode.getRunMode();
            if (rmd == RunMode.Nothing) {
                log.debug("skip only send run-mail, run={}, id={}", (Object)mrs, (Object)po.getId());
                return true;
            }
            if (!RuntimeMode.hasRunMode((CharSequence[])CommonPropHelper.arrayOrNull((String)mrs, (boolean)true))) {
                log.debug("skip only send run-mail, run={}, cur={}, id={}", new Object[]{mrs, rmd, po.getId()});
                return true;
            }
        }
        int maxDone = BoxedCastUtil.orElse((Integer)po.getMaxDone(), (int)0) > 0 ? po.getMaxDone().intValue() : this.tinyMailServiceProp.getMaxDone();
        int sumDone = BoxedCastUtil.orElse((Integer)po.getSumDone(), (int)0);
        if (sumDone >= maxDone) {
            log.debug("skip max-send, max={}, sum={}, id={}", new Object[]{maxDone, sumDone, po.getId()});
            return true;
        }
        int maxFail = BoxedCastUtil.orElse((Integer)po.getMaxFail(), (int)0) > 0 ? po.getMaxFail().intValue() : this.tinyMailServiceProp.getMaxFail();
        int sumFail = BoxedCastUtil.orElse((Integer)po.getSumFail(), (int)0);
        if (sumFail >= maxFail) {
            log.debug("skip max-fail, max={}, sum={}, id={}", new Object[]{maxFail, sumFail, po.getId()});
            return true;
        }
        return false;
    }

    private boolean notNextLock(WinMailSender po, long now) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        int rc = this.winMailSenderDao.ctx().update((Table)t).set(t.NextLock, t.NextLock.add((Number)1)).set(t.LastSend, (Object)DateLocaling.sysLdt((long)now)).where(t.Id.eq((Object)po.getId()).and(t.NextLock.eq((Object)po.getNextLock()))).execute();
        if (rc <= 0) {
            log.debug("skip not-next-lock mail, id={}", (Object)po.getId());
            return true;
        }
        return false;
    }

    private void saveStatusAndRetry(@NotNull WinMailSender po, TinyMailMessage message, long cost, long now, Exception exception, boolean retry, boolean check, boolean rethrow) {
        long nextSend = -1L;
        boolean notHookStop = true;
        try {
            WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
            HashMap<Object, Object> setter = new HashMap<Object, Object>();
            if (exception == null) {
                setter.put(t.LastFail, null);
                setter.put(t.LastDone, DateLocaling.sysLdt((long)now));
                setter.put(t.LastCost, cost);
                if (po.getSumDone() + 1 >= this.tinyMailServiceProp.getMaxDone()) {
                    setter.put(t.NextSend, EmptyValue.DATE_TIME);
                    log.debug("done mail by max-send id={}, subject={}", (Object)po.getId(), (Object)po.getMailSubj());
                } else {
                    nextSend = now + this.tinyMailServiceProp.getTryNext().toMillis();
                    setter.put(t.NextSend, DateLocaling.sysLdt((long)nextSend));
                    log.debug("next done-mail id={}, subject={}", (Object)po.getId(), (Object)po.getMailSubj());
                }
                setter.put(t.SumSend, t.SumSend.add((Number)1));
                setter.put(t.SumDone, t.SumDone.add((Number)1));
            } else {
                int maxFail;
                setter.put(t.LastFail, ThrowableUtil.toString((Throwable)exception));
                setter.put(t.LastDone, EmptyValue.DATE_TIME);
                setter.put(t.LastCost, cost);
                int n = maxFail = BoxedCastUtil.orElse((Integer)po.getMaxFail(), (int)0) > 0 ? po.getMaxFail().intValue() : this.tinyMailServiceProp.getMaxFail();
                if (po.getSumFail() + 1 >= maxFail) {
                    setter.put(t.NextSend, EmptyValue.DATE_TIME);
                    log.debug("done mail by max-fail id={}, subject={}", (Object)po.getId(), (Object)po.getMailSubj());
                } else if (retry) {
                    if (exception instanceof MailWaitException) {
                        MailWaitException mwe = (MailWaitException)((Object)exception);
                        if (mwe.isStopRetry()) {
                            setter.put(t.NextSend, EmptyValue.DATE_TIME);
                            log.error("stop stop-retry mail, id=" + po.getId(), (Throwable)exception);
                        } else {
                            nextSend = mwe.getWaitEpoch();
                        }
                    } else if (exception instanceof MailParseException || exception instanceof MessagingException) {
                        setter.put(t.NextSend, EmptyValue.DATE_TIME);
                        log.error("failed to parse, stop mail, id=" + po.getId(), (Throwable)exception);
                    } else {
                        nextSend = now + this.tinyMailServiceProp.getTryNext().toMillis();
                    }
                    if (nextSend > 0L) {
                        setter.put(t.NextSend, DateLocaling.sysLdt((long)nextSend));
                        log.debug("next fail-mail id={}, subject={}", (Object)po.getId(), (Object)po.getMailSubj());
                    }
                } else {
                    setter.put(t.NextSend, EmptyValue.DATE_TIME);
                    log.error("stop not-retry mail, id=" + po.getId(), (Throwable)exception);
                }
                setter.put(t.SumSend, t.SumSend.add((Number)1));
                setter.put(t.SumFail, t.SumFail.add((Number)1));
            }
            if (this.statusHooks != null) {
                for (TinyMailService.StatusHook sh : this.statusHooks) {
                    try {
                        if (!sh.stop(po, cost, exception)) continue;
                        notHookStop = false;
                    }
                    catch (Exception e) {
                        log.error("should NOT throw in hook, hook-class=" + sh.getClass().getName(), (Throwable)e);
                    }
                }
            }
            if (!notHookStop) {
                setter.put(t.NextSend, EmptyValue.DATE_TIME);
                log.debug("hook stop mail, id={}", (Object)po.getId());
            }
            this.journalService.commit((Enum)Jane.Update, journal -> {
                setter.put(t.CommitId, journal.getCommitId());
                setter.put(t.ModifyDt, journal.getCommitDt());
                this.winMailSenderDao.ctx().update((Table)t).set(setter).where(t.Id.eq((Object)po.getId())).execute();
            });
        }
        catch (Exception e) {
            log.error("failed to save mail status, id=" + po.getId() + ", subject=" + po.getMailSubj(), (Throwable)e);
            nextSend = now + this.tinyMailServiceProp.getTryNext().toMillis();
        }
        if (exception == null) {
            if (notHookStop && nextSend > 0L) {
                this.asyncMails.add(new AsyncMail(po.getId(), nextSend, retry, check, null, message));
                this.taskScheduler.schedule(this::doAsyncBatchSend, Instant.ofEpochMilli(nextSend));
                log.debug("schedule done-mail send, id={}, subject={}", (Object)po.getId(), (Object)po.getMailSubj());
            }
        } else if (notHookStop && retry && nextSend > 0L && nextSend - now < this.tinyMailServiceProp.getMaxNext().toMillis()) {
            this.asyncMails.add(new AsyncMail(po.getId(), nextSend, retry, check, null, message));
            this.taskScheduler.schedule(this::doAsyncBatchSend, Instant.ofEpochMilli(nextSend));
            log.debug("schedule fail-mail send, id=" + po.getId() + ", subject=" + po.getMailSubj());
        } else {
            if (rethrow) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new MailSendException("failed mail, id=" + po.getId() + ", subject=" + po.getMailSubj(), (Throwable)exception);
            }
            log.debug("no rethrow or retry mail, id=" + po.getId() + ", subject=" + po.getMailSubj());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSyncSend(@NotNull WinMailSender po, TinyMailMessage mailMessage, boolean retry, boolean check) {
        long start;
        if (check) {
            if (this.notMatchProp(po)) {
                return false;
            }
            start = ThreadNow.millis();
            if (this.notNextLock(po, start)) {
                return false;
            }
        } else {
            start = ThreadNow.millis();
        }
        Exception exception = null;
        try {
            this.mailSenderManager.singleSend(mailMessage);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            long now = ThreadNow.millis();
            this.saveStatusAndRetry(po, mailMessage, now - start, now, exception, retry, check, true);
        }
        return exception == null;
    }

    private long doAsyncFreshSend(@NotNull WinMailSender po, TinyMailMessage message, boolean retry, boolean check) {
        long nxt;
        if (check && this.notMatchProp(po)) {
            return -1L;
        }
        LocalDateTime md = po.getNextSend();
        long mds = md == null ? 0L : DateLocaling.sysEpoch((LocalDateTime)md);
        long now = ThreadNow.millis();
        Long id = po.getId();
        if (mds > now) {
            nxt = mds;
            log.debug("plan async date={} id={}", (Object)md, (Object)id);
        } else {
            nxt = now;
            log.debug("plan async date=now id={}", (Object)id);
        }
        this.mailSenderManager.checkMessage(message);
        this.asyncMails.add(new AsyncMail(id, nxt, retry, check, po, message));
        this.taskScheduler.schedule(this::doAsyncBatchSend, Instant.ofEpochMilli(nxt));
        return nxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncBatchSend() {
        long start = ThreadNow.millis();
        int bz = this.tinyMailServiceProp.getBatchSize();
        try {
            AtomicInteger count = new AtomicInteger(bz > 0 ? bz : 1);
            HashMap mails = new HashMap(count.get());
            this.asyncMails.removeIf(it -> {
                if (count.get() <= 0) {
                    return false;
                }
                if (it.next > start) {
                    return false;
                }
                mails.put(it.id, it);
                count.decrementAndGet();
                return true;
            });
            if (mails.isEmpty()) {
                return;
            }
            HashMap<Long, WinMailSender> freshPo = new HashMap<Long, WinMailSender>();
            ArrayList<Long> dirtyIds = new ArrayList<Long>();
            for (Object am : mails.values()) {
                if (((AsyncMail)am).fresher == null) {
                    dirtyIds.add(((AsyncMail)am).id);
                    continue;
                }
                freshPo.put(((AsyncMail)am).id, ((AsyncMail)am).fresher);
            }
            if (!dirtyIds.isEmpty()) {
                WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
                this.winMailSenderDao.ctx().selectFrom((TableLike)t).where(t.Id.in(dirtyIds)).fetchInto(WinMailSender.class).forEach(po -> freshPo.put(po.getId(), (WinMailSender)po));
            }
            ArrayList<TinyMailMessage> messages = new ArrayList<TinyMailMessage>(freshPo.size());
            for (WinMailSender po2 : freshPo.values()) {
                AsyncMail am = (AsyncMail)mails.get(po2.getId());
                if (am != null && am.check && (this.notMatchProp(po2) || this.notNextLock(po2, start))) continue;
                if (am != null && am.message != null) {
                    messages.add(am.message);
                    continue;
                }
                String conf = po2.getMailConf();
                TinyMailConfig config = this.mailConfigProvider.bynamedConfig(conf);
                if (config == null) {
                    log.warn("mail conf={} not found", (Object)conf);
                    continue;
                }
                messages.add(this.makeMailMessage(config, po2, null));
            }
            List<MailSenderManager.BatchResult> results = this.mailSenderManager.batchSend(messages);
            for (MailSenderManager.BatchResult result : results) {
                TinyMailMessage msg = result.getTinyMessage();
                WinMailSender po3 = (WinMailSender)freshPo.get(msg.getBizId());
                AsyncMail am = (AsyncMail)mails.get(po3.getId());
                this.saveStatusAndRetry(po3, msg, result.getCostMillis(), result.getDoneMillis(), result.getException(), am != null && am.retry, am != null && am.check, false);
            }
        }
        finally {
            int size = this.asyncMails.size();
            if (size > 0) {
                long next = start + this.tinyMailServiceProp.getTryNext().toMillis();
                this.taskScheduler.schedule(this::doAsyncBatchSend, Instant.ofEpochMilli(next));
                if (size > this.tinyMailServiceProp.getWarnSize()) {
                    log.warn("plan next war-size={}, idle={}", (Object)size, (Object)this.tinyMailServiceProp.getTryNext());
                } else {
                    log.debug("plan next size={}, idle={}", (Object)size, (Object)this.tinyMailServiceProp.getTryNext());
                }
            }
        }
    }

    @Nullable
    private String toString(String[] arr, String[] elz) {
        if (arr == null) {
            arr = elz;
        }
        return arr == null ? null : String.join((CharSequence)",", arr);
    }

    @Nullable
    private String toString(String str, String[] elz) {
        return CommonPropHelper.notValue((String)str) ? (elz == null || elz.length == 0 ? null : String.join((CharSequence)",", elz)) : str;
    }

    @Nullable
    private String toString(String str, String elz) {
        return CommonPropHelper.notValue((String)str) ? elz : str;
    }

    @NotNull
    private String toString(Map<String, Resource> file) {
        if (file == null || file.isEmpty()) {
            return "";
        }
        LinkedHashMap<String, String> nameUrl = new LinkedHashMap<String, String>(file.size());
        for (Map.Entry<String, Resource> en : file.entrySet()) {
            nameUrl.put(en.getKey(), CommonPropHelper.toString((Resource)en.getValue()));
        }
        return JacksonHelper.string(nameUrl, (boolean)true);
    }

    @NotNull
    private String toStringMap(Map<String, String> file) {
        if (file == null || file.isEmpty()) {
            return "";
        }
        return JacksonHelper.string(file, (boolean)true);
    }

    @Nullable
    private String toStrOrNull(String str) {
        return str == null || str.isEmpty() ? null : str;
    }

    @NotNull
    private Map<String, Resource> toResource(String map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Resource> rst = new LinkedHashMap<String, Resource>();
        Iterator node = JacksonHelper.object((String)map).fields();
        while (node.hasNext()) {
            Map.Entry en = (Map.Entry)node.next();
            rst.put((String)en.getKey(), this.resourceLoader.getResource(((JsonNode)en.getValue()).asText()));
        }
        return rst;
    }

    @Value(value="${spring.application.name}")
    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Autowired
    @Generated
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }

    @Autowired
    @Generated
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    @Autowired
    @Generated
    public void setWinMailSenderDao(WinMailSenderDao winMailSenderDao) {
        this.winMailSenderDao = winMailSenderDao;
    }

    @Autowired
    @Generated
    public void setMailConfigProvider(MailConfigProvider mailConfigProvider) {
        this.mailConfigProvider = mailConfigProvider;
    }

    @Autowired
    @Generated
    public void setMailSenderManager(MailSenderManager mailSenderManager) {
        this.mailSenderManager = mailSenderManager;
    }

    @Autowired
    @Generated
    public void setTinyMailServiceProp(TinyMailServiceProp tinyMailServiceProp) {
        this.tinyMailServiceProp = tinyMailServiceProp;
    }

    @Autowired
    @Generated
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Autowired(required=false)
    @Generated
    public void setStatusHooks(List<TinyMailService.StatusHook> statusHooks) {
        this.statusHooks = statusHooks;
    }

    @Autowired
    @Qualifier(value="taskScheduler")
    @Generated
    public void setTaskScheduler(ThreadPoolTaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public static enum Jane {
        Insert,
        Update;

    }

    private static class AsyncMail
    implements Comparable<AsyncMail> {
        private final long id;
        private final long next;
        private final boolean retry;
        private final boolean check;
        @Nullable
        private final WinMailSender fresher;
        @Nullable
        private final TinyMailMessage message;

        @Override
        public int compareTo(@NotNull AsyncMail o) {
            return Long.compare(this.next, o.next);
        }

        @Generated
        public AsyncMail(long id, long next, boolean retry, boolean check, @Nullable WinMailSender fresher, @Nullable TinyMailMessage message) {
            this.id = id;
            this.next = next;
            this.retry = retry;
            this.check = check;
            this.fresher = fresher;
            this.message = message;
        }

        @Generated
        public long getId() {
            return this.id;
        }

        @Generated
        public long getNext() {
            return this.next;
        }

        @Generated
        public boolean isRetry() {
            return this.retry;
        }

        @Generated
        public boolean isCheck() {
            return this.check;
        }

        @Nullable
        @Generated
        public WinMailSender getFresher() {
            return this.fresher;
        }

        @Nullable
        @Generated
        public TinyMailMessage getMessage() {
            return this.message;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncMail)) {
                return false;
            }
            AsyncMail other = (AsyncMail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.getNext() != other.getNext()) {
                return false;
            }
            if (this.isRetry() != other.isRetry()) {
                return false;
            }
            if (this.isCheck() != other.isCheck()) {
                return false;
            }
            WinMailSender this$fresher = this.getFresher();
            WinMailSender other$fresher = other.getFresher();
            if (this$fresher == null ? other$fresher != null : !((Object)this$fresher).equals(other$fresher)) {
                return false;
            }
            TinyMailMessage this$message = this.getMessage();
            TinyMailMessage other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)((Object)this$message)).equals((Object)other$message));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof AsyncMail;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            long $next = this.getNext();
            result = result * 59 + (int)($next >>> 32 ^ $next);
            result = result * 59 + (this.isRetry() ? 79 : 97);
            result = result * 59 + (this.isCheck() ? 79 : 97);
            WinMailSender $fresher = this.getFresher();
            result = result * 59 + ($fresher == null ? 43 : ((Object)$fresher).hashCode());
            TinyMailMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)((Object)$message)).hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "TinyMailServiceImpl.AsyncMail(id=" + this.getId() + ", next=" + this.getNext() + ", retry=" + this.isRetry() + ", check=" + this.isCheck() + ", fresher=" + String.valueOf(this.getFresher()) + ", message=" + String.valueOf((Object)this.getMessage()) + ")";
        }
    }
}

