/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.controller;

import io.swagger.v3.oas.annotations.Operation;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.mail.service.TinyMailPlain;
import pro.fessional.wings.tiny.mail.service.TinyMailService;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.tiny.mail.mvc-send")
public class MailSendController {
    protected TinyMailService tinyMailService;

    @Operation(summary="Create mail and send it sync or async", description="# Usage\nCreate the mail, and auto send it in sync or async way.\n## Params\n* @param - request body\n## Returns\n* @return {200 | Result(-1)} failure\n* @return {200 | Result(0)} sync send\n* @return {200 | Result(mills)} async send at mills time\n")
    @PostMapping(value={"${wings.tiny.mail.urlmap.send-mail}"})
    @ResponseBody
    public R<Long> sendMail(@RequestBody TinyMailPlain mail) {
        long ms = this.tinyMailService.auto(mail);
        return R.okData((Object)ms);
    }

    @Operation(summary="Save the mail only, do not send", description="# Usage\nSave the new mail, return the id.\n## Params\n* @param - request body\n## Returns\n* @return {200 | Result(id)} mail id\n")
    @PostMapping(value={"${wings.tiny.mail.urlmap.send-save}"})
    @ResponseBody
    public R<Long> sendSave(@RequestBody TinyMailPlain mail) {
        long id = this.tinyMailService.save(mail);
        return R.okData((Object)id);
    }

    @Operation(summary="sync scan and resend mail async", description="# Usage\nsync scan the mail to resend, return the count, and send them async\n## Returns\n* @return {200 | Result(count)} mail cou t\n")
    @PostMapping(value={"${wings.tiny.mail.urlmap.send-scan}"})
    @ResponseBody
    public R<Integer> sendScan() {
        int cnt = this.tinyMailService.scan();
        return R.okData((Object)cnt);
    }

    @Operation(summary="Sync resend failed mail", description="# Usage\nSync resend the  failed email, return success/fail, or throw exception\n## Params\n* @param - request body\n## Returns\n* @return {200 | Result(bool)} success or not\n")
    @PostMapping(value={"${wings.tiny.mail.urlmap.send-retry}"})
    @ResponseBody
    public R<Boolean> sendRetry(@RequestBody Ins mail) {
        boolean ok = this.tinyMailService.send(mail.id, mail.retry, mail.check);
        return R.okData((Object)ok);
    }

    @Autowired
    @Generated
    public void setTinyMailService(TinyMailService tinyMailService) {
        this.tinyMailService = tinyMailService;
    }

    public static class Ins {
        private long id;
        private boolean retry;
        private boolean check;

        @Generated
        public Ins() {
        }

        @Generated
        public long getId() {
            return this.id;
        }

        @Generated
        public boolean isRetry() {
            return this.retry;
        }

        @Generated
        public boolean isCheck() {
            return this.check;
        }

        @Generated
        public void setId(long id) {
            this.id = id;
        }

        @Generated
        public void setRetry(boolean retry) {
            this.retry = retry;
        }

        @Generated
        public void setCheck(boolean check) {
            this.check = check;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ins)) {
                return false;
            }
            Ins other = (Ins)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.isRetry() != other.isRetry()) {
                return false;
            }
            return this.isCheck() == other.isCheck();
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Ins;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            result = result * 59 + (this.isRetry() ? 79 : 97);
            result = result * 59 + (this.isCheck() ? 79 : 97);
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "MailSendController.Ins(id=" + this.getId() + ", retry=" + this.isRetry() + ", check=" + this.isCheck() + ")";
        }
    }
}

