/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.sender;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.wings.tiny.mail.sender.TinyMailConfig;
import pro.fessional.wings.tiny.mail.spring.prop.TinyMailConfigProp;

public class MailConfigProvider {
    @NotNull
    private final TinyMailConfigProp configProp;
    private List<TinyMailConfig.Loader> configLoader = Collections.emptyList();

    @NotNull
    public TinyMailConfig defaultConfig() {
        return this.configProp.getDefault();
    }

    @Nullable
    public TinyMailConfig bynamedConfig(String name) {
        if (name == null || name.isEmpty()) {
            return this.defaultConfig();
        }
        TinyMailConfig conf = (TinyMailConfig)((Object)this.configProp.get(name));
        if (conf == null && this.configLoader != null) {
            for (TinyMailConfig.Loader ld : this.configLoader) {
                TinyMailConfig cf = ld.load(name);
                if (cf == null) continue;
                conf = cf;
                break;
            }
        }
        return conf;
    }

    @Contract(value="_->new")
    public TinyMailConfig combineConfig(@Nullable TinyMailConfig that) {
        TinyMailConfig newConf = new TinyMailConfig();
        TinyMailConfig.ConfSetter.toAny((Object)newConf, (Object)that);
        TinyMailConfig.ConfSetter.toInvalid((Object)newConf, (Object)this.configProp.getDefault());
        return newConf;
    }

    @Generated
    public MailConfigProvider(@NotNull TinyMailConfigProp configProp) {
        if (configProp == null) {
            throw new NullPointerException("configProp is marked non-null but is null");
        }
        this.configProp = configProp;
    }

    @Autowired(required=false)
    @Generated
    public void setConfigLoader(List<TinyMailConfig.Loader> configLoader) {
        this.configLoader = configLoader;
    }

    @Generated
    public List<TinyMailConfig.Loader> getConfigLoader() {
        return this.configLoader;
    }
}

