/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.sender;

import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.Resource;
import pro.fessional.mirana.cond.IfSetter;
import pro.fessional.mirana.text.WhiteUtil;
import pro.fessional.wings.tiny.mail.sender.TinyMailConfig;

public class TinyMailMessage
extends TinyMailConfig {
    protected Long bizId;
    protected String bizMark;
    protected String subject;
    protected String content;
    protected Map<String, Resource> attachment = null;
    public static final IfSetter<TinyMailMessage, TinyMailMessage> MessageSetter = (thiz, that, absent, present) -> {
        if (that == null) {
            return thiz;
        }
        TinyMailConfig.ConfSetter.set((Object)thiz, (Object)that, absent, present);
        if (absent == IfSetter.Absent.Invalid) {
            if (thiz.bizId == null) {
                thiz.bizId = that.bizId;
            }
            if (thiz.bizMark == null) {
                thiz.bizMark = that.bizMark;
            }
            if (StringUtils.isEmpty((CharSequence)thiz.subject)) {
                thiz.subject = that.subject;
            }
            if (StringUtils.isEmpty((CharSequence)thiz.content)) {
                thiz.content = that.content;
            }
            if (thiz.attachment == null) {
                thiz.attachment = that.attachment;
            }
        } else {
            thiz.bizId = that.bizId;
            thiz.bizMark = that.bizMark;
            thiz.subject = that.subject;
            thiz.content = that.content;
            thiz.attachment = that.attachment;
        }
        return thiz;
    };

    @NotNull
    public Map<String, Resource> getAttachment() {
        return this.attachment != null ? this.attachment : Collections.emptyMap();
    }

    public String toMainString() {
        StringBuilder sb = new StringBuilder();
        if (this.bizId != null) {
            sb.append(" bizId=").append(this.bizId);
        }
        if (this.to != null) {
            sb.append(" to=[").append(String.join((CharSequence)",", this.to)).append(']');
        }
        if (this.subject != null) {
            sb.append(" subject=").append(this.subject);
        }
        return sb.toString();
    }

    public boolean asHtml() {
        if (this.html != null) {
            return this.html;
        }
        return TinyMailMessage.asHtml(this.content, true);
    }

    public static boolean asHtml(String str, boolean elze) {
        if (str == null) {
            return elze;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(0);
            if (!WhiteUtil.notWhiteSpace((char)c)) continue;
            return c == '<';
        }
        return elze;
    }

    @Generated
    public TinyMailMessage() {
    }

    @Generated
    public Long getBizId() {
        return this.bizId;
    }

    @Generated
    public String getBizMark() {
        return this.bizMark;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    @Generated
    public void setBizMark(String bizMark) {
        this.bizMark = bizMark;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setAttachment(Map<String, Resource> attachment) {
        this.attachment = attachment;
    }

    @NotNull
    @Generated
    public String toString() {
        return "TinyMailMessage(bizId=" + this.getBizId() + ", bizMark=" + this.getBizMark() + ", subject=" + this.getSubject() + ", content=" + this.getContent() + ", attachment=" + String.valueOf(this.getAttachment()) + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TinyMailMessage)) {
            return false;
        }
        TinyMailMessage other = (TinyMailMessage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        String this$bizMark = this.getBizMark();
        String other$bizMark = other.getBizMark();
        if (this$bizMark == null ? other$bizMark != null : !this$bizMark.equals(other$bizMark)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Map<String, Resource> this$attachment = this.getAttachment();
        Map<String, Resource> other$attachment = other.getAttachment();
        return !(this$attachment == null ? other$attachment != null : !((Object)this$attachment).equals(other$attachment));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof TinyMailMessage;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        String $bizMark = this.getBizMark();
        result = result * 59 + ($bizMark == null ? 43 : $bizMark.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Map<String, Resource> $attachment = this.getAttachment();
        result = result * 59 + ($attachment == null ? 43 : ((Object)$attachment).hashCode());
        return result;
    }
}

