/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.service;

import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.tiny.mail.database.autogen.tables.pojos.WinMailSender;
import pro.fessional.wings.tiny.mail.service.TinyMail;
import pro.fessional.wings.tiny.mail.service.TinyMailPlain;

public interface TinyMailService {
    public static final int Success = 0;
    public static final int ErrCheck = -1;
    public static final int ErrOther = -2;

    public boolean send(@NotNull TinyMail var1, boolean var2);

    public long post(@NotNull TinyMail var1, boolean var2);

    public long emit(@NotNull TinyMail var1, boolean var2);

    default public boolean send(@NotNull TinyMailPlain message) {
        long id = this.save(message);
        return this.send(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
    }

    default public long post(@NotNull TinyMailPlain message) {
        long id = this.save(message);
        return this.post(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
    }

    default public long emit(@NotNull TinyMailPlain message) {
        long id = this.save(message);
        return this.emit(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
    }

    public boolean send(long var1, boolean var3, boolean var4);

    public long post(long var1, boolean var3, boolean var4);

    public long emit(long var1, boolean var3, boolean var4);

    default public long save(@NotNull TinyMailPlain message) {
        return this.save(message, true);
    }

    public long save(@NotNull TinyMailPlain var1, boolean var2);

    public int scan(Long var1);

    default public int scan() {
        return this.scan(null);
    }

    default public long auto(@NotNull TinyMail message, boolean retry) {
        LocalDateTime md = message.getDate();
        if (md == null || md.isBefore(ThreadNow.localDateTime())) {
            return this.post(message, retry);
        }
        return this.emit(message, retry);
    }

    default public long auto(@NotNull TinyMailPlain message) {
        long id = this.save(message);
        LocalDateTime md = message.getDate();
        if (md == null || md.isBefore(ThreadNow.localDateTime())) {
            return this.post(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
        }
        return this.emit(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
    }

    public static interface StatusHook {
        public boolean stop(@NotNull WinMailSender var1, long var2, Exception var4);
    }
}

