/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.service.impl;

import jakarta.mail.MessagingException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.task.TaskSchedulingProperties;
import org.springframework.boot.task.ThreadPoolTaskSchedulerBuilder;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailSendException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.util.function.SingletonSupplier;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.mirana.best.Param;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.cond.IfSetter;
import pro.fessional.mirana.pain.ThrowableUtil;
import pro.fessional.mirana.time.DateLocaling;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.convention.EmptySugar;
import pro.fessional.wings.faceless.convention.EmptyValue;
import pro.fessional.wings.faceless.service.journal.JournalAware;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.silencer.modulate.RunMode;
import pro.fessional.wings.silencer.modulate.RuntimeMode;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.support.PropHelper;
import pro.fessional.wings.slardar.async.TaskSchedulerHelper;
import pro.fessional.wings.slardar.fastjson.FastJsonHelper;
import pro.fessional.wings.tiny.mail.database.autogen.tables.WinMailSenderTable;
import pro.fessional.wings.tiny.mail.database.autogen.tables.daos.WinMailSenderDao;
import pro.fessional.wings.tiny.mail.database.autogen.tables.pojos.WinMailSender;
import pro.fessional.wings.tiny.mail.sender.MailConfigProvider;
import pro.fessional.wings.tiny.mail.sender.MailRetryException;
import pro.fessional.wings.tiny.mail.sender.MailSenderManager;
import pro.fessional.wings.tiny.mail.sender.MailStopException;
import pro.fessional.wings.tiny.mail.sender.MailWaitException;
import pro.fessional.wings.tiny.mail.sender.TinyMailConfig;
import pro.fessional.wings.tiny.mail.sender.TinyMailMessage;
import pro.fessional.wings.tiny.mail.service.TinyMail;
import pro.fessional.wings.tiny.mail.service.TinyMailLazy;
import pro.fessional.wings.tiny.mail.service.TinyMailPlain;
import pro.fessional.wings.tiny.mail.service.TinyMailService;
import pro.fessional.wings.tiny.mail.spring.prop.TinyMailServiceProp;

@Service
@ConditionalWingsEnabled
public class TinyMailServiceImpl
implements TinyMailService,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyMailServiceImpl.class);
    protected String appName;
    protected LightIdService lightIdService;
    protected JournalService journalService;
    protected WinMailSenderDao winMailSenderDao;
    protected MailConfigProvider mailConfigProvider;
    protected MailSenderManager mailSenderManager;
    protected TinyMailServiceProp tinyMailServiceProp;
    protected ResourceLoader resourceLoader;
    protected ObjectProvider<TinyMailService.StatusHook> statusHookProvider;
    protected ObjectProvider<TinyMailLazy> lazyBeanProvider;
    protected ThreadPoolTaskScheduler taskScheduler;
    protected volatile boolean isShutdown = false;
    protected SingletonSupplier<Map<String, TinyMailLazy>> lazyBeanHolder;
    protected SingletonSupplier<List<TinyMailService.StatusHook>> statusHookHolder;
    protected final PriorityQueue<AsyncMail> asyncMailQueue = new PriorityQueue();
    protected final ConcurrentHashMap<Long, ScheduledFuture<?>> asyncMailTask = new ConcurrentHashMap();
    protected final AtomicLong idleScanMills = new AtomicLong(-1L);
    protected final AtomicReference<ScheduledFuture<?>> idleScanTask = new AtomicReference();

    @Override
    public boolean send(@NotNull TinyMail message, boolean retry) {
        return this.doSend(true, message, retry) == 0L;
    }

    @Override
    public long post(@NotNull TinyMail message, boolean retry) {
        try {
            return this.doSend(true, message, retry);
        }
        catch (MailRetryException e) {
            log.warn("fail to post tiny-mail, next-retry=" + e.getNextEpoch() + ", subject=" + message.getSubject(), e.getCause());
            return e.getNextEpoch();
        }
        catch (Exception e) {
            log.error("fail to post tiny-mail, retry=" + retry + ", subject=" + message.getSubject(), (Throwable)e);
            return -2L;
        }
    }

    @Override
    public long emit(@NotNull TinyMail message, boolean retry) {
        try {
            return this.doSend(false, message, retry);
        }
        catch (MailRetryException e) {
            log.warn("fail to emit tiny-mail, next-retry=" + e.getNextEpoch() + ", subject=" + message.getSubject(), e.getCause());
            return e.getNextEpoch();
        }
        catch (Exception e) {
            log.error("fail to emit tiny-mail, retry=" + retry + ", subject=" + message.getSubject(), (Throwable)e);
            return -2L;
        }
    }

    @Override
    public boolean send(long id, boolean retry, boolean check) {
        return this.doSend(true, id, retry, check) == 0L;
    }

    @Override
    public long post(long id, boolean retry, boolean check) {
        try {
            return this.doSend(true, id, retry, check);
        }
        catch (MailRetryException e) {
            log.warn("fail to post tiny-mail, next-retry=" + e.getNextEpoch() + ", id=" + id, e.getCause());
            return e.getNextEpoch();
        }
        catch (Exception e) {
            log.error("fail to post tiny-mail, retry=" + retry + ", id=" + id, (Throwable)e);
            return -2L;
        }
    }

    @Override
    public long emit(long id, boolean retry, boolean check) {
        try {
            return this.doSend(false, id, retry, check);
        }
        catch (MailRetryException e) {
            log.warn("fail to emit tiny-mail, next-retry=" + e.getNextEpoch() + ", id=" + id, e.getCause());
            return e.getNextEpoch();
        }
        catch (Exception e) {
            log.error("fail to emit tiny-mail, retry=" + retry + ", id=" + id, (Throwable)e);
            return -2L;
        }
    }

    public void afterPropertiesSet() {
        ThreadPoolTaskSchedulerBuilder builder = new ThreadPoolTaskSchedulerBuilder();
        TaskSchedulingProperties scheduler = this.tinyMailServiceProp.getScheduler();
        builder = builder.poolSize(scheduler.getPool().getSize());
        builder = builder.threadNamePrefix(scheduler.getThreadNamePrefix());
        TaskSchedulingProperties.Shutdown shutdown = scheduler.getShutdown();
        builder = builder.awaitTermination(shutdown.isAwaitTermination());
        builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
        this.taskScheduler = TaskSchedulerHelper.Ttl((ThreadPoolTaskSchedulerBuilder)builder);
        this.taskScheduler.initialize();
        this.isShutdown = false;
        log.info("tiny-mail taskScheduler, prefix={}", (Object)this.taskScheduler.getThreadNamePrefix());
        long idle = this.tinyMailServiceProp.getBootScan().toMillis();
        if (idle > 0L) {
            log.info("tiny-mail schedule boot-scan after={} ms", (Object)idle);
            ScheduledFuture task = this.taskScheduler.schedule(this::scanIdle, Instant.ofEpochMilli(ThreadNow.millis() + idle));
            this.idleScanTask.set(task);
        }
        this.statusHookHolder = SingletonSupplier.of(() -> this.statusHookProvider.orderedStream().toList());
        this.lazyBeanHolder = SingletonSupplier.of(() -> {
            HashMap<String, TinyMailLazy> map = new HashMap<String, TinyMailLazy>();
            for (TinyMailLazy bean : this.lazyBeanProvider) {
                TinyMailLazy old = map.put(bean.lazyBean(), bean);
                if (old == null) continue;
                log.error("lazy bean name existed, name={}, new-bean={}", (Object)old.lazyBean(), bean.getClass());
            }
            return map.isEmpty() ? Collections.emptyMap() : map;
        });
    }

    @EventListener(value={ContextClosedEvent.class})
    public void destroy() {
        ScheduledFuture<?> task;
        this.isShutdown = true;
        if (this.taskScheduler != null) {
            this.taskScheduler.shutdown();
        }
        int size = 0;
        for (ScheduledFuture<?> task2 : this.asyncMailTask.values()) {
            task2.cancel(false);
            ++size;
        }
        if (size > 0) {
            this.asyncMailTask.clear();
            log.info("cancel async mail for shutdown, size={}", (Object)size);
        }
        if ((task = this.idleScanTask.get()) != null) {
            task.cancel(false);
            log.info("cancel async scan mail for shutdown");
        }
    }

    @Override
    public long save(@NotNull TinyMailPlain msg, boolean check) {
        long id;
        String conf = msg.getConf();
        TinyMailConfig config = this.mailConfigProvider.bynamedConfig(conf);
        AssertArgs.notNull((Object)((Object)config), (String)"skip tiny-mail conf={} not found", (Object[])new Object[]{conf});
        WinMailSender po = new WinMailSender();
        boolean isNew = msg.getId() == null || msg.getId() <= 0L;
        RunMode rm = RuntimeMode.getRunMode();
        String crm = rm == RunMode.Nothing ? "" : rm.name().toLowerCase();
        LocalDateTime md = msg.getDate();
        if (isNew) {
            id = this.lightIdService.getId((LightIdAware)this.winMailSenderDao.getTable());
            po.setNextLock(0);
            po.setNextSend(md != null ? md : ThreadNow.localDateTime());
            po.setSumSend(0);
            po.setSumFail(0);
            po.setSumDone(0);
        } else {
            id = msg.getId();
            IfSetter.nonnull(po::setNextSend, (Object)msg.getNextSend());
        }
        po.setId(id);
        po.setMailApps(this.toString(msg.getApps(), this.appName));
        po.setMailRuns(this.toString(msg.getRuns(), crm));
        po.setMailConf(msg.getConf());
        po.setMailFrom(this.toString(msg.getFrom(), config.getFrom()));
        po.setMailTo(this.toString(msg.getTo(), config.getTo()));
        po.setMailCc(this.toString(msg.getCc(), config.getCc()));
        po.setMailBcc(this.toString(msg.getBcc(), config.getBcc()));
        po.setMailReply(this.toString(msg.getReply(), config.getReply()));
        po.setMailSubj(msg.getSubject());
        po.setMailText(msg.getContent());
        po.setMailHtml(EmptySugar.emptyOrElse((Boolean)msg.getHtml(), config::getHtml));
        po.setMailFile(this.toString(msg.getAttachment()));
        po.setMailMark(msg.getMark());
        po.setMailDate(md);
        po.setLazyBean(msg.getLazyBean());
        po.setLazyPara(msg.getLazyPara());
        po.setMaxFail(EmptySugar.emptyOrElse((Integer)msg.getMaxFail(), this.tinyMailServiceProp::getMaxFail));
        po.setMaxDone(EmptySugar.emptyOrElse((Integer)msg.getMaxDone(), this.tinyMailServiceProp::getMaxDone));
        IfSetter.nonnull(po::setRefType, (Object)msg.getRefType());
        IfSetter.nonnull(po::setRefKey1, (Object)msg.getRefKey1());
        IfSetter.nonnull(po::setRefKey2, (Object)msg.getRefKey2());
        if (check) {
            TinyMailMessage tms = this.makeMailMessage(config, po, null);
            this.mailSenderManager.checkMessage(tms);
        }
        this.journalService.commit((Enum)Jane.Insert, journal -> {
            if (isNew) {
                journal.create((JournalAware)po);
                this.winMailSenderDao.insert(po);
            } else {
                journal.modify((JournalAware)po);
                this.winMailSenderDao.update(po, false);
            }
        });
        return id;
    }

    @Override
    public int scan(Long idle) {
        if (idle == null) {
            return this.scanSync();
        }
        this.idleScanMills.set(idle);
        ScheduledFuture<?> task = this.idleScanTask.get();
        if (task != null) {
            task.cancel(false);
        }
        return this.scanIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ArrayList<AsyncMail> listAsyncMailQueue() {
        PriorityQueue<AsyncMail> priorityQueue = this.asyncMailQueue;
        synchronized (priorityQueue) {
            return new ArrayList<AsyncMail>(this.asyncMailQueue);
        }
    }

    @NotNull
    public TreeMap<Long, ScheduledFuture<?>> listAsyncMailTask() {
        return new TreeMap(this.asyncMailTask);
    }

    protected int scanIdle() {
        int size = -1;
        try {
            size = this.scanSync();
        }
        catch (Exception e) {
            log.error("fail to scanSync", (Throwable)e);
        }
        long idle = this.idleScanMills.get();
        if (idle < 0L) {
            idle = this.tinyMailServiceProp.getScanIdle().toMillis();
            this.idleScanMills.set(idle);
            log.info("reset tiny-mail scan idle to prop={} ms", (Object)idle);
        }
        if (idle > 0L) {
            ScheduledFuture task = this.taskScheduler.schedule(this::scanIdle, Instant.ofEpochMilli(ThreadNow.millis() + idle));
            this.idleScanTask.set(task);
            log.info("plan tiny-mail scan, idle={} ms", (Object)idle);
        } else {
            this.idleScanTask.set(null);
            log.info("stop tiny-mail scan, idle={} ms", (Object)idle);
        }
        return size;
    }

    protected int scanSync() {
        long now = ThreadNow.millis();
        LocalDateTime min = DateLocaling.sysLdt((long)(now - this.tinyMailServiceProp.getMaxNext().toMillis()));
        LocalDateTime max = DateLocaling.sysLdt((long)(now + this.tinyMailServiceProp.getTryNext().toMillis()));
        log.info("scan tiny-mail to queue, next-send min={}, max={}", (Object)min, (Object)max);
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        List<AsyncMail> mails = this.winMailSenderDao.ctx().selectFrom((TableLike)t).where(t.NextSend.ge((Object)min).and(t.NextSend.lt((Object)max))).fetch().into(WinMailSender.class).stream().filter(po -> !this.notMatchProp((WinMailSender)po)).map(it -> new AsyncMail(it.getId(), DateLocaling.sysEpoch((LocalDateTime)it.getNextSend()), true, true, (WinMailSender)it, null)).toList();
        int size = mails.size();
        if (size > 0) {
            this.planAsyncMail(mails);
        }
        return size;
    }

    protected TinyMailMessage makeMailMessage(@NotNull TinyMailConfig config, @NotNull WinMailSender po, @Nullable TinyMail msg) {
        TinyMailMessage message = new TinyMailMessage();
        TinyMailConfig.ConfSetter.toAny((Object)message, (Object)config);
        message.setBizId(po.getId());
        if (msg == null) {
            message.setFrom(po.getMailFrom());
            message.setTo(PropHelper.commaArray((String)po.getMailTo()));
            message.setCc(PropHelper.commaArray((String)po.getMailCc()));
            message.setBcc(PropHelper.commaArray((String)po.getMailBcc()));
            message.setReply(EmptySugar.emptyToNull((String)po.getMailReply()));
            message.setHtml(po.getMailHtml());
            message.setSubject(po.getMailSubj());
            message.setContent(po.getMailText());
            Map<String, Resource> files = this.resourceString(po.getMailFile());
            if (!files.isEmpty()) {
                message.setAttachment(files);
            }
            message.setBizMark(EmptySugar.emptyToNull((String)po.getMailMark()));
        } else {
            IfSetter.nonnull(message::setFrom, (Object)msg.getFrom());
            IfSetter.nonnull(message::setTo, (Object)msg.getTo());
            IfSetter.nonnull(message::setCc, (Object)msg.getCc());
            IfSetter.nonnull(message::setReply, (Object)msg.getReply());
            IfSetter.nonnull(message::setHtml, (Object)msg.getHtml());
            message.setSubject(msg.getSubject());
            message.setContent(msg.getContent());
            message.setAttachment(msg.getAttachment());
            message.setBizMark(msg.getMark());
        }
        return message;
    }

    protected WinMailSender saveMailSender(@NotNull TinyMailConfig config, @NotNull TinyMail msg) {
        WinMailSender po = new WinMailSender();
        long id = this.lightIdService.getId((LightIdAware)this.winMailSenderDao.getTable());
        po.setId(id);
        po.setMailApps(this.appName);
        RunMode rm = RuntimeMode.getRunMode();
        po.setMailRuns(rm == RunMode.Nothing ? "" : rm.name().toLowerCase());
        po.setMailConf(config.getName());
        po.setMailFrom(this.toString(msg.getFrom(), config.getFrom()));
        po.setMailTo(this.toString(msg.getTo(), config.getTo()));
        po.setMailCc(this.toString(msg.getCc(), config.getCc()));
        po.setMailBcc(this.toString(msg.getBcc(), config.getBcc()));
        po.setMailReply(this.toString(msg.getReply(), config.getReply()));
        po.setMailSubj(msg.getSubject());
        po.setMailText(msg.getContent());
        po.setMailHtml(EmptySugar.emptyOrElse((Boolean)msg.getHtml(), config::getHtml));
        po.setMailFile(this.stringResource(msg.getAttachment()));
        po.setMailMark(msg.getMark());
        LocalDateTime md = msg.getDate();
        po.setMailDate(md);
        po.setLazyBean(msg.getLazyBean());
        po.setLazyPara(msg.getLazyPara());
        po.setMaxFail(EmptySugar.emptyOrElse((Integer)msg.getMaxFail(), this.tinyMailServiceProp::getMaxFail));
        po.setMaxDone(EmptySugar.emptyOrElse((Integer)msg.getMaxDone(), this.tinyMailServiceProp::getMaxDone));
        IfSetter.nonnull(po::setRefType, (Object)msg.getRefType());
        IfSetter.nonnull(po::setRefKey1, (Object)msg.getRefKey1());
        IfSetter.nonnull(po::setRefKey2, (Object)msg.getRefKey2());
        po.setNextLock(0);
        po.setNextSend(md != null ? md : ThreadNow.localDateTime());
        po.setSumSend(0);
        po.setSumFail(0);
        po.setSumDone(0);
        this.journalService.commit((Enum)Jane.Insert, journal -> {
            journal.create((JournalAware)po);
            this.winMailSenderDao.insert(po);
        });
        return po;
    }

    @Nullable
    protected TinyMailLazy findLazyBean(String name) {
        return (TinyMailLazy)((Map)this.lazyBeanHolder.obtain()).get(name);
    }

    @NotNull
    protected List<TinyMailService.StatusHook> findStatusHook() {
        return (List)this.statusHookHolder.obtain();
    }

    protected boolean notMatchProp(@NotNull WinMailSender po) {
        String bn;
        TinyMailLazy bean;
        int poDone;
        String mrs;
        String ma;
        if (this.tinyMailServiceProp.isOnlyApp() && StringUtils.isNotEmpty((CharSequence)(ma = po.getMailApps())) && !this.appName.equalsIgnoreCase(ma)) {
            log.debug("skip only send app tiny-mail app={}, id={}", (Object)this.appName, (Object)po.getId());
            return true;
        }
        if (this.tinyMailServiceProp.isOnlyRun() && StringUtils.isNotEmpty((CharSequence)(mrs = po.getMailRuns()))) {
            RunMode rmd = RuntimeMode.getRunMode();
            if (rmd == RunMode.Nothing) {
                log.debug("skip only send run tiny-mail, run={}, id={}", (Object)mrs, (Object)po.getId());
                return true;
            }
            if (!RuntimeMode.voteRunMode((String)mrs)) {
                log.debug("skip only send run tiny-mail, run={}, cur={}, id={}", new Object[]{mrs, rmd, po.getId()});
                return true;
            }
        }
        int maxDone = (poDone = BoxedCastUtil.orZero((Integer)po.getMaxDone())) > 0 ? poDone : this.tinyMailServiceProp.getMaxDone();
        int sumDone = BoxedCastUtil.orZero((Integer)po.getSumDone());
        if (sumDone >= maxDone) {
            log.debug("skip max-send tiny-mail, max={}, sum={}, id={}", new Object[]{maxDone, sumDone, po.getId()});
            return true;
        }
        int poFail = BoxedCastUtil.orZero((Integer)po.getMaxFail());
        int maxFail = poFail > 0 ? poFail : this.tinyMailServiceProp.getMaxFail();
        int sumFail = BoxedCastUtil.orZero((Integer)po.getSumFail());
        if (sumFail >= maxFail) {
            log.debug("skip max-fail tiny-mail, max={}, sum={}, id={}", new Object[]{maxFail, sumFail, po.getId()});
            return true;
        }
        if (po.getMailText() == null && (bean = this.findLazyBean(bn = po.getLazyBean())) == null) {
            log.error("stop lazy tiny-mail, not found bean={}, id={}", (Object)bn, (Object)po.getId());
            return true;
        }
        return false;
    }

    protected boolean notNextLock(@NotNull WinMailSender po, long now) {
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        int rc = this.winMailSenderDao.ctx().update((Table)t).set(t.NextLock, t.NextLock.add((Number)1)).set(t.LastSend, (Object)DateLocaling.sysLdt((long)now)).where(t.Id.eq((Object)po.getId()).and(t.NextLock.eq((Object)po.getNextLock()))).execute();
        if (rc <= 0) {
            log.debug("skip not-next-lock tiny-mail, id={}", (Object)po.getId());
            return true;
        }
        return false;
    }

    protected long doSend(boolean sync, @NotNull TinyMail message, boolean retry) {
        String conf = message.getConf();
        TinyMailConfig config = this.mailConfigProvider.bynamedConfig(conf);
        AssertArgs.notNull((Object)((Object)config), (String)"skip tiny-mail conf={} not found", (Object[])new Object[]{conf});
        WinMailSender po = this.saveMailSender(config, message);
        if (this.isShutdown) {
            log.warn("save but skip tiny-mail for shutdwon, subject={}", (Object)message.getSubject());
            return -2L;
        }
        TinyMailMessage mailMessage = this.makeMailMessage(config, po, message);
        if (sync) {
            return this.doSyncSend(po, mailMessage, retry, true);
        }
        return this.doAsyncSend(po, mailMessage, retry, true);
    }

    protected long doSend(boolean sync, long id, boolean retry, boolean check) {
        if (this.isShutdown) {
            log.warn("doSend skip tiny-mail for shutdwon, id={}", (Object)id);
            return -2L;
        }
        WinMailSender po = this.winMailSenderDao.fetchOneById(id);
        AssertArgs.notNull((Object)po, (String)"skip tiny-mail not found by id={}", (Object[])new Object[]{id});
        String conf = po.getMailConf();
        TinyMailConfig config = this.mailConfigProvider.bynamedConfig(conf);
        AssertArgs.notNull((Object)((Object)config), (String)"skip tiny-mail conf={} not found, id={}", (Object[])new Object[]{conf, id});
        TinyMailMessage mailMessage = this.makeMailMessage(config, po, null);
        if (sync) {
            return this.doSyncSend(po, mailMessage, retry, check);
        }
        return this.doAsyncSend(po, mailMessage, retry, check);
    }

    protected long saveSendResult(@NotNull WinMailSender po, long cost, long exit, Exception error, boolean retry) {
        long nextSend = -1L;
        Long id = po.getId();
        try {
            WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
            HashMap<Object, Object> setter = new HashMap<Object, Object>();
            if (error == null) {
                int maxDone;
                setter.put(t.LastFail, null);
                setter.put(t.LastDone, DateLocaling.sysLdt((long)exit));
                setter.put(t.LastCost, cost);
                int poDone = BoxedCastUtil.orZero((Integer)po.getMaxDone());
                int n = maxDone = poDone > 0 ? poDone : this.tinyMailServiceProp.getMaxDone();
                if (po.getSumDone() + 1 >= maxDone) {
                    log.debug("done tiny-mail by max-send id={}, subject={}", (Object)id, (Object)po.getMailSubj());
                } else {
                    nextSend = exit + this.tinyMailServiceProp.getTryNext().toMillis();
                    log.debug("next done tiny-mail id={}, subject={}", (Object)id, (Object)po.getMailSubj());
                }
                setter.put(t.SumSend, t.SumSend.add((Number)1));
                setter.put(t.SumDone, t.SumDone.add((Number)1));
            } else {
                int maxFail;
                setter.put(t.LastFail, ThrowableUtil.toString((Throwable)error));
                setter.put(t.LastDone, EmptyValue.DATE_TIME);
                setter.put(t.LastCost, cost);
                int poFail = BoxedCastUtil.orZero((Integer)po.getMaxFail());
                int n = maxFail = poFail > 0 ? poFail : this.tinyMailServiceProp.getMaxFail();
                if (po.getSumFail() + 1 >= maxFail) {
                    log.debug("done tiny-mail by max-fail id={}, subject={}", (Object)id, (Object)po.getMailSubj());
                } else if (retry) {
                    if (error instanceof MailStopException) {
                        log.warn("stop tiny-mail by stop-exception, id=" + id, (Throwable)error);
                    } else if (error instanceof MailWaitException) {
                        MailWaitException mwe = (MailWaitException)((Object)error);
                        if (mwe.isStopRetry()) {
                            log.error("stop tiny-mail by stop-retry, id=" + id, (Throwable)error);
                        } else {
                            nextSend = mwe.getWaitEpoch();
                        }
                    } else if (error instanceof MailParseException || error instanceof MessagingException) {
                        log.error("stop tiny-mail by failed parse, id=" + id, (Throwable)error);
                    } else {
                        nextSend = exit + this.tinyMailServiceProp.getTryNext().toMillis();
                    }
                } else {
                    log.error("stop tiny-mail by not-retry, id=" + id, (Throwable)error);
                }
                setter.put(t.SumSend, t.SumSend.add((Number)1));
                setter.put(t.SumFail, t.SumFail.add((Number)1));
            }
            boolean hookStop = false;
            for (TinyMailService.StatusHook sh : this.findStatusHook()) {
                try {
                    if (!sh.stop(po, cost, error)) continue;
                    hookStop = true;
                }
                catch (Exception e) {
                    log.error("should NOT throw in hook, hook-class=" + sh.getClass().getName(), (Throwable)e);
                }
            }
            if (hookStop) {
                log.debug("stop tiny-mail by hook, id={}", (Object)id);
            }
            if (nextSend > 0L) {
                setter.put(t.NextSend, DateLocaling.sysLdt((long)nextSend));
                log.debug("next tiny-mail id={}, subject={}", (Object)id, (Object)po.getMailSubj());
            } else {
                setter.put(t.NextSend, EmptyValue.DATE_TIME);
            }
            this.journalService.commit((Enum)Jane.Update, journal -> {
                setter.put(t.CommitId, journal.getCommitId());
                setter.put(t.ModifyDt, journal.getCommitDt());
                this.winMailSenderDao.ctx().update((Table)t).set(setter).where(t.Id.eq((Object)id)).execute();
            });
        }
        catch (Exception e) {
            log.error("failed to save tiny-mail status, id=" + id + ", subject=" + po.getMailSubj(), (Throwable)e);
            nextSend = exit + this.tinyMailServiceProp.getTryNext().toMillis();
        }
        return nextSend;
    }

    protected void editLazyMail(@NotNull WinMailSender po, @NotNull @Param.Out TinyMailMessage message) {
        Map<String, Resource> file;
        String text;
        String subj;
        if (message.getContent() != null) {
            return;
        }
        Long id = po.getId();
        String bn = po.getLazyBean();
        TinyMailLazy bean = this.findLazyBean(bn);
        if (bean == null) {
            throw new MailStopException("tiny-mail lazy-edit, not-found bean=" + bn + ", id=" + id);
        }
        TinyMailLazy.Edit edit = bean.lazyEdit(po.getLazyPara());
        if (edit == null) {
            throw new MailStopException("tiny-mail lazy-edit, edit is null, id=" + id);
        }
        WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
        HashMap<Object, Object> setter = new HashMap<Object, Object>();
        Boolean html = edit.getHtml();
        if (html != null) {
            setter.put(t.MailHtml, html);
            message.setHtml(html);
        }
        if ((subj = edit.getSubject()) != null) {
            setter.put(t.MailSubj, subj);
            message.setSubject(subj);
        }
        if ((text = edit.getContent()) != null) {
            setter.put(t.MailText, text);
            message.setContent(text);
        }
        if ((file = edit.getAttachment()) != null && !file.isEmpty()) {
            setter.put(t.MailFile, this.stringResource(file));
            message.setAttachment(file);
        }
        if (setter.isEmpty()) {
            throw new MailStopException("tiny-mail lazy-edit, edit is empty, id=" + id);
        }
        log.debug("lazy-edit tiny-mail, id={}", (Object)id);
        this.journalService.commit((Enum)Jane.Lazify, journal -> {
            setter.put(t.CommitId, journal.getCommitId());
            setter.put(t.ModifyDt, journal.getCommitDt());
            this.winMailSenderDao.ctx().update((Table)t).set(setter).where(t.Id.eq((Object)id)).execute();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doSyncSend(@NotNull WinMailSender po, @NotNull TinyMailMessage message, boolean retry, boolean check) {
        long next;
        long start;
        if (this.isShutdown) {
            log.warn("doSyncSend skip tiny-mail for shutdwon, id={}", (Object)po.getId());
            return -2L;
        }
        if (check) {
            if (this.notMatchProp(po)) {
                return -1L;
            }
            start = ThreadNow.millis();
            if (this.notNextLock(po, start)) {
                return -1L;
            }
        } else {
            start = ThreadNow.millis();
        }
        Long id = po.getId();
        try {
            this.editLazyMail(po, message);
        }
        catch (Exception err) {
            log.error("stop tiny-mail for lazy-edit error, id=" + id, (Throwable)err);
            this.saveSendResult(po, 0L, start, err, false);
            return -1L;
        }
        Exception error = null;
        try {
            this.mailSenderManager.singleSend(message);
        }
        catch (Exception e) {
            error = e;
        }
        finally {
            long end = ThreadNow.millis();
            next = this.saveSendResult(po, end - start, end, error, retry);
        }
        if (next > 0L) {
            this.planAsyncMail(new AsyncMail(id, next, retry, check, null, message));
            log.debug("plan tiny-mail next-send, err={}, id={}, subject={}", new Object[]{error == null, id, po.getMailSubj()});
            if (error != null) {
                throw new MailRetryException(next, error);
            }
        }
        if (error == null) {
            return 0L;
        }
        if (error instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)error;
            throw re;
        }
        throw new MailSendException("failed tiny-mail, id=" + id + ", subject=" + po.getMailSubj(), (Throwable)error);
    }

    private long doAsyncSend(@NotNull WinMailSender po, @NotNull TinyMailMessage message, boolean retry, boolean check) {
        long next;
        long nsm;
        if (this.isShutdown) {
            log.warn("doAsyncSend skip tiny-mail for shutdwon, id={}", (Object)po.getId());
            return -2L;
        }
        if (check && this.notMatchProp(po)) {
            return -1L;
        }
        long start = ThreadNow.millis();
        Long id = po.getId();
        try {
            this.editLazyMail(po, message);
        }
        catch (Exception err) {
            log.error("stop tiny-mail for lazy-edit error, id=" + id, (Throwable)err);
            this.saveSendResult(po, 0L, start, err, false);
            return -1L;
        }
        LocalDateTime ns = po.getNextSend();
        long l = nsm = ns == null ? 0L : DateLocaling.sysEpoch((LocalDateTime)ns);
        if (nsm > start) {
            next = nsm;
            log.debug("plan async tiny-mail date={} id={}", (Object)ns, (Object)id);
        } else {
            next = start;
            log.debug("plan async tiny-mail date=now id={}", (Object)id);
        }
        this.planAsyncMail(new AsyncMail(id, next, retry, check, po, message));
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planAsyncMail(@NotNull AsyncMail mail) {
        log.debug("plan async tiny-mail, id={}", (Object)mail.id);
        PriorityQueue<AsyncMail> priorityQueue = this.asyncMailQueue;
        synchronized (priorityQueue) {
            this.asyncMailQueue.removeIf(it -> it.id == mail.id);
            this.asyncMailQueue.add(mail);
        }
        this.planAsyncMail(mail.next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planAsyncMail(@NotNull Collection<AsyncMail> mails) {
        if (mails.isEmpty()) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>();
        long next = -1L;
        for (AsyncMail m : mails) {
            ids.add(m.id);
            if (next <= 0L) {
                next = m.next;
                continue;
            }
            if (m.next >= next) continue;
            next = m.next;
        }
        log.debug("plan async tiny-mail, size={}", (Object)ids.size());
        PriorityQueue<AsyncMail> priorityQueue = this.asyncMailQueue;
        synchronized (priorityQueue) {
            this.asyncMailQueue.removeIf(it -> ids.contains(it.id));
            this.asyncMailQueue.addAll(mails);
        }
        this.planAsyncMail(next);
    }

    private void planAsyncMail(long next) {
        if (next <= 0L) {
            log.debug("plan async tiny-mail, skip={}", (Object)next);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("plan async tiny-mail, next={}", (Object)DateLocaling.sysLdt((long)next));
        }
        long nxt = (next / 1000L + 1L) * 1000L;
        this.asyncMailTask.computeIfAbsent(nxt, k -> this.taskScheduler.schedule(() -> {
            try {
                this.sendAsyncMail();
            }
            finally {
                this.asyncMailTask.remove(k);
            }
        }, Instant.ofEpochMilli(nxt)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAsyncMail() {
        long start = ThreadNow.millis();
        int count = Math.max(this.tinyMailServiceProp.getBatchSize(), 1);
        HashMap mails = new HashMap(count);
        HashMap<Long, WinMailSender> freshPo = new HashMap<Long, WinMailSender>(count);
        ArrayList<Long> dirtyIds = new ArrayList<Long>(count);
        ArrayList<TinyMailMessage> messages = new ArrayList<TinyMailMessage>(count);
        ArrayList<AsyncMail> nexts = new ArrayList<AsyncMail>(count);
        try {
            while (true) {
                mails.clear();
                freshPo.clear();
                dirtyIds.clear();
                messages.clear();
                nexts.clear();
                PriorityQueue<AsyncMail> priorityQueue = this.asyncMailQueue;
                synchronized (priorityQueue) {
                    this.asyncMailQueue.removeIf(it -> {
                        if (it.next > start) {
                            return false;
                        }
                        if (mails.size() >= count) {
                            return mails.containsKey(it.id);
                        }
                        mails.put(it.id, it);
                        return true;
                    });
                }
                if (mails.isEmpty()) {
                    return;
                }
                for (AsyncMail am : mails.values()) {
                    if (am.fresher == null) {
                        dirtyIds.add(am.id);
                        continue;
                    }
                    freshPo.put(am.id, am.fresher);
                }
                if (!dirtyIds.isEmpty()) {
                    WinMailSenderTable t = (WinMailSenderTable)this.winMailSenderDao.getTable();
                    this.winMailSenderDao.ctx().selectFrom((TableLike)t).where(t.Id.in(dirtyIds)).fetchInto(WinMailSender.class).forEach(po -> freshPo.put(po.getId(), (WinMailSender)po));
                }
                for (WinMailSender po2 : freshPo.values()) {
                    TinyMailMessage msg;
                    Long id = po2.getId();
                    AsyncMail am = (AsyncMail)mails.get(id);
                    if (am == null || am.check && (this.notMatchProp(po2) || this.notNextLock(po2, start))) continue;
                    if (am.message != null) {
                        msg = am.message;
                    } else {
                        String conf = po2.getMailConf();
                        TinyMailConfig config = this.mailConfigProvider.bynamedConfig(conf);
                        if (config == null) {
                            log.warn("tiny-mail conf={} not found, id={}", (Object)conf, (Object)id);
                            continue;
                        }
                        msg = this.makeMailMessage(config, po2, null);
                    }
                    try {
                        this.editLazyMail(po2, msg);
                        messages.add(msg);
                    }
                    catch (Exception err) {
                        log.error("stop tiny-mail for lazy-edit error, id=" + id, (Throwable)err);
                        this.saveSendResult(po2, 0L, start, err, false);
                    }
                }
                List<MailSenderManager.BatchResult> brs = this.mailSenderManager.batchSend(messages);
                for (MailSenderManager.BatchResult br : brs) {
                    long nxt;
                    TinyMailMessage msg = br.getTinyMessage();
                    WinMailSender po3 = (WinMailSender)freshPo.get(msg.getBizId());
                    AsyncMail am = (AsyncMail)mails.get(po3.getId());
                    if (am == null || (nxt = this.saveSendResult(po3, br.getCostMillis(), br.getExitMillis(), br.getException(), am.retry)) <= 0L) continue;
                    nexts.add(new AsyncMail(po3.getId(), nxt, am.retry, am.check, null, msg));
                }
                this.planAsyncMail(nexts);
            }
        }
        finally {
            int qs;
            int ws = this.tinyMailServiceProp.getWarnSize();
            PriorityQueue<AsyncMail> priorityQueue = this.asyncMailQueue;
            synchronized (priorityQueue) {
                qs = this.asyncMailQueue.size();
            }
            if (qs > 0) {
                this.planAsyncMail(start + this.tinyMailServiceProp.getTryNext().toMillis());
                if (qs > ws) {
                    log.warn("plan tiny-mail queue-size={}, idle={}", (Object)qs, (Object)this.tinyMailServiceProp.getTryNext());
                } else {
                    log.debug("plan tiny-mail queue-size={}, idle={}", (Object)qs, (Object)this.tinyMailServiceProp.getTryNext());
                }
            }
        }
    }

    @Nullable
    private String toString(String[] arr, String[] elz) {
        if (arr == null) {
            arr = elz;
        }
        return arr == null ? null : String.join((CharSequence)",", arr);
    }

    @Nullable
    private String toString(String str, String[] elz) {
        return PropHelper.invalid((String)str) ? (elz == null || elz.length == 0 ? null : String.join((CharSequence)",", elz)) : str;
    }

    @Nullable
    private String toString(String str, String elz) {
        return PropHelper.invalid((String)str) ? elz : str;
    }

    @Nullable
    private String toString(Map<String, String> file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        return FastJsonHelper.string(file);
    }

    @Nullable
    private String stringResource(Map<String, Resource> file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> nameUrl = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Resource> en : file.entrySet()) {
            nameUrl.put(en.getKey(), PropHelper.stringResource((Resource)en.getValue()));
        }
        return this.toString(nameUrl);
    }

    @NotNull
    private Map<String, Resource> resourceString(String jsonMap) {
        if (EmptySugar.asEmptyValue((String)jsonMap)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Resource> rst = new LinkedHashMap<String, Resource>();
        Map map = (Map)FastJsonHelper.object((String)jsonMap, Map.class, (Class[])new Class[]{String.class, String.class});
        for (Map.Entry en : map.entrySet()) {
            rst.put((String)en.getKey(), PropHelper.resourceString((String)((String)en.getValue()), (ResourceLoader)this.resourceLoader));
        }
        return rst;
    }

    @Value(value="${spring.application.name}")
    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Autowired
    @Generated
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }

    @Autowired
    @Generated
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    @Autowired
    @Generated
    public void setWinMailSenderDao(WinMailSenderDao winMailSenderDao) {
        this.winMailSenderDao = winMailSenderDao;
    }

    @Autowired
    @Generated
    public void setMailConfigProvider(MailConfigProvider mailConfigProvider) {
        this.mailConfigProvider = mailConfigProvider;
    }

    @Autowired
    @Generated
    public void setMailSenderManager(MailSenderManager mailSenderManager) {
        this.mailSenderManager = mailSenderManager;
    }

    @Autowired
    @Generated
    public void setTinyMailServiceProp(TinyMailServiceProp tinyMailServiceProp) {
        this.tinyMailServiceProp = tinyMailServiceProp;
    }

    @Autowired
    @Generated
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Autowired
    @Generated
    public void setStatusHookProvider(ObjectProvider<TinyMailService.StatusHook> statusHookProvider) {
        this.statusHookProvider = statusHookProvider;
    }

    @Autowired
    @Generated
    public void setLazyBeanProvider(ObjectProvider<TinyMailLazy> lazyBeanProvider) {
        this.lazyBeanProvider = lazyBeanProvider;
    }

    public static enum Jane {
        Insert,
        Update,
        Lazify;

    }

    public static class AsyncMail
    implements Comparable<AsyncMail> {
        private final long id;
        private final long next;
        private final boolean retry;
        private final boolean check;
        @Nullable
        private final WinMailSender fresher;
        @Nullable
        private final TinyMailMessage message;

        @Override
        public int compareTo(@NotNull AsyncMail o) {
            return Long.compare(this.next, o.next);
        }

        @Generated
        public AsyncMail(long id, long next, boolean retry, boolean check, @Nullable WinMailSender fresher, @Nullable TinyMailMessage message) {
            this.id = id;
            this.next = next;
            this.retry = retry;
            this.check = check;
            this.fresher = fresher;
            this.message = message;
        }

        @Generated
        public long getId() {
            return this.id;
        }

        @Generated
        public long getNext() {
            return this.next;
        }

        @Generated
        public boolean isRetry() {
            return this.retry;
        }

        @Generated
        public boolean isCheck() {
            return this.check;
        }

        @Nullable
        @Generated
        public WinMailSender getFresher() {
            return this.fresher;
        }

        @Nullable
        @Generated
        public TinyMailMessage getMessage() {
            return this.message;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncMail)) {
                return false;
            }
            AsyncMail other = (AsyncMail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.getNext() != other.getNext()) {
                return false;
            }
            if (this.isRetry() != other.isRetry()) {
                return false;
            }
            if (this.isCheck() != other.isCheck()) {
                return false;
            }
            WinMailSender this$fresher = this.getFresher();
            WinMailSender other$fresher = other.getFresher();
            if (this$fresher == null ? other$fresher != null : !((Object)this$fresher).equals(other$fresher)) {
                return false;
            }
            TinyMailMessage this$message = this.getMessage();
            TinyMailMessage other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)((Object)this$message)).equals((Object)other$message));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof AsyncMail;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            long $next = this.getNext();
            result = result * 59 + (int)($next >>> 32 ^ $next);
            result = result * 59 + (this.isRetry() ? 79 : 97);
            result = result * 59 + (this.isCheck() ? 79 : 97);
            WinMailSender $fresher = this.getFresher();
            result = result * 59 + ($fresher == null ? 43 : ((Object)$fresher).hashCode());
            TinyMailMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)((Object)$message)).hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "TinyMailServiceImpl.AsyncMail(id=" + this.getId() + ", next=" + this.getNext() + ", retry=" + this.isRetry() + ", check=" + this.isCheck() + ", fresher=" + String.valueOf(this.getFresher()) + ", message=" + String.valueOf((Object)this.getMessage()) + ")";
        }
    }
}

