/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.spring.bean;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.wings.silencer.runner.ApplicationReadyEventRunner;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.mail.controller.MailListController;
import pro.fessional.wings.tiny.mail.database.TinyMailDatabase;
import pro.fessional.wings.tiny.mail.sender.MailConfigProvider;
import pro.fessional.wings.tiny.mail.sender.MailNotice;
import pro.fessional.wings.tiny.mail.sender.MailSenderManager;
import pro.fessional.wings.tiny.mail.sender.MailSenderProvider;
import pro.fessional.wings.tiny.mail.service.TinyMailLazy;
import pro.fessional.wings.tiny.mail.service.TinyMailService;
import pro.fessional.wings.tiny.mail.spring.prop.TinyMailConfigProp;
import pro.fessional.wings.tiny.mail.spring.prop.TinyMailSenderProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class TinyMailConfiguration {
    private static final Log log = LogFactory.getLog(TinyMailConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public MailConfigProvider mailConfigProvider(TinyMailConfigProp tinyMailConfigProp) {
        log.info((Object)"TinyMail spring-bean mailConfigProvider");
        return new MailConfigProvider(tinyMailConfigProp);
    }

    @Bean
    @ConditionalWingsEnabled
    public MailNotice mailNotice(MailConfigProvider configProvider, MailSenderManager senderManager) {
        log.info((Object)"TinyMail spring-bean mailNotice");
        return new MailNotice(configProvider, senderManager);
    }

    @Bean
    @ConditionalWingsEnabled
    public MailSenderManager mailSenderManager(TinyMailSenderProp senderProp, MailSenderProvider senderProvider) {
        log.info((Object)"TinyMail spring-bean mailSenderManager");
        return new MailSenderManager(senderProp, senderProvider);
    }

    @Bean
    @ConditionalWingsEnabled
    public MailSenderProvider mailSenderProvider(JavaMailSender defaultSender) {
        log.info((Object)"TinyMail spring-bean mailSenderProvider");
        return new MailSenderProvider(defaultSender);
    }

    @Bean
    @ConditionalWingsEnabled
    public ApplicationReadyEventRunner tinyMailLazyRunner(@NotNull Map<String, TinyMailLazy> lazyMap) {
        log.info((Object)"TinyMail spring-runs tinyMailLazyRunner");
        return new ApplicationReadyEventRunner(-50000000, ignored -> {
            HashMap<String, TinyMailLazy> map = new HashMap<String, TinyMailLazy>();
            for (Map.Entry en : lazyMap.entrySet()) {
                TinyMailLazy bean = (TinyMailLazy)en.getValue();
                TinyMailLazy old = map.put(bean.lazyBean(), bean);
                if (old == null) continue;
                throw new IllegalStateException("lazy bean name existed, name=" + old.lazyBean() + ", new-bean-name=" + (String)en.getKey() + ", old-bean-class=" + String.valueOf(old.getClass()));
            }
            log.info((Object)("tiny-mail TinyMailLazy beans, size=" + map.size()));
        });
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    @ComponentScan(basePackageClasses={MailListController.class})
    @ConditionalOnClass(value={RestController.class})
    public static class MvcRestScan {
        public MvcRestScan() {
            log.info((Object)"TinyMail spring-scan controller");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    @ComponentScan(basePackageClasses={TinyMailDatabase.class, TinyMailService.class})
    public static class DaoServScan {
        public DaoServScan() {
            log.info((Object)"TinyMail spring-scan database, service");
        }
    }
}

