/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.controller;

import io.swagger.v3.oas.annotations.Operation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.Diff;
import pro.fessional.mirana.data.Q;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.task.schedule.conf.TaskerProp;
import pro.fessional.wings.tiny.task.service.TinyTaskConfService;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.tiny.task.mvc-conf")
public class TaskConfController {
    protected TinyTaskConfService tinyTaskConfService;

    @Operation(summary="enable or disable a task.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-enable}"})
    @ResponseBody
    public R<Boolean> taskEnable(@RequestBody In1 ins) {
        boolean ok = this.tinyTaskConfService.enable(ins.id, this.tinyTaskConfService.enable(ins.id, ins.enable));
        return R.okData((Object)ok);
    }

    @Operation(summary="update the task config.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-prop-save}"})
    @ResponseBody
    public R<Boolean> taskPropSave(@RequestBody In2 ins) {
        boolean ok = this.tinyTaskConfService.replace(ins.id, ins);
        return R.okData((Object)ok);
    }

    @Operation(summary="load the task config.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-prop-load}"})
    @ResponseBody
    public R<TaskerProp> taskPropLoad(@RequestBody Q.Id ins) {
        TaskerProp pp = this.tinyTaskConfService.database(ins.getId(), false);
        return R.okData((Object)pp);
    }

    @Operation(summary="show the prop of task conf.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-prop-conf}"})
    @ResponseBody
    public R<TaskerProp> taskPropConf(@RequestBody Q.Id ins) {
        TaskerProp pp = this.tinyTaskConfService.property(ins.getId(), false);
        return R.okData((Object)pp);
    }

    @Operation(summary="show the diff of task conf.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-prop-diff}"})
    @ResponseBody
    public R<Map<String, Diff.V<?>>> taskPropDiff(@RequestBody Q.Id ins) {
        LinkedHashMap<String, Diff.V<?>> df = this.tinyTaskConfService.diffProp(ins.getId());
        return R.okData(df);
    }

    @Autowired
    public void setTinyTaskConfService(TinyTaskConfService tinyTaskConfService) {
        this.tinyTaskConfService = tinyTaskConfService;
    }

    public static class In1 {
        private long id;
        private boolean enable;

        public long getId() {
            return this.id;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setId(long id) {
            this.id = id;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof In1)) {
                return false;
            }
            In1 other = (In1)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            return this.isEnable() == other.isEnable();
        }

        protected boolean canEqual(Object other) {
            return other instanceof In1;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            result = result * 59 + (this.isEnable() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "TaskConfController.In1(id=" + this.getId() + ", enable=" + this.isEnable() + ")";
        }
    }

    public static class In2
    extends TaskerProp {
        private long id;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof In2)) {
                return false;
            }
            In2 other = (In2)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return this.getId() == other.getId();
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof In2;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            return result;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @Override
        public String toString() {
            return "TaskConfController.In2(id=" + this.getId() + ")";
        }
    }
}

