/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.controller;

import io.swagger.v3.oas.annotations.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.Q;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.task.service.TinyTaskExecService;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.tiny.task.mvc-exec")
public class TaskExecController {
    protected TinyTaskExecService tinyTaskExecService;

    @Operation(summary="cancel a task.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-cancel}"})
    @ResponseBody
    public R<Boolean> taskCancel(@RequestBody Q.Id ins) {
        boolean cancel = this.tinyTaskExecService.cancel(ins.getId());
        return R.okData((Object)cancel);
    }

    @Operation(summary="start a task.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-launch}"})
    @ResponseBody
    public R<Boolean> taskLaunch(@RequestBody Q.Id ins) {
        boolean cancel = this.tinyTaskExecService.launch(ins.getId());
        return R.okData((Object)cancel);
    }

    @Operation(summary="force to start a task.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-force}"})
    @ResponseBody
    public R<Boolean> taskForce(@RequestBody Q.Id ins) {
        boolean cancel = this.tinyTaskExecService.force(ins.getId());
        return R.okData((Object)cancel);
    }

    @Autowired
    public void setTinyTaskExecService(TinyTaskExecService tinyTaskExecService) {
        this.tinyTaskExecService = tinyTaskExecService;
    }
}

