/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.schedule.exec;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.wings.tiny.task.schedule.exec.NoticeExec;
import pro.fessional.wings.tiny.task.schedule.exec.TaskerExec;

public class ExecHolder {
    private static final ConcurrentHashMap<String, NoticeExec<?>> Notice = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, TaskerExec> Tasker = new ConcurrentHashMap();

    @NotNull
    public static NoticeExec<?> getNotice(@NotNull String token, @NotNull Function<String, NoticeExec<?>> exec) {
        return Notice.computeIfAbsent(token, exec);
    }

    @NotNull
    public static TaskerExec getTasker(@NotNull String token, @NotNull Function<String, TaskerExec> exec) {
        return Tasker.computeIfAbsent(token, exec);
    }

    @Contract(value="_,true->!null")
    public static NoticeExec<?> getNotice(String token, boolean nonnull) {
        NoticeExec<?> exec;
        NoticeExec<?> noticeExec = exec = StringUtils.isEmpty((CharSequence)token) ? null : Notice.get(token);
        if (nonnull && exec == null) {
            throw new IllegalStateException("notice not found, token=" + token);
        }
        return exec;
    }

    @Contract(value="_,true->!null")
    public static TaskerExec getTasker(String token, boolean nonnull) {
        TaskerExec exec;
        TaskerExec taskerExec = exec = StringUtils.isEmpty((CharSequence)token) ? null : Tasker.get(token);
        if (nonnull && exec == null) {
            throw new IllegalStateException("tasker not found, token=" + token);
        }
        return exec;
    }
}

