/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.schedule.exec;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import pro.fessional.wings.silencer.notice.SmallNotice;
import pro.fessional.wings.tiny.task.schedule.help.TaskerHelper;

public class NoticeExec<C> {
    private static final Logger log = LoggerFactory.getLogger(NoticeExec.class);
    public static final String WhenExec = "exec";
    public static final String WhenFail = "fail";
    public static final String WhenDone = "done";
    public static final String WhenFeed = "feed";
    @NotNull
    protected final SmallNotice<C> beanObject;
    @NotNull
    protected final Class<?> beanClass;

    public NoticeExec(@NotNull SmallNotice<C> beanObject) {
        this.beanClass = AopUtils.getTargetClass(beanObject);
        this.beanObject = beanObject;
    }

    public boolean accept(String token) {
        return TaskerHelper.acceptToken(this.beanClass, null, token);
    }

    public boolean accept(SmallNotice<C> bean) {
        return TaskerHelper.acceptBean(this.beanClass, this.beanObject, bean);
    }

    public void postNotice(String config, String subject, String content) {
        try {
            Object conf = this.beanObject.provideConfig(config, true);
            this.beanObject.post(conf, subject, content);
        }
        catch (Exception e) {
            log.warn("failed to post notice, subject=" + subject + ", content=" + content, (Throwable)e);
        }
    }

    @NotNull
    public SmallNotice<C> getBeanObject() {
        return this.beanObject;
    }

    @NotNull
    public Class<?> getBeanClass() {
        return this.beanClass;
    }
}

