/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.Diff;
import pro.fessional.wings.tiny.task.schedule.conf.TaskerProp;

public interface TinyTaskConfService {
    public Conf config(@NotNull Object var1, @NotNull Method var2, @Nullable Object var3);

    @NotNull
    public Set<Conf> config(@NotNull Object var1);

    @Contract(value="_,true->!null")
    public TaskerProp database(long var1, boolean var3);

    @Contract(value="_,true->!null")
    public TaskerProp property(long var1, boolean var3);

    @NotNull
    public LinkedHashMap<String, Diff.V<?>> diffProp(long var1);

    public boolean enable(long var1, boolean var3);

    public boolean replace(long var1, TaskerProp var3);

    public static class Conf {
        private final long id;
        private final boolean enabled;
        private final boolean autorun;

        public Conf(long id, boolean enabled, boolean autorun) {
            this.id = id;
            this.enabled = enabled;
            this.autorun = autorun;
        }

        public long getId() {
            return this.id;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isAutorun() {
            return this.autorun;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conf)) {
                return false;
            }
            Conf other = (Conf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            return this.isAutorun() == other.isAutorun();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Conf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + (this.isAutorun() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "TinyTaskConfService.Conf(id=" + this.getId() + ", enabled=" + this.isEnabled() + ", autorun=" + this.isAutorun() + ")";
        }
    }
}

