/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service;

import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import pro.fessional.mirana.func.Lam;
import pro.fessional.mirana.time.ThreadNow;

public interface TinyTaskService {
    @NotNull
    public ThreadPoolTaskScheduler referScheduler(boolean var1);

    @NotNull
    default public ScheduledExecutorService referExecutor(boolean fast) {
        return this.referScheduler(fast).getScheduledExecutor();
    }

    default public void execute(boolean fast, @NotNull Runnable task) {
        this.referScheduler(fast).execute(task);
    }

    default public ScheduledFuture<?> execute(boolean fast, long delayMs, @NotNull Runnable task) {
        return this.execute(fast, Instant.ofEpochMilli(ThreadNow.millis() + delayMs), task);
    }

    default public ScheduledFuture<?> execute(boolean fast, Instant startTime, @NotNull Runnable task) {
        return this.referScheduler(fast).schedule(task, startTime);
    }

    default public ScheduledFuture<?> execute(boolean fast, Trigger trigger, @NotNull Runnable task) {
        return this.referScheduler(fast).schedule(task, trigger);
    }

    @NotNull
    public Set<Task> schedule(@NotNull Object var1);

    public Task schedule(@NotNull Object var1, @NotNull Method var2, @Nullable Object var3);

    default public Task schedule(@NotNull Lam.Ref lambdaRefer, @Nullable Object taskerPara) {
        return this.schedule(lambdaRefer.object, lambdaRefer.method, taskerPara);
    }

    public static class Task {
        private final long id;
        private final boolean scheduled;

        public Task(long id, boolean scheduled) {
            this.id = id;
            this.scheduled = scheduled;
        }

        public long getId() {
            return this.id;
        }

        public boolean isScheduled() {
            return this.scheduled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Task)) {
                return false;
            }
            Task other = (Task)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            return this.isScheduled() == other.isScheduled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Task;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            result = result * 59 + (this.isScheduled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "TinyTaskService.Task(id=" + this.getId() + ", scheduled=" + this.isScheduled() + ")";
        }
    }
}

