/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.data.Diff;
import pro.fessional.wings.faceless.service.journal.JournalAware;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.silencer.modulate.RunMode;
import pro.fessional.wings.silencer.modulate.RuntimeMode;
import pro.fessional.wings.silencer.notice.SmallNotice;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskDefineTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskDefineDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskDefine;
import pro.fessional.wings.tiny.task.schedule.TinyTasker;
import pro.fessional.wings.tiny.task.schedule.conf.TaskerProp;
import pro.fessional.wings.tiny.task.schedule.exec.ExecHolder;
import pro.fessional.wings.tiny.task.schedule.exec.NoticeExec;
import pro.fessional.wings.tiny.task.schedule.exec.TaskerExec;
import pro.fessional.wings.tiny.task.schedule.help.TaskerHelper;
import pro.fessional.wings.tiny.task.service.TinyTaskConfService;
import pro.fessional.wings.tiny.task.spring.prop.TinyTaskDefineProp;

@Service
@ConditionalWingsEnabled
public class TinyTaskConfServiceImpl
implements TinyTaskConfService {
    private static final Logger log = LoggerFactory.getLogger(TinyTaskConfServiceImpl.class);
    protected String appName;
    protected ApplicationContext applicationContext;
    protected TinyTaskDefineProp tinyTaskDefineProp;
    protected WinTaskDefineDao winTaskDefineDao;
    protected LightIdService lightIdService;
    protected JournalService journalService;

    @Override
    @Transactional
    public TinyTaskConfService.Conf config(@NotNull Object bean, @NotNull Method method, @Nullable Object para) {
        return this.config(AopUtils.getTargetClass((Object)bean), bean, method, para);
    }

    @Override
    @Transactional
    @NotNull
    public Set<TinyTaskConfService.Conf> config(@NotNull Object bean) {
        Class claz = AopUtils.getTargetClass((Object)bean);
        Map map = MethodIntrospector.selectMethods((Class)claz, method -> (TinyTasker)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, TinyTasker.class));
        if (map.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TinyTaskConfService.Conf> result = new HashSet<TinyTaskConfService.Conf>();
        for (Method method2 : map.keySet()) {
            TinyTaskConfService.Conf cnf = this.config(claz, bean, method2, null);
            result.add(cnf);
        }
        return result;
    }

    @NotNull
    private TaskerProp property(@NotNull String key, @NotNull TinyTasker anno) {
        TaskerProp pp = (TaskerProp)this.tinyTaskDefineProp.get(key);
        TaskerProp df = this.tinyTaskDefineProp.getDefault();
        TaskerProp rp = new TaskerProp();
        if (pp == null) {
            rp.setTimingZone(anno.zone());
            rp.setTimingCron(anno.cron());
            rp.setTimingIdle(anno.idle());
            rp.setTimingRate(anno.rate());
            log.debug("no prop, use annotation, key={}", (Object)key);
        } else {
            if (pp.notTimingZone()) {
                rp.setTimingZone(anno.zone());
            } else {
                rp.setTimingZone(pp.getTimingZone());
            }
            if (pp.notTimingPlan()) {
                log.debug("no prop timingplan, use annotation, key={}", (Object)key);
                rp.setTimingCron(anno.cron());
                rp.setTimingIdle(anno.idle());
                rp.setTimingRate(anno.rate());
            } else {
                rp.setTimingCron(pp.getTimingCron());
                rp.setTimingIdle(pp.getTimingIdle());
                rp.setTimingRate(pp.getTimingRate());
            }
        }
        if (pp != null) {
            rp.setEnabled(pp.isEnabled());
            rp.setAutorun(pp.isAutorun());
            rp.setVersion(pp.getVersion());
            rp.setTaskerBean(pp.getTaskerBean());
            rp.setTaskerPara(pp.getTaskerPara());
            rp.setTaskerName(pp.getTaskerName());
            rp.setTaskerFast(pp.isTaskerFast());
            rp.setTimingMiss(pp.getTimingMiss());
            rp.setTimingBeat(pp.getTimingBeat());
            rp.setDuringFrom(pp.getDuringFrom());
            rp.setDuringStop(pp.getDuringStop());
            rp.setDuringExec(pp.getDuringExec());
            rp.setDuringFail(pp.getDuringFail());
            rp.setDuringDone(pp.getDuringDone());
            rp.setDuringBoot(pp.getDuringBoot());
        }
        rp.setTaskerApps(pp == null || pp.notTaskerApps() ? df.getTaskerApps() : pp.getTaskerApps());
        rp.setTaskerRuns(pp == null || pp.notTaskerRuns() ? df.getTaskerRuns() : pp.getTaskerRuns());
        rp.setNoticeBean(pp == null || pp.notNoticeBean() ? df.getNoticeBean() : pp.getNoticeBean());
        rp.setNoticeWhen(pp == null || pp.notNoticeWhen() ? df.getNoticeWhen() : pp.getNoticeWhen());
        rp.setNoticeConf(pp == null || pp.notNoticeConf() ? df.getNoticeConf() : pp.getNoticeConf());
        rp.setTimingZone(pp == null || pp.notTimingZone() ? df.getTimingZone() : pp.getTimingZone());
        rp.setTimingType(pp == null || pp.notTimingType() ? df.getTimingType() : pp.getTimingType());
        rp.setResultKeep(pp == null || pp.notResultKeep() ? df.getResultKeep() : pp.getResultKeep());
        return rp;
    }

    @Override
    @Contract(value="_,true->!null")
    public TaskerProp database(long id, boolean nonnull) {
        TaskerProp conf = this.fetchProp(TaskerProp.class, t -> t.Id.eq((Object)id));
        if (conf == null && nonnull) {
            throw new IllegalArgumentException("database tasker is null, id=" + id);
        }
        return conf;
    }

    @Override
    @Contract(value="_,true->!null")
    public TaskerProp property(long id, boolean nonnull) {
        WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        Record2 r2 = (Record2)this.winTaskDefineDao.ctx().select((SelectField)t.Propkey, (SelectField)t.TaskerBean).from((TableLike)t).where(t.Id.eq((Object)id)).fetchOne();
        if (r2 == null || StringUtils.isEmpty((CharSequence)((CharSequence)r2.value1())) || StringUtils.isEmpty((CharSequence)((CharSequence)r2.value2()))) {
            if (nonnull) {
                throw new IllegalArgumentException("database tasker is null, id=" + id);
            }
            return null;
        }
        TinyTasker anno = this.referAnno((String)r2.value2());
        AssertArgs.notNull((Object)anno, (String)"database without TinyTasker, id={}", (Object[])new Object[]{id});
        return this.property((String)r2.value1(), anno);
    }

    @Override
    @NotNull
    public LinkedHashMap<String, Diff.V<?>> diffProp(long id) {
        WinTaskDefine po = this.fetchProp(WinTaskDefine.class, t -> t.Id.eq((Object)id));
        AssertArgs.notNull((Object)po, (String)"database tasker is null, id={}", (Object[])new Object[]{id});
        TinyTasker anno = this.referAnno(po.getTaskerBean());
        AssertArgs.notNull((Object)anno, (String)"database without TinyTasker, id={}", (Object[])new Object[]{id});
        TaskerProp prop = this.property(po.getPropkey(), anno);
        return this.diff(po, prop);
    }

    private TinyTasker referAnno(String token) {
        TaskerExec tk = ExecHolder.getTasker(token, false);
        Method md = tk != null ? tk.getBeanMethod() : TaskerHelper.referMethod(token);
        return md.getAnnotation(TinyTasker.class);
    }

    @Override
    @Transactional
    public boolean enable(long id, boolean enabled) {
        return (Boolean)this.journalService.submit((Enum)Jane.Enable, journal -> {
            WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
            int rc = this.winTaskDefineDao.ctx().update((Table)t).set((Field)t.Enabled, (Object)enabled).set((Field)t.CommitId, (Object)journal.getCommitId()).set((Field)t.ModifyDt, (Object)journal.getCommitDt()).where(t.Id.eq((Object)id)).execute();
            return rc > 0;
        });
    }

    @Override
    @Transactional
    public boolean replace(long id, TaskerProp prop) {
        return this.updateProp(prop, null, id);
    }

    private TinyTaskConfService.Conf config(@NotNull Class<?> claz, @NotNull Object bean, @NotNull Method method, @Nullable Object para) {
        String noticeBean;
        boolean autorun;
        boolean enabled;
        long id;
        TaskerExec tasker;
        TaskerProp prop;
        TinyTasker anno = method.getAnnotation(TinyTasker.class);
        if (anno == null) {
            throw new IllegalStateException("need @TinyTasker, tasker method=" + method.getName() + ", class=" + claz.getName());
        }
        String key = anno.value();
        if (StringUtils.isEmpty((CharSequence)key)) {
            key = TaskerHelper.tokenize(claz, method.getName());
        }
        if ((prop = this.property(key, anno)).notTimingPlan()) {
            throw new IllegalStateException("need cron/idle/rate ,method=" + method.getName() + ", class=" + claz.getName() + " ,prop=" + key);
        }
        String tkn = TaskerHelper.tokenize(claz, method.getName());
        log.debug("find tiny task, prop={}, ref={}", (Object)key, (Object)tkn);
        if (StringUtils.isEmpty((CharSequence)prop.getTaskerName())) {
            prop.setTaskerName(claz.getSimpleName() + "#" + method.getName());
        }
        if (!method.equals((tasker = ExecHolder.getTasker(tkn, k -> new TaskerExec(claz, bean, method))).getBeanMethod())) {
            throw new IllegalStateException("diff method with same token=" + tkn);
        }
        prop.setTaskerBean(tkn);
        prop.setTaskerPara(tasker.encodePara(para));
        WinTaskDefine po = this.fetchProp(WinTaskDefine.class, t -> t.TaskerBean.eq((Object)tkn));
        if (po == null) {
            id = this.insertProp(prop, key);
            enabled = prop.isEnabled();
            autorun = prop.isAutorun();
            noticeBean = prop.getNoticeBean();
            log.debug("insert prop to database, version={}, id={}", (Object)prop.getVersion(), (Object)id);
        } else if (po.getVersion() < prop.getVersion()) {
            id = po.getId();
            enabled = prop.isEnabled();
            autorun = prop.isAutorun();
            noticeBean = prop.getNoticeBean();
            this.updateProp(prop, key, id);
            log.debug("replace prop to database, version={}, id={}", (Object)prop.getVersion(), (Object)id);
        } else {
            id = po.getId();
            enabled = BoxedCastUtil.orTrue((Boolean)po.getEnabled());
            autorun = BoxedCastUtil.orTrue((Boolean)po.getAutorun());
            noticeBean = po.getNoticeBean();
            log.debug("use database config, version={}, id={}", (Object)prop.getVersion(), (Object)id);
            LinkedHashMap<String, Diff.V<?>> df = this.diff(po, prop);
            if (!df.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append('\n');
                for (Map.Entry<String, Diff.V<?>> en : df.entrySet()) {
                    sb.append(en.getKey()).append(':');
                    sb.append("db=").append(en.getValue().getV1());
                    sb.append(", pp=").append(en.getValue().getV2());
                    sb.append('\n');
                }
                log.warn("database diff from properties, diff={}", (Object)sb);
            }
        }
        if (noticeBean != null && !noticeBean.isEmpty()) {
            ExecHolder.getNotice(noticeBean, k -> {
                try {
                    Class cz = ClassUtils.forName((String)noticeBean, null);
                    SmallNotice nb = (SmallNotice)this.applicationContext.getBean(cz);
                    return new NoticeExec(nb);
                }
                catch (ClassNotFoundException e) {
                    log.error("failed to init notice bean=" + noticeBean, (Throwable)e);
                    throw new IllegalArgumentException(e);
                }
            });
        }
        return new TinyTaskConfService.Conf(id, enabled, autorun);
    }

    private long insertProp(TaskerProp prop, String key) {
        return (Long)this.journalService.submit((Enum)Jane.Insert, journal -> {
            WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
            long id = this.lightIdService.getId((LightIdAware)t);
            WinTaskDefine po = this.genWinTaskDefine(prop, key);
            po.setId(Long.valueOf(id));
            po.setNextLock(Integer.valueOf(0));
            journal.create((JournalAware)po);
            this.winTaskDefineDao.insert((Object)po);
            return id;
        });
    }

    private boolean updateProp(TaskerProp prop, String key, long id) {
        return (Boolean)this.journalService.submit((Enum)Jane.Update, journal -> {
            WinTaskDefine po = this.genWinTaskDefine(prop, key);
            po.setId(Long.valueOf(id));
            journal.modify((JournalAware)po);
            int rc = this.winTaskDefineDao.update((Object)po, true);
            return rc > 0;
        });
    }

    @NotNull
    private WinTaskDefine genWinTaskDefine(TaskerProp prop, String key) {
        WinTaskDefine po = new WinTaskDefine();
        po.setEnabled(Boolean.valueOf(prop.isEnabled()));
        po.setAutorun(Boolean.valueOf(prop.isAutorun()));
        po.setVersion(Integer.valueOf(prop.getVersion()));
        po.setPropkey(key);
        po.setTaskerBean(prop.getTaskerBean());
        po.setTaskerPara(prop.getTaskerPara());
        po.setTaskerName(prop.getTaskerName());
        po.setTaskerFast(Boolean.valueOf(prop.isTaskerFast()));
        String apps = prop.getTaskerApps();
        po.setTaskerApps(StringUtils.isEmpty((CharSequence)apps) ? this.appName : apps);
        String runs = prop.getTaskerRuns();
        if (StringUtils.isEmpty((CharSequence)runs)) {
            RunMode rm = RuntimeMode.getRunMode();
            po.setTaskerRuns(rm == RunMode.Nothing ? "" : rm.name().toLowerCase());
        } else {
            po.setTaskerRuns(runs);
        }
        po.setNoticeBean(prop.getNoticeBean());
        po.setNoticeWhen(prop.getNoticeWhen());
        po.setNoticeConf(prop.getNoticeConf());
        po.setTimingZone(prop.getTimingZone());
        po.setTimingType(prop.getTimingType());
        po.setTimingCron(prop.getTimingCron());
        po.setTimingIdle(Integer.valueOf(prop.getTimingIdle()));
        po.setTimingRate(Integer.valueOf(prop.getTimingRate()));
        po.setTimingMiss(Integer.valueOf(prop.getTimingMiss()));
        po.setTimingBeat(Integer.valueOf(prop.getTimingBeat()));
        po.setDuringFrom(prop.getDuringFrom());
        po.setDuringStop(prop.getDuringStop());
        po.setDuringExec(Integer.valueOf(prop.getDuringExec()));
        po.setDuringFail(Integer.valueOf(prop.getDuringFail()));
        po.setDuringDone(Integer.valueOf(prop.getDuringDone()));
        po.setDuringBoot(Integer.valueOf(prop.getDuringBoot()));
        po.setResultKeep(Integer.valueOf(prop.getResultKeep()));
        return po;
    }

    private <T> T fetchProp(Class<T> claz, Function<WinTaskDefineTable, Condition> cond) {
        WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        return (T)this.winTaskDefineDao.ctx().select(new SelectFieldOrAsterisk[]{t.Id, t.Propkey, t.Enabled, t.Autorun, t.Version, t.TaskerBean, t.TaskerPara, t.TaskerName, t.TaskerFast, t.TaskerApps, t.TaskerRuns, t.NoticeBean, t.NoticeWhen, t.NoticeConf, t.TimingZone, t.TimingType, t.TimingCron, t.TimingIdle, t.TimingRate, t.TimingMiss, t.TimingBeat, t.DuringFrom, t.DuringStop, t.DuringExec, t.DuringFail, t.DuringDone, t.DuringBoot, t.ResultKeep}).from((TableLike)t).where(cond.apply(t)).fetchOneInto(claz);
    }

    private LinkedHashMap<String, Diff.V<?>> diff(WinTaskDefine v1, TaskerProp v2) {
        LinkedHashMap result = new LinkedHashMap();
        Diff.V.diff(result, (Object)"enabled", (Object)v1.getEnabled(), (Object)v2.isEnabled());
        Diff.V.diff(result, (Object)"autorun", (Object)v1.getAutorun(), (Object)v2.isAutorun());
        Diff.V.diff(result, (Object)"version", (Object)v1.getVersion(), (Object)v2.getVersion());
        Diff.V.diff(result, (Object)"taskerBean", (Object)v1.getTaskerBean(), (Object)v2.getTaskerBean());
        Diff.V.diff(result, (Object)"taskerPara", (Object)v1.getTaskerPara(), (Object)v2.getTaskerPara());
        Diff.V.diff(result, (Object)"taskerName", (Object)v1.getTaskerName(), (Object)v2.getTaskerName());
        Diff.V.diff(result, (Object)"taskerFast", (Object)v1.getTaskerFast(), (Object)v2.isTaskerFast());
        Diff.V.diff(result, (Object)"taskerApps", (Object)v1.getTaskerApps(), (Object)v2.getTaskerApps());
        Diff.V.diff(result, (Object)"taskerRuns", (Object)v1.getTaskerRuns(), (Object)v2.getTaskerRuns());
        Diff.V.diff(result, (Object)"noticeBean", (Object)v1.getNoticeBean(), (Object)v2.getNoticeBean());
        Diff.V.diff(result, (Object)"noticeWhen", (Object)v1.getNoticeWhen(), (Object)v2.getNoticeWhen());
        Diff.V.diff(result, (Object)"noticeConf", (Object)v1.getNoticeConf(), (Object)v2.getNoticeConf());
        Diff.V.diff(result, (Object)"timingZone", (Object)v1.getTimingZone(), (Object)v2.getTimingZone());
        Diff.V.diff(result, (Object)"timingType", (Object)v1.getTimingType(), (Object)v2.getTimingType());
        Diff.V.diff(result, (Object)"timingCron", (Object)v1.getTimingCron(), (Object)v2.getTimingCron());
        Diff.V.diff(result, (Object)"timingIdle", (Object)v1.getTimingIdle(), (Object)v2.getTimingIdle());
        Diff.V.diff(result, (Object)"timingRate", (Object)v1.getTimingRate(), (Object)v2.getTimingRate());
        Diff.V.diff(result, (Object)"timingMiss", (Object)v1.getTimingMiss(), (Object)v2.getTimingMiss());
        Diff.V.diff(result, (Object)"timingBeat", (Object)v1.getTimingBeat(), (Object)v2.getTimingBeat());
        Diff.V.diff(result, (Object)"duringFrom", (Object)v1.getDuringFrom(), (Object)v2.getDuringFrom());
        Diff.V.diff(result, (Object)"duringStop", (Object)v1.getDuringStop(), (Object)v2.getDuringStop());
        Diff.V.diff(result, (Object)"duringExec", (Object)v1.getDuringExec(), (Object)v2.getDuringExec());
        Diff.V.diff(result, (Object)"duringFail", (Object)v1.getDuringFail(), (Object)v2.getDuringFail());
        Diff.V.diff(result, (Object)"duringDone", (Object)v1.getDuringDone(), (Object)v2.getDuringDone());
        Diff.V.diff(result, (Object)"duringBoot", (Object)v1.getDuringBoot(), (Object)v2.getDuringBoot());
        Diff.V.diff(result, (Object)"resultKeep", (Object)v1.getResultKeep(), (Object)v2.getResultKeep());
        return result;
    }

    @Value(value="${spring.application.name}")
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Autowired
    public void setTinyTaskDefineProp(TinyTaskDefineProp tinyTaskDefineProp) {
        this.tinyTaskDefineProp = tinyTaskDefineProp;
    }

    @Autowired
    public void setWinTaskDefineDao(WinTaskDefineDao winTaskDefineDao) {
        this.winTaskDefineDao = winTaskDefineDao;
    }

    @Autowired
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }

    @Autowired
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    public static enum Jane {
        Insert,
        Update,
        Enable;

    }
}

