/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.scheduling.support.SimpleTriggerContext;
import org.springframework.stereotype.Service;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.lock.JvmStaticGlobalLock;
import pro.fessional.mirana.pain.ThrowableUtil;
import pro.fessional.mirana.stat.JvmStat;
import pro.fessional.mirana.time.DateLocaling;
import pro.fessional.mirana.time.DateParser;
import pro.fessional.mirana.time.Sleep;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.convention.EmptySugar;
import pro.fessional.wings.faceless.convention.EmptyValue;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.silencer.modulate.RunMode;
import pro.fessional.wings.silencer.modulate.RuntimeMode;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.spring.help.CommonPropHelper;
import pro.fessional.wings.slardar.async.TaskSchedulerHelper;
import pro.fessional.wings.slardar.jackson.JacksonHelper;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskDefineTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskDefineDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskResultDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskDefine;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskResult;
import pro.fessional.wings.tiny.task.schedule.exec.ExecHolder;
import pro.fessional.wings.tiny.task.schedule.exec.NoticeExec;
import pro.fessional.wings.tiny.task.schedule.exec.TaskerExec;
import pro.fessional.wings.tiny.task.service.TinyTaskExecService;
import pro.fessional.wings.tiny.task.spring.prop.TinyTaskExecProp;

@Service
@ConditionalWingsEnabled
public class TinyTaskExecServiceImpl
implements TinyTaskExecService {
    private static final Logger log = LoggerFactory.getLogger(TinyTaskExecServiceImpl.class);
    protected static final ConcurrentHashMap<Long, ScheduledFuture<?>> Handle = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<Long, Boolean> Cancel = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<Long, Integer> Booted = new ConcurrentHashMap();
    protected String appName;
    protected WinTaskDefineDao winTaskDefineDao;
    protected WinTaskResultDao winTaskResultDao;
    protected LightIdService lightIdService;
    protected JournalService journalService;
    protected TinyTaskExecProp execProp;

    @Override
    public boolean launch(long id) {
        Cancel.remove(id);
        return this.relaunch(id);
    }

    @Override
    public boolean force(long id) {
        WinTaskDefine td = this.winTaskDefineDao.fetchOneById(Long.valueOf(id));
        if (td == null) {
            log.info("skip task for not found, id={}", (Object)id);
            return false;
        }
        boolean fast = BoxedCastUtil.orTrue((Boolean)td.getTaskerFast());
        TaskSchedulerHelper.referScheduler((boolean)fast).schedule(() -> {
            long execTms = ThreadNow.millis();
            long doneTms = -1L;
            long failTms = -1L;
            String taskerName = td.getTaskerName() + " force";
            String noticeConf = td.getNoticeConf();
            Object taskMsg = "force task id=" + id;
            NoticeExec<?> notice = null;
            Set<String> ntcWhen = Collections.emptySet();
            try {
                Object result;
                TaskerExec tasker = ExecHolder.getTasker(td.getTaskerBean(), true);
                notice = ExecHolder.getNotice(td.getNoticeBean(), false);
                if (notice != null) {
                    ntcWhen = this.noticeWhen(td.getNoticeWhen());
                }
                this.postNotice(notice, noticeConf, ntcWhen, taskerName, (String)taskMsg, execTms, "exec");
                log.debug("task force exec, id={}", (Object)id);
                if (this.execProp.isDryrun()) {
                    int slp = RandomUtils.nextInt((int)10, (int)2000);
                    result = "dryrun and sleep " + slp;
                    Sleep.ignoreInterrupt((long)slp);
                    log.info("task force done, dryrun and sleep {} ms, id={}", (Object)slp, (Object)id);
                } else {
                    result = tasker.invoke(td.getTaskerPara(), true);
                    log.info("task force done, id={}", (Object)id);
                }
                doneTms = ThreadNow.millis();
                taskMsg = this.stringResult(result);
                this.postNotice(notice, noticeConf, ntcWhen, taskerName, (String)taskMsg, doneTms, "feed", "done");
            }
            catch (Exception e) {
                log.error("task force fail, id=" + id, (Throwable)e);
                failTms = ThreadNow.millis();
                taskMsg = ThrowableUtil.toString((Throwable)e);
                this.postNotice(notice, noticeConf, ntcWhen, taskerName, (String)taskMsg, failTms, "fail");
            }
            finally {
                try {
                    this.saveResult(id, execTms, failTms, doneTms, (String)taskMsg, td.getDurFail());
                }
                catch (Exception e) {
                    log.error("failed to save result, id=" + id, (Throwable)e);
                }
            }
        }, Instant.ofEpochMilli(ThreadNow.millis()));
        return true;
    }

    @Override
    public boolean cancel(long id) {
        Cancel.put(id, Boolean.TRUE);
        ScheduledFuture<?> ft = Handle.get(id);
        if (ft == null) {
            log.info("cancel not found, id={}", (Object)id);
            return true;
        }
        boolean r = ft.cancel(false);
        if (r) {
            Handle.remove(id);
        }
        log.info("cancel success={}, id={}", (Object)r, (Object)id);
        return r;
    }

    @Override
    public Set<Long> running() {
        HashSet<Long> set = new HashSet<Long>();
        Enumeration<Long> en = Handle.keys();
        while (en.hasMoreElements()) {
            set.add(en.nextElement());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean relaunch(long id) {
        Lock lock = JvmStaticGlobalLock.get((Object[])new Object[]{id});
        try {
            lock.lock();
            if (Handle.containsKey(id)) {
                log.info("skip task for launching, id={}", (Object)id);
                boolean bl = false;
                return bl;
            }
            WinTaskDefine td = this.winTaskDefineDao.fetchOneById(Long.valueOf(id));
            if (td == null) {
                log.info("skip task for not found, id={}", (Object)id);
                boolean bl = false;
                return bl;
            }
            if (this.notEnable(td.getEnabled(), id) || this.notApps(td.getTaskerApps(), id) || this.notRuns(td.getTaskerRuns(), id)) {
                boolean bl = false;
                return bl;
            }
            long next = this.calcNextExec(td);
            if (next < 0L) {
                boolean bl = false;
                return bl;
            }
            this.saveNextExec(next, td);
            boolean fast = BoxedCastUtil.orTrue((Boolean)td.getTaskerFast());
            ThreadPoolTaskScheduler taskScheduler = TaskSchedulerHelper.referScheduler((boolean)fast);
            if (taskScheduler.getScheduledExecutor().isShutdown()) {
                log.error("TaskScheduler={} is shutdown, name={} id={}", new Object[]{fast, td.getTaskerName(), td.getId()});
                boolean bl = false;
                return bl;
            }
            log.info("prepare task name={}, id={}", (Object)td.getTaskerName(), (Object)td.getId());
            ScheduledFuture handle = taskScheduler.schedule(() -> {
                long execTms = ThreadNow.millis();
                try {
                    if (this.notNextLock(td, execTms)) {
                        log.warn("skip task for Not nextLock, should manually check and launch it, id={}", (Object)id);
                        Handle.remove(id);
                        return;
                    }
                }
                catch (Exception e) {
                    log.warn("failed to check nextLock", (Throwable)e);
                    Handle.remove(id);
                    return;
                }
                long doneTms = -1L;
                long failTms = -1L;
                String taskerName = td.getTaskerName();
                String noticeConf = td.getNoticeConf();
                Object taskMsg = "relaunch task id=" + id;
                NoticeExec<?> notice = null;
                Set<String> ntcWhen = Collections.emptySet();
                try {
                    Object result;
                    TaskerExec tasker = ExecHolder.getTasker(td.getTaskerBean(), true);
                    notice = ExecHolder.getNotice(td.getNoticeBean(), false);
                    if (notice != null) {
                        ntcWhen = this.noticeWhen(td.getNoticeWhen());
                    }
                    this.postNotice(notice, noticeConf, ntcWhen, taskerName, (String)taskMsg, execTms, "exec");
                    log.info("task exec, id={}", (Object)id);
                    if (this.execProp.isDryrun()) {
                        int slp = RandomUtils.nextInt((int)10, (int)2000);
                        result = "dryrun and sleep " + slp;
                        Sleep.ignoreInterrupt((long)slp);
                        log.info("task done, dryrun and sleep {} ms, id={}", (Object)slp, (Object)id);
                    } else {
                        result = tasker.invoke(td.getTaskerPara(), true);
                        log.info("task done, id={}", (Object)id);
                    }
                    doneTms = ThreadNow.millis();
                    taskMsg = this.stringResult(result);
                    this.postNotice(notice, noticeConf, ntcWhen, taskerName, (String)taskMsg, doneTms, "feed", "done");
                }
                catch (Exception e) {
                    log.error("task fail, id=" + id, (Throwable)e);
                    failTms = ThreadNow.millis();
                    taskMsg = ThrowableUtil.toString((Throwable)e);
                    this.postNotice(notice, noticeConf, ntcWhen, taskerName, (String)taskMsg, failTms, "fail");
                }
                finally {
                    try {
                        Handle.remove(id);
                        this.saveResult(id, execTms, failTms, doneTms, (String)taskMsg, td.getDurFail());
                    }
                    catch (Exception e) {
                        log.error("failed to save result, id=" + id, (Throwable)e);
                    }
                    if (this.canRelaunch(id, doneTms, failTms, td)) {
                        this.relaunch(id);
                    }
                }
            }, Instant.ofEpochMilli(next));
            Handle.put(id, handle);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean notEnable(Boolean b, long id) {
        if (BoxedCastUtil.orTrue((Boolean)b)) {
            return false;
        }
        log.info("skip task for not enabled, id={}", (Object)id);
        return true;
    }

    private boolean notApps(String apps, long id) {
        if (StringUtils.isEmpty((CharSequence)apps)) {
            return false;
        }
        for (String s : CommonPropHelper.arrayOrNull((String)apps, (boolean)true)) {
            if (!s.trim().equals(this.appName)) continue;
            return false;
        }
        log.info("skip task for not apps={}, cur={}, id={}", new Object[]{apps, this.appName, id});
        return true;
    }

    private boolean notRuns(String runs, long id) {
        if (StringUtils.isEmpty((CharSequence)runs)) {
            return false;
        }
        RunMode rmd = RuntimeMode.getRunMode();
        if (rmd == RunMode.Nothing) {
            log.info("skip task for not runs={}, cur is null, id={}", (Object)runs, (Object)id);
            return true;
        }
        if (!RuntimeMode.hasRunMode((CharSequence[])CommonPropHelper.arrayOrNull((String)runs, (boolean)true))) {
            log.info("skip task for not runs={}, cur={}, id={}", new Object[]{runs, rmd, id});
            return true;
        }
        return false;
    }

    private Set<String> noticeWhen(String nw) {
        if (nw == null || nw.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> rs = new HashSet<String>();
        for (String s : CommonPropHelper.arrayOrNull((String)nw, (boolean)true)) {
            rs.add(s.trim().toLowerCase());
        }
        return rs;
    }

    private String stringResult(Object result) {
        if (result == null) {
            return null;
        }
        if (result instanceof CharSequence) {
            return result.toString();
        }
        return JacksonHelper.string((Object)result);
    }

    private void postNotice(NoticeExec<?> ntc, String cnf, Set<String> whs, String tn, String msg, long ms, String ... wh) {
        if (ntc == null) {
            return;
        }
        String zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(ms), ThreadNow.sysZoneId()).toString();
        for (String w : wh) {
            if (!whs.contains(w)) continue;
            if (w.equals("feed")) {
                if (this.execProp.isDryrun() || !StringUtils.isNotEmpty((CharSequence)msg)) continue;
                ntc.postNotice(cnf, tn + " " + w.toUpperCase(), zdt + "\n\n" + msg);
                return;
            }
            ntc.postNotice(cnf, tn + " " + w.toUpperCase(), (String)(msg == null ? zdt : zdt + "\n\n" + msg));
            return;
        }
    }

    private void saveNextExec(long next, WinTaskDefine td) {
        this.journalService.commit((Enum)Jane.SaveNextExec, journal -> {
            WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
            this.winTaskDefineDao.ctx().update((Table)t).set((Field)t.CommitId, (Object)journal.getCommitId()).set((Field)t.ModifyDt, (Object)journal.getCommitDt()).set((Field)t.NextExec, (Object)this.milliLdt(next, ThreadNow.sysZoneId())).where(t.Id.eq((Object)td.getId())).execute();
        });
    }

    private boolean notNextLock(WinTaskDefine td, long now) {
        WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        int rc = this.winTaskDefineDao.ctx().update((Table)t).set((Field)t.NextLock, t.NextLock.add((Number)1)).set((Field)t.LastExec, (Object)this.milliLdt(now, ThreadNow.sysZoneId())).where(t.Id.eq((Object)td.getId()).and(t.NextLock.eq((Object)td.getNextLock()))).execute();
        return rc <= 0;
    }

    private void saveResult(Long id, long exec, long fail, long done, String msg, int cf) {
        WinTaskDefineTable td = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        HashMap<TableField, Comparable<ChronoLocalDateTime<Object>>> setter = new HashMap<TableField, Comparable<ChronoLocalDateTime<Object>>>();
        setter.put(td.LastExec, this.milliLdt(exec, ThreadNow.sysZoneId()));
        setter.put(td.SumExec, (Comparable<ChronoLocalDateTime<Object>>)td.SumExec.add((Number)1));
        setter.put(td.NextExec, EmptyValue.DATE_TIME);
        if (fail > 0L) {
            setter.put(td.LastFail, this.milliLdt(fail, ThreadNow.sysZoneId()));
            setter.put(td.LastDone, EmptyValue.DATE_TIME);
            setter.put(td.SumFail, (Comparable<ChronoLocalDateTime<Object>>)td.SumFail.add((Number)1));
            setter.put(td.DurFail, (Comparable<ChronoLocalDateTime<Object>>)(cf > 0 ? td.DurFail.add((Number)1) : Integer.valueOf(1)));
        } else {
            setter.put(td.LastFail, EmptyValue.DATE_TIME);
            setter.put(td.LastDone, this.milliLdt(done, ThreadNow.sysZoneId()));
            setter.put(td.SumDone, (Comparable<ChronoLocalDateTime<Object>>)td.SumDone.add((Number)1));
            setter.put(td.DurFail, Integer.valueOf(0));
        }
        WinTaskResult po = new WinTaskResult();
        po.setId(Long.valueOf(this.lightIdService.getId((LightIdAware)this.winTaskResultDao.getTable())));
        po.setTaskId(id);
        po.setTaskApp(this.appName);
        po.setTaskPid(Integer.valueOf(JvmStat.jvmPid()));
        po.setTaskMsg(msg);
        ZoneId zidSys = ThreadNow.sysZoneId();
        po.setTimeExec(this.milliLdt(exec, zidSys));
        po.setTimeFail(this.milliLdt(fail, zidSys));
        po.setTimeDone(this.milliLdt(done, zidSys));
        po.setTimeCost(Integer.valueOf((int)(Math.max(done, fail) - exec)));
        this.journalService.commit((Enum)Jane.SaveResult, journal -> {
            setter.put(td.CommitId, (Comparable<ChronoLocalDateTime<Object>>)journal.getCommitId());
            setter.put(td.ModifyDt, journal.getCommitDt());
            this.winTaskDefineDao.ctx().update((Table)td).set(setter).where(td.Id.eq((Object)id)).execute();
            this.winTaskResultDao.insert((Object)po);
        });
    }

    private LocalDateTime milliLdt(long m, ZoneId zid) {
        if (m < 0L) {
            return EmptyValue.DATE_TIME;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(m), zid);
    }

    private boolean canRelaunch(long id, long doneTms, long failTms, WinTaskDefine td) {
        int bct;
        int duringExec = td.getDuringExec();
        int sumExec = td.getSumExec();
        if (duringExec > 0 && duringExec <= sumExec + 1) {
            log.info("remove task for duringExec={}, sumExec={}, id={}", new Object[]{duringExec, sumExec, id});
            return false;
        }
        int duringDone = td.getDuringDone();
        int sumDone = td.getSumDone();
        if (duringDone > 0 && duringDone <= (doneTms < 0L ? sumDone : sumDone + 1)) {
            log.info("remove task for duringDone={}, sumDone={}, id={}", new Object[]{duringDone, sumDone, id});
            return false;
        }
        int duringFail = td.getDuringFail();
        int durFail = td.getDurFail();
        if (duringFail > 0 && duringFail <= (failTms < 0L ? durFail : durFail + 1)) {
            log.info("remove task for duringFail={}, durFail={}, id={}", new Object[]{duringFail, durFail, id});
            return false;
        }
        if (Cancel.containsKey(id)) {
            log.info("remove task for canceled, id={}", (Object)id);
            return false;
        }
        int duringBoot = td.getDuringBoot();
        if (duringBoot > 0 && (bct = Booted.compute(id, (ignored, v) -> v == null ? 1 : v + 1).intValue()) >= duringBoot) {
            log.info("remove task for duringBoot={}, id={}", (Object)bct, (Object)id);
            return false;
        }
        return true;
    }

    private long calcNextExec(WinTaskDefine td) {
        long nxt;
        Instant next;
        long now;
        String zid = td.getTimingZone();
        ZoneId zone = StringUtils.isEmpty((CharSequence)zid) ? ThreadNow.sysZoneId() : ZoneId.of(zid);
        if (this.notRanged(td, zone, now = ThreadNow.millis())) {
            return -1L;
        }
        Long id = td.getId();
        long timingMiss = (long)td.getTimingMiss().intValue() * 1000L;
        long nextMs = DateLocaling.sysEpoch((LocalDateTime)td.getNextExec());
        if (nextMs + timingMiss >= now) {
            log.info("launch misfire task, id={}", (Object)id);
            return nextMs;
        }
        Trigger trigger = this.makeTrigger(td, zone);
        SimpleTriggerContext context = this.makeContext(td, zone, now);
        while (true) {
            if ((next = trigger.nextExecution((TriggerContext)context)) == null) {
                log.info("skip task for trigger not fire, id={}", (Object)id);
                return -1L;
            }
            nxt = next.toEpochMilli();
            if (nxt >= now) break;
            if (timingMiss > 0L && nxt + timingMiss >= now) {
                log.info("launch task for misfire={}, id={}", (Object)next, (Object)id);
                return nxt;
            }
            context.update(next, next, next);
        }
        log.info("launch task for next={}, id={}", (Object)next, (Object)id);
        return nxt;
    }

    private SimpleTriggerContext makeContext(WinTaskDefine td, ZoneId zone, long now) {
        Instant lastActual = null;
        LocalDateTime lastExec = td.getLastExec();
        if (!EmptySugar.asEmptyValue((LocalDateTime)lastExec)) {
            lastActual = Instant.ofEpochMilli(DateLocaling.sysEpoch((LocalDateTime)lastExec));
        }
        Instant lastCompletion = null;
        LocalDateTime lastDone = td.getLastDone();
        if (!EmptySugar.asEmptyValue((LocalDateTime)lastDone)) {
            lastCompletion = Instant.ofEpochMilli(DateLocaling.sysEpoch((LocalDateTime)lastDone));
        }
        return new SimpleTriggerContext(lastActual, lastActual, lastCompletion);
    }

    private Trigger makeTrigger(WinTaskDefine td, ZoneId zone) {
        String cron = td.getTimingCron();
        if (StringUtils.isNotEmpty((CharSequence)cron)) {
            log.info("use trigger cron={}, id={}", (Object)cron, (Object)td.getId());
            return new CronTrigger(cron, zone);
        }
        int idle = td.getTimingIdle();
        if (idle > 0) {
            log.info("use trigger idle={}, id={}", (Object)idle, (Object)td.getId());
            PeriodicTrigger trg = new PeriodicTrigger(Duration.ofSeconds(idle));
            trg.setFixedRate(false);
            return trg;
        }
        int rate = td.getTimingRate();
        if (rate > 0) {
            log.info("use trigger rate={}, id={}", (Object)rate, (Object)td.getId());
            PeriodicTrigger trg = new PeriodicTrigger(Duration.ofSeconds(rate));
            trg.setFixedRate(true);
            return trg;
        }
        throw new IllegalArgumentException("no cron/idle/rate to make trigger");
    }

    private boolean notRanged(WinTaskDefine td, ZoneId zone, long now) {
        LocalDateTime ldt;
        long ms;
        LocalDateTime ldt2;
        long ms2;
        String duringFrom = td.getDuringFrom();
        if (StringUtils.isNotEmpty((CharSequence)duringFrom) && (ms2 = DateLocaling.useEpoch((LocalDateTime)(ldt2 = DateParser.parseDateTime((CharSequence)duringFrom)), (ZoneId)zone)) > now) {
            log.info("skip task for duringFrom={}, id={}", (Object)duringFrom, (Object)td.getId());
            return true;
        }
        String duringStop = td.getDuringStop();
        if (StringUtils.isNotEmpty((CharSequence)duringStop) && (ms = DateLocaling.useEpoch((LocalDateTime)(ldt = DateParser.parseDateTime((CharSequence)duringStop)), (ZoneId)zone)) < now) {
            log.info("skip task for duringStop={}, id={}", (Object)duringStop, (Object)td.getId());
            return true;
        }
        int duringExec = td.getDuringExec();
        if (duringExec > 0 && duringExec <= td.getSumExec()) {
            log.info("skip task for duringExec={}, sumExec={}", (Object)duringExec, (Object)td.getSumExec());
            return true;
        }
        int duringDone = td.getDuringDone();
        if (duringDone > 0 && duringDone <= td.getSumDone()) {
            log.info("skip task for duringDone={}, sumDone={}", (Object)duringDone, (Object)td.getSumDone());
            return true;
        }
        int duringFail = td.getDuringFail();
        if (duringFail > 0 && duringFail <= td.getDurFail()) {
            log.info("skip task for duringFail={}, durFail={}", (Object)duringFail, (Object)td.getDurFail());
            return true;
        }
        return false;
    }

    @Value(value="${spring.application.name}")
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Autowired
    public void setWinTaskDefineDao(WinTaskDefineDao winTaskDefineDao) {
        this.winTaskDefineDao = winTaskDefineDao;
    }

    @Autowired
    public void setWinTaskResultDao(WinTaskResultDao winTaskResultDao) {
        this.winTaskResultDao = winTaskResultDao;
    }

    @Autowired
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }

    @Autowired
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    @Autowired
    public void setExecProp(TinyTaskExecProp execProp) {
        this.execProp = execProp;
    }

    public static enum Jane {
        SaveNextExec,
        SaveResult;

    }
}

