CREATE TABLE `win_task_define` (
    `id`          BIGINT(20)   NOT NULL COMMENT 'primary key/task_id',
    `create_dt`   DATETIME(3)  NOT NULL DEFAULT NOW(3) COMMENT 'created datetime(sys)',
    `modify_dt`   DATETIME(3)  NOT NULL DEFAULT '1000-01-01' ON UPDATE NOW(3) COMMENT 'modified datetime(sys)',
    `delete_dt`   DATETIME(3)  NOT NULL DEFAULT '1000-01-01' COMMENT 'logic deleted datetime',
    `commit_id`   BIGINT(20)   NOT NULL COMMENT 'commit id',
    `propkey`     VARCHAR(200) NOT NULL DEFAULT '' COMMENT 'conf file key, auto-generated',
    `enabled`     TINYINT(1)   NOT NULL DEFAULT '1' COMMENT 'whether to register and execute',
    `autorun`     TINYINT(1)   NOT NULL DEFAULT '1' COMMENT 'whether to auto register and start',
    `version`     INT(11)      NOT NULL DEFAULT '0' COMMENT 'version number, higher overrides lower one',
    `tasker_bean` VARCHAR(300) NOT NULL DEFAULT '' COMMENT 'beans annotated by TinyTasker, formatted as Class#method',
    `tasker_para` TEXT         NULL     DEFAULT NULL COMMENT 'parameters of the task, object array in json format',
    `tasker_name` VARCHAR(200) NOT NULL DEFAULT '' COMMENT 'task name, used for notice and log, shortClassName#method',
    `tasker_fast` TINYINT(1)   NOT NULL DEFAULT '1' COMMENT 'whether light task, fast execution, completed in seconds',
    `tasker_apps` VARCHAR(500) NOT NULL DEFAULT '' COMMENT 'belong to applications, comma-separated, default spring.application.name',
    `tasker_runs` VARCHAR(100) NOT NULL DEFAULT '' COMMENT 'RunMode(product|test|develop|local), comma-separated case-insensitive',
    `notice_bean` VARCHAR(200) NOT NULL DEFAULT '' COMMENT 'notice bean, SmallNotice type, fullpath of Class',
    `notice_when` VARCHAR(100) NOT NULL DEFAULT 'fail' COMMENT 'timing of notice, exec|fail|done|feed, comma-separated case-insensitive',
    `notice_conf` VARCHAR(200) NOT NULL DEFAULT '' COMMENT 'conf name of notice bean',
    `timing_zone` VARCHAR(100) NOT NULL DEFAULT '' COMMENT 'timezone of scheduling , default system timezone',
    `timing_type` VARCHAR(100) NOT NULL DEFAULT 'cron' COMMENT 'scheduling expression type',
    `timing_cron` VARCHAR(100) NOT NULL DEFAULT '' COMMENT 'scheduling expression content',
    `timing_idle` INT(11)      NOT NULL DEFAULT '0' COMMENT 'fixed idle interval (seconds)',
    `timing_rate` INT(11)      NOT NULL DEFAULT '0' COMMENT 'fixed frequency interval (seconds)',
    `timing_miss` INT(11)      NOT NULL DEFAULT '0' COMMENT 'within how many seconds of a misfire',
    `timing_beat` INT(11)      NOT NULL DEFAULT '0' COMMENT 'interval seconds of heartbeat',
    `during_from` VARCHAR(20)  NOT NULL DEFAULT '' COMMENT 'schedule start datetime at timingZone, yyyy-MM-dd HH:mm:ss',
    `during_stop` VARCHAR(20)  NOT NULL DEFAULT '' COMMENT 'schedule stop datetime at timingZone, yyyy-MM-dd HH:mm:ss',
    `during_exec` INT(11)      NOT NULL DEFAULT '0' COMMENT 'stop schedule after how many total executions',
    `during_fail` INT(11)      NOT NULL DEFAULT '0' COMMENT 'stop schedule after how many consecutive failures',
    `during_done` INT(11)      NOT NULL DEFAULT '0' COMMENT 'stop schedule after how many successful executions',
    `during_boot` INT(11)      NOT NULL DEFAULT '0' COMMENT 'recount each time the app is started, and stop schedule after how many successful executions',
    `result_keep` INT(11)      NOT NULL DEFAULT '60' COMMENT 'how many days to save the execution results',
    `last_exec`   DATETIME(3)  NOT NULL DEFAULT '1000-01-01' COMMENT 'previous exec (sys)',
    `last_fail`   DATETIME(3)  NOT NULL DEFAULT '1000-01-01' COMMENT 'previous fail (sys)',
    `last_done`   DATETIME(3)  NOT NULL DEFAULT '1000-01-01' COMMENT 'previous success (sys)',
    `next_exec`   DATETIME(3)  NOT NULL DEFAULT '1000-01-01' COMMENT 'next exec (sys), default stop',
    `next_lock`   INT(11)      NOT NULL DEFAULT '0' COMMENT 'optimistic lock of exec',
    `dur_fail`    INT(11)      NOT NULL DEFAULT '0' COMMENT 'total count of consecutive fail',
    `sum_exec`    INT(11)      NOT NULL DEFAULT '0' COMMENT 'total count of exec',
    `sum_fail`    INT(11)      NOT NULL DEFAULT '0' COMMENT 'total count of fail',
    `sum_done`    INT(11)      NOT NULL DEFAULT '0' COMMENT 'total count of done',
    PRIMARY KEY (`id`),
    UNIQUE INDEX uq_tasker_bean (`tasker_bean`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='120/Task Define';

CREATE TABLE `win_task_result` (
    `id`        BIGINT(20)   NOT NULL COMMENT 'primary key',
    `task_id`   BIGINT(20)   NOT NULL DEFAULT '0' COMMENT 'task id, win_task_define.id',
    `task_app`  VARCHAR(300) NOT NULL DEFAULT '' COMMENT 'belong to applications, comma-separated',
    `task_pid`  INT(11)      NOT NULL DEFAULT '0' COMMENT 'belong to jvm pid',
    `task_msg`  TEXT         NULL     DEFAULT NULL COMMENT 'Normal or abnormal messages',
    `time_exec` DATETIME(3)  NOT NULL DEFAULT '1000-01-01' COMMENT 'datetime of exec (sys)',
    `time_fail` DATETIME(3)  NOT NULL DEFAULT '1000-01-01' COMMENT 'datetime of fail (sys)',
    `time_done` DATETIME(3)  NOT NULL DEFAULT '1000-01-01' COMMENT 'datetime of done (sys)',
    `time_cost` INT(11)      NOT NULL DEFAULT '0' COMMENT 'mills cost of task',
    PRIMARY KEY (`id`),
    INDEX ix_task_id (`task_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='122/Task Result';
