/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.controller;

import io.swagger.v3.oas.annotations.Operation;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.Q;
import pro.fessional.mirana.page.PageQuery;
import pro.fessional.mirana.page.PageResult;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskResult;
import pro.fessional.wings.tiny.task.service.TinyTaskListService;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.tiny.task.mvc-list")
public class TaskListController {
    protected TinyTaskListService tinyTaskListService;

    @Operation(summary="list of running tasks.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-running}"})
    @ResponseBody
    public PageResult<TinyTaskListService.Item> taskRunning(PageQuery pq) {
        return this.tinyTaskListService.listRunning(pq);
    }

    @Operation(summary="list of defined tasks.")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-defined}"})
    @ResponseBody
    public PageResult<TinyTaskListService.Item> taskDefined(PageQuery pq) {
        return this.tinyTaskListService.listDefined(pq);
    }

    @Operation(summary="list of task results.", description="# Usage\nlist of task results.\n## Params\n* @param id - required, task id\n")
    @PostMapping(value={"${wings.tiny.task.urlmap.task-result}"})
    @ResponseBody
    public PageResult<WinTaskResult> taskResult(@RequestBody Q.Id ins, PageQuery pq) {
        return this.tinyTaskListService.listResult(ins.getId(), pq);
    }

    @Autowired
    @Generated
    public void setTinyTaskListService(TinyTaskListService tinyTaskListService) {
        this.tinyTaskListService = tinyTaskListService;
    }
}

