/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.schedule.help;

import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ClassUtils;

public class TaskerHelper {
    public static final char MethodPrefix = '#';

    public static String tokenize(@NotNull Class<?> beanClass, String method) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(beanClass.getName());
        if (method != null && !method.isEmpty()) {
            sb.append('#').append(method);
        }
        return sb.toString();
    }

    public static Method referMethod(@NotNull String token) {
        int p = token.indexOf(35);
        if (p <= 0) {
            throw new IllegalArgumentException("miss method part, token=" + token);
        }
        Class clz = ClassUtils.forName((String)token.substring(0, p), null);
        String mdn = token.substring(p + 1);
        for (Method md : clz.getDeclaredMethods()) {
            if (!md.getName().equals(mdn)) continue;
            return md;
        }
        throw new NoSuchMethodException(token);
    }

    public static Class<?> referClass(@NotNull String token) {
        int p = token.indexOf(35);
        String clz = p > 0 ? token.substring(0, p) : token;
        return ClassUtils.forName((String)clz, null);
    }

    public static boolean acceptToken(@NotNull Class<?> beanClass, Method method, String token) {
        Class<?> superClass;
        if (token == null || token.isEmpty()) {
            return false;
        }
        int mp = token.lastIndexOf(35);
        String md = null;
        String cn = token;
        if (mp > 0) {
            md = token.substring(mp + 1);
            cn = token.substring(0, mp);
        }
        if (!(superClass = Class.forName(cn)).isAssignableFrom(beanClass)) {
            return false;
        }
        if (md != null) {
            return method.getName().equals(md);
        }
        return true;
    }

    public static boolean acceptBean(@NotNull Class<?> superClass, @NotNull Object beanThis, Object beanThat) {
        if (beanThat == null) {
            return false;
        }
        if (beanThis == beanThat) {
            return true;
        }
        return superClass.isAssignableFrom(AopUtils.getTargetClass((Object)beanThat));
    }
}

