/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service.impl;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pro.fessional.mirana.time.DateLocaling;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskDefineTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskResultTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskDefineDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskResultDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskDefine;
import pro.fessional.wings.tiny.task.schedule.TinyTasker;
import pro.fessional.wings.tiny.task.service.TinyTaskBeatService;

@Service
@ConditionalWingsEnabled
@TinyTasker.Auto
public class TinyTaskBeatServiceImpl
implements TinyTaskBeatService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyTaskBeatServiceImpl.class);
    protected WinTaskDefineDao winTaskDefineDao;
    protected WinTaskResultDao winTaskResultDao;
    protected int beatTimes = 2;
    private volatile boolean warmed = false;

    @Override
    @TinyTasker(value="TinyTaskCleanResult")
    public int cleanResult() {
        WinTaskResultTable tr = (WinTaskResultTable)this.winTaskResultDao.getTable();
        List tid = this.winTaskResultDao.ctx().selectDistinct(tr.TaskId).from((TableLike)tr).fetchInto(Long.class);
        if (tid.isEmpty()) {
            log.debug("no task result to clean");
            return 0;
        }
        WinTaskDefineTable td = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        Result hst = this.winTaskDefineDao.ctx().select(td.Id, td.ResultKeep).from((TableLike)td).where(td.Id.in((Collection)tid)).fetch();
        LocalDateTime now = ThreadNow.localDate().atStartOfDay();
        List cond = hst.stream().map(it -> tr.TaskId.eq((Object)((Long)it.value1())).and(tr.TimeExec.le((Object)now.minusDays(((Integer)it.value2()).intValue())))).collect(Collectors.toList());
        if (cond.isEmpty()) {
            log.debug("no task condition to clean");
            return 0;
        }
        int rc = this.winTaskResultDao.ctx().delete((Table)tr).where(DSL.or(cond)).execute();
        log.info("clean task result, count={}", (Object)rc);
        return rc;
    }

    @Override
    @TinyTasker(value="TinyTaskCheckHealth")
    public String checkHealth() {
        long now = ThreadNow.millis();
        WinTaskDefineTable td = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        List tks = this.winTaskDefineDao.ctx().select(td.Id, td.TaskerName, td.LastExec, td.TimingBeat, td.TimingRate, td.TimingIdle).from((TableLike)td).where(td.Enabled.eq((Object)Boolean.TRUE)).fetch().into(WinTaskDefine.class);
        StringBuilder mis = new StringBuilder();
        for (WinTaskDefine r : tks) {
            log.debug("check health task id={}, name={}", (Object)r.getId(), (Object)r.getTaskerName());
            int beat = r.getTimingBeat();
            if (beat <= 0) {
                beat = Math.max(r.getTimingRate(), r.getTimingIdle());
            }
            if (beat <= 0) continue;
            long last = DateLocaling.sysEpoch((LocalDateTime)r.getLastExec());
            if (!this.warmed || last + 1000L * (long)beat * (long)this.beatTimes >= now) continue;
            log.info("misfired task id={}, name={}", (Object)r.getId(), (Object)r.getTaskerName());
            mis.append(r.getId()).append('@').append(r.getTaskerName()).append('\n');
        }
        this.warmed = true;
        return mis.isEmpty() ? null : "misfired task id@name\n" + String.valueOf(mis);
    }

    @Autowired
    @Generated
    public void setWinTaskDefineDao(WinTaskDefineDao winTaskDefineDao) {
        this.winTaskDefineDao = winTaskDefineDao;
    }

    @Autowired
    @Generated
    public void setWinTaskResultDao(WinTaskResultDao winTaskResultDao) {
        this.winTaskResultDao = winTaskResultDao;
    }

    @Generated
    public void setBeatTimes(int beatTimes) {
        this.beatTimes = beatTimes;
    }

    @Generated
    public int getBeatTimes() {
        return this.beatTimes;
    }
}

