/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service.impl;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jooq.OrderField;
import org.jooq.Record16;
import org.jooq.RecordMapper;
import org.jooq.TableLike;
import org.jooq.impl.DAOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pro.fessional.mirana.page.PageQuery;
import pro.fessional.mirana.page.PageResult;
import pro.fessional.mirana.time.DateFormatter;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.database.jooq.helper.PageJooqHelper;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskDefineTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskResultTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskDefineDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskResultDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskResult;
import pro.fessional.wings.tiny.task.service.TinyTaskExecService;
import pro.fessional.wings.tiny.task.service.TinyTaskListService;

@Service
@ConditionalWingsEnabled
public class TinyTaskListServiceImpl
implements TinyTaskListService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyTaskListServiceImpl.class);
    protected TinyTaskExecService tinyTaskExecService;
    protected WinTaskDefineDao winTaskDefineDao;
    protected WinTaskResultDao winTaskResultDao;

    @Override
    @NotNull
    public PageResult<TinyTaskListService.Item> listRunning(PageQuery pq) {
        Set<Long> ids = this.tinyTaskExecService.running();
        WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winTaskDefineDao, (PageQuery)pq).count().from(new TableLike[]{t}).where(t.Id.in(ids)).order(Map.of("done", t.LastDone, "exec", t.LastExec), new OrderField[]{t.LastDone.desc()}).fetch(t.Id, t.Enabled, t.Autorun, t.Version, t.TaskerName, t.TaskerApps, t.TaskerRuns, t.TimingCron, t.TimingIdle, t.TimingRate, t.LastExec, t.LastFail, t.LastDone, t.SumExec, t.SumFail, t.SumDone).into(this.r16Item(t));
    }

    @Override
    @NotNull
    public PageResult<TinyTaskListService.Item> listDefined(PageQuery pq) {
        WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winTaskDefineDao, (PageQuery)pq).count().from(new TableLike[]{t}).whereTrue().order(Map.of("done", t.LastDone, "exec", t.LastExec), new OrderField[]{t.LastDone.desc()}).fetch(t.Id, t.Enabled, t.Autorun, t.Version, t.TaskerName, t.TaskerApps, t.TaskerRuns, t.TimingCron, t.TimingIdle, t.TimingRate, t.LastExec, t.LastFail, t.LastDone, t.SumExec, t.SumFail, t.SumDone).into(this.r16Item(t));
    }

    @NotNull
    private RecordMapper<Record16<Long, Boolean, Boolean, Integer, String, String, String, String, Integer, Integer, LocalDateTime, LocalDateTime, LocalDateTime, Integer, Integer, Integer>, TinyTaskListService.Item> r16Item(WinTaskDefineTable t) {
        return it -> {
            TinyTaskListService.Item tm = new TinyTaskListService.Item();
            tm.setId((Long)it.get(t.Id));
            tm.setEnabled((Boolean)it.get(t.Enabled));
            tm.setAutorun((Boolean)it.get(t.Enabled));
            tm.setVersion((Integer)it.get(t.Version));
            tm.setTaskerName((String)it.get(t.TaskerName));
            tm.setTaskerApps((String)it.get(t.TaskerApps));
            tm.setTaskerRuns((String)it.get(t.TaskerRuns));
            tm.setTimingCron((String)it.get(t.TimingCron));
            tm.setTimingIdle((Integer)it.get(t.TimingIdle));
            tm.setTimingRate((Integer)it.get(t.TimingRate));
            tm.setSumExec((Integer)it.get(t.SumExec));
            tm.setSumFail((Integer)it.get(t.SumFail));
            tm.setSumDone((Integer)it.get(t.SumDone));
            ZonedDateTime lastExec = ((LocalDateTime)it.get(t.LastExec)).atZone(ThreadNow.sysZoneId());
            tm.setLastExec(DateFormatter.fullTz((ZonedDateTime)lastExec));
            ZonedDateTime lastFail = ((LocalDateTime)it.get(t.LastFail)).atZone(ThreadNow.sysZoneId());
            tm.setLastFail(DateFormatter.fullTz((ZonedDateTime)lastFail));
            ZonedDateTime lastDone = ((LocalDateTime)it.get(t.LastDone)).atZone(ThreadNow.sysZoneId());
            tm.setLastDone(DateFormatter.fullTz((ZonedDateTime)lastDone));
            return tm;
        };
    }

    @Override
    @NotNull
    public PageResult<WinTaskResult> listResult(long id, PageQuery pq) {
        WinTaskResultTable t = (WinTaskResultTable)this.winTaskResultDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winTaskResultDao, (PageQuery)pq).count().from(new TableLike[]{t}).where(t.TaskId.eq((Object)id)).order(Map.of("id", t.Id), new OrderField[]{t.Id.desc()}).fetch().into(WinTaskResult.class);
    }

    @Autowired
    @Generated
    public void setTinyTaskExecService(TinyTaskExecService tinyTaskExecService) {
        this.tinyTaskExecService = tinyTaskExecService;
    }

    @Autowired
    @Generated
    public void setWinTaskDefineDao(WinTaskDefineDao winTaskDefineDao) {
        this.winTaskDefineDao = winTaskDefineDao;
    }

    @Autowired
    @Generated
    public void setWinTaskResultDao(WinTaskResultDao winTaskResultDao) {
        this.winTaskResultDao = winTaskResultDao;
    }
}

