/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.spring.bean;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.wings.silencer.runner.ApplicationReadyEventRunner;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.task.controller.TaskConfController;
import pro.fessional.wings.tiny.task.database.TinyTaskDatabase;
import pro.fessional.wings.tiny.task.schedule.TinyTasker;
import pro.fessional.wings.tiny.task.service.TinyTaskService;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class TinyTaskConfiguration {
    private static final Log log = LogFactory.getLog(TinyTaskConfiguration.class);

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.tiny.task.autorun")
    public ApplicationReadyEventRunner tinyTaskerAutoRunner(@NotNull ApplicationContext context, ObjectProvider<TinyTaskService> tinyTaskService) {
        log.info((Object)"TinyTask spring-runs tinyTaskerAutoRunner");
        return new ApplicationReadyEventRunner(-50000000, ignored -> {
            TinyTaskService service = (TinyTaskService)tinyTaskService.getIfAvailable();
            if (service == null) {
                log.warn((Object)"tinyTaskService is null, skip TinyTasker.Auto config ");
                return;
            }
            Map beans = context.getBeansWithAnnotation(TinyTasker.Auto.class);
            for (Map.Entry en : beans.entrySet()) {
                log.info((Object)("TinyTask spring-conf TinyTaskerAuto, name=" + (String)en.getKey()));
                service.schedule(en.getValue());
            }
        });
    }

    @Configuration(proxyBeanMethods=false)
    @ComponentScan(basePackageClasses={TaskConfController.class})
    @ConditionalOnClass(value={RestController.class})
    public static class MvcRestScan {
        public MvcRestScan() {
            log.info((Object)"TinyTask spring-scan controller");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    @ComponentScan(basePackageClasses={TinyTaskDatabase.class, TinyTaskService.class})
    public static class DaoServScan {
        public DaoServScan() {
            log.info((Object)"TinyTask spring-scan database, service");
        }
    }
}

