/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.schedule.exec;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.wings.tiny.task.schedule.exec.NoticeExec;
import pro.fessional.wings.tiny.task.schedule.exec.TaskerExec;

public class ExecHolder {
    private static final ConcurrentHashMap<String, NoticeExec<?>> Notice = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, TaskerExec> Tasker = new ConcurrentHashMap();

    @NotNull
    public static NoticeExec<?> getNotice(@NotNull String bean, @NotNull Function<String, NoticeExec<?>> exec) {
        return Notice.computeIfAbsent(bean, exec);
    }

    @Contract(value="_,true->!null")
    public static NoticeExec<?> getNotice(@Nullable String bean, boolean nonnull) {
        NoticeExec<?> exec;
        NoticeExec<?> noticeExec = exec = StringUtils.isEmpty((CharSequence)bean) ? null : Notice.get(bean);
        if (nonnull && exec == null) {
            throw new IllegalStateException("notice not found, bean=" + bean);
        }
        return exec;
    }

    @Nullable
    public static NoticeExec<?> delNotice(@NotNull String bean) {
        return Notice.remove(bean);
    }

    @NotNull
    public static TaskerExec getTasker(@NotNull String prop, @NotNull Function<String, TaskerExec> exec) {
        return Tasker.computeIfAbsent(prop, exec);
    }

    @Contract(value="_,true->!null")
    public static TaskerExec getTasker(@Nullable String prop, boolean nonnull) {
        TaskerExec exec;
        TaskerExec taskerExec = exec = StringUtils.isEmpty((CharSequence)prop) ? null : Tasker.get(prop);
        if (nonnull && exec == null) {
            throw new IllegalStateException("tasker not found, prop=" + prop);
        }
        return exec;
    }

    @Nullable
    public static TaskerExec delTasker(@NotNull String prop) {
        return Tasker.remove(prop);
    }
}

