/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service.impl;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.support.CronExpression;
import pro.fessional.mirana.time.DateLocaling;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.convention.EmptySugar;
import pro.fessional.wings.silencer.modulate.RuntimeMode;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskDefineTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskResultTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskDefineDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskResultDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskDefine;
import pro.fessional.wings.tiny.task.schedule.TinyTasker;
import pro.fessional.wings.tiny.task.service.TinyTaskBeatService;

@ConditionalWingsEnabled
@TinyTasker.Auto
public class TinyTaskBeatServiceImpl
implements TinyTaskBeatService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyTaskBeatServiceImpl.class);
    protected WinTaskDefineDao winTaskDefineDao;
    protected WinTaskResultDao winTaskResultDao;
    protected int beatTimes = 2;
    private volatile boolean warmed = false;
    private final HashMap<Long, LocalDateTime> nonLastExec = new HashMap();

    @Override
    @TinyTasker(value="TinyTaskCleanResult")
    public int cleanResult() {
        WinTaskResultTable tr = (WinTaskResultTable)this.winTaskResultDao.getTable();
        List tid = this.winTaskResultDao.ctx().selectDistinct(tr.TaskId).from((TableLike)tr).fetchInto(Long.class);
        if (tid.isEmpty()) {
            log.debug("no tiny-task result to clean");
            return 0;
        }
        WinTaskDefineTable td = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        Result hst = this.winTaskDefineDao.ctx().select(td.Id, td.ResultKeep).from((TableLike)td).where(td.Id.in((Collection)tid)).fetch();
        LocalDateTime now = ThreadNow.localDate().atStartOfDay();
        List cond = hst.stream().map(it -> tr.TaskId.eq((Object)((Long)it.value1())).and(tr.TimeExec.le((Object)now.minusDays(((Integer)it.value2()).intValue())))).collect(Collectors.toList());
        if (cond.isEmpty()) {
            log.debug("no tiny-task condition to clean");
            return 0;
        }
        int rc = this.winTaskResultDao.ctx().delete((Table)tr).where(DSL.or(cond)).execute();
        log.info("clean tiny-task result, count={}", (Object)rc);
        return rc;
    }

    @Override
    @TinyTasker(value="TinyTaskCheckHealth")
    public String checkHealth() {
        long now = ThreadNow.millis();
        WinTaskDefineTable td = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        List tks = this.winTaskDefineDao.ctx().select(td.Id, td.TaskerName, td.LastExec, td.TaskerRuns, td.TimingBeat, td.TimingRate, td.TimingIdle, td.TimingTune, td.TimingCron, td.TimingZone).from((TableLike)td).where(td.Enabled.eq((Object)Boolean.TRUE)).fetch().into(WinTaskDefine.class);
        StringBuilder mis = this.warmed ? new StringBuilder() : null;
        for (WinTaskDefine r : tks) {
            long beat;
            log.debug("check health tiny-task id={}, name={}", (Object)r.getId(), (Object)r.getTaskerName());
            String runs = r.getTaskerRuns();
            if (StringUtils.isNotBlank((CharSequence)runs) && !RuntimeMode.voteRunMode((String)runs) || (beat = this.calcBeatMills(r, now)) <= 0L || beat >= now) continue;
            log.info("misfired tiny-task id={}, name={}", (Object)r.getId(), (Object)r.getTaskerName());
            if (mis == null) continue;
            mis.append(r.getId()).append('@').append(r.getTaskerName()).append('\n');
        }
        this.warmed = true;
        return mis == null || mis.isEmpty() ? null : "misfired tiny-task id@name\n" + String.valueOf(mis) + "\nUPDATE win_task_define SET timing_beat = -UNIX_TIMESTAMP(now() + INTERVAL 1 hour ) WHERE id IN (...); to skip checking for 1 hour";
    }

    protected long calcBeatMills(WinTaskDefine td, long now) {
        ZonedDateTime nxt;
        long beat;
        LocalDateTime lastExec = td.getLastExec();
        if (EmptySugar.asEmptyValue((LocalDateTime)lastExec)) {
            lastExec = this.nonLastExec.computeIfAbsent(td.getId(), ignore -> DateLocaling.sysLdt((long)now));
        }
        if ((beat = td.getTimingBeat().longValue()) < 0L && now + beat * 1000L < 0L) {
            return beat;
        }
        long lastExecSys = DateLocaling.sysEpoch((LocalDateTime)lastExec);
        if (beat > 0L) {
            return lastExecSys + beat * 1000L;
        }
        String cron = td.getTimingCron();
        if (StringUtils.isEmpty((CharSequence)cron)) {
            int max = Math.max(td.getTimingRate(), td.getTimingIdle());
            return lastExecSys + (long)max * 1000L * (long)this.beatTimes;
        }
        String zid = td.getTimingZone();
        ZoneId zone = StringUtils.isEmpty((CharSequence)zid) ? ThreadNow.sysZoneId() : ZoneId.of(zid);
        ZonedDateTime beatZdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(lastExecSys), zone);
        CronExpression cronExpr = CronExpression.parse((String)cron);
        for (int i = 0; i < this.beatTimes && (nxt = (ZonedDateTime)cronExpr.next((Temporal)beatZdt)) != null; ++i) {
            beatZdt = nxt;
        }
        return beatZdt.toInstant().toEpochMilli();
    }

    @Autowired
    @Generated
    public void setWinTaskDefineDao(WinTaskDefineDao winTaskDefineDao) {
        this.winTaskDefineDao = winTaskDefineDao;
    }

    @Autowired
    @Generated
    public void setWinTaskResultDao(WinTaskResultDao winTaskResultDao) {
        this.winTaskResultDao = winTaskResultDao;
    }

    @Generated
    public void setBeatTimes(int beatTimes) {
        this.beatTimes = beatTimes;
    }

    @Generated
    public int getBeatTimes() {
        return this.beatTimes;
    }
}

