/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Record2;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.data.Diff;
import pro.fessional.wings.faceless.service.journal.JournalAware;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.silencer.modulate.RunMode;
import pro.fessional.wings.silencer.modulate.RuntimeMode;
import pro.fessional.wings.silencer.notice.SmallNotice;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.support.PropHelper;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskDefineTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskDefineDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskDefine;
import pro.fessional.wings.tiny.task.schedule.TinyTasker;
import pro.fessional.wings.tiny.task.schedule.conf.TaskerProp;
import pro.fessional.wings.tiny.task.schedule.exec.ExecHolder;
import pro.fessional.wings.tiny.task.schedule.exec.NoticeExec;
import pro.fessional.wings.tiny.task.schedule.exec.TaskerExec;
import pro.fessional.wings.tiny.task.schedule.help.TaskerHelper;
import pro.fessional.wings.tiny.task.service.TinyTaskConfService;
import pro.fessional.wings.tiny.task.spring.prop.TinyTaskDefineProp;

@Service
@ConditionalWingsEnabled
public class TinyTaskConfServiceImpl
implements TinyTaskConfService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyTaskConfServiceImpl.class);
    protected String appName;
    protected ApplicationContext applicationContext;
    protected TinyTaskDefineProp tinyTaskDefineProp;
    protected WinTaskDefineDao winTaskDefineDao;
    protected LightIdService lightIdService;
    protected JournalService journalService;

    @Override
    @Transactional
    public TinyTaskConfService.Conf config(@NotNull Object bean, @NotNull Method method, @Nullable Object para) {
        return this.config(AopUtils.getTargetClass((Object)bean), bean, method, para);
    }

    @Override
    @Transactional
    @NotNull
    public Set<TinyTaskConfService.Conf> config(@NotNull Object bean) {
        Class claz = AopUtils.getTargetClass((Object)bean);
        Map map = MethodIntrospector.selectMethods((Class)claz, method -> (TinyTasker)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, TinyTasker.class));
        if (map.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TinyTaskConfService.Conf> result = new HashSet<TinyTaskConfService.Conf>();
        for (Method method2 : map.keySet()) {
            TinyTaskConfService.Conf cnf = this.config(claz, bean, method2, null);
            result.add(cnf);
        }
        return result;
    }

    @NotNull
    private TaskerProp property(@NotNull String key, @NotNull TinyTasker anno) {
        TaskerProp pp = (TaskerProp)this.tinyTaskDefineProp.get(key);
        TaskerProp df = this.tinyTaskDefineProp.getDefault();
        TaskerProp rp = new TaskerProp();
        if (pp == null) {
            rp.setTimingZone(anno.zone());
            rp.setTimingCron(anno.cron());
            rp.setTimingIdle(anno.idle());
            rp.setTimingRate(anno.rate());
            rp.setTimingTune(anno.tune());
            rp.setTimingMiss(anno.miss());
            log.debug("no prop, use annotation, key={}", (Object)key);
        } else {
            rp.setTimingZone(pp.notTimingZone() ? anno.zone() : pp.getTimingZone());
            rp.setTimingCron(pp.notTimingCron() ? anno.cron() : pp.getTimingCron());
            rp.setTimingIdle(pp.notTimingIdle() ? anno.idle() : pp.getTimingIdle());
            rp.setTimingRate(pp.notTimingRate() ? anno.rate() : pp.getTimingRate());
            rp.setTimingTune(pp.notTimingTune() ? anno.tune() : pp.getTimingTune());
            rp.setTimingMiss(pp.notTimingMiss() ? (long)anno.miss() : pp.getTimingMiss());
        }
        if (pp != null) {
            rp.setEnabled(pp.isEnabled());
            rp.setAutorun(pp.isAutorun());
            rp.setVersion(pp.getVersion());
            rp.setTaskerBean(pp.getTaskerBean());
            rp.setTaskerPara(pp.getTaskerPara());
            rp.setTaskerName(pp.getTaskerName());
            rp.setTaskerFast(pp.isTaskerFast());
            rp.setTimingBeat(pp.getTimingBeat());
            rp.setDuringFrom(pp.getDuringFrom());
            rp.setDuringStop(pp.getDuringStop());
            rp.setDuringExec(pp.getDuringExec());
            rp.setDuringFail(pp.getDuringFail());
            rp.setDuringDone(pp.getDuringDone());
            rp.setDuringBoot(pp.getDuringBoot());
        }
        rp.setTaskerApps(pp == null || pp.notTaskerApps() ? df.getTaskerApps() : pp.getTaskerApps());
        rp.setTaskerRuns(pp == null || pp.notTaskerRuns() ? df.getTaskerRuns() : pp.getTaskerRuns());
        rp.setNoticeBean(pp == null || pp.notNoticeBean() ? df.getNoticeBean() : pp.getNoticeBean());
        rp.setNoticeWhen(pp == null || pp.notNoticeWhen() ? df.getNoticeWhen() : pp.getNoticeWhen());
        rp.setNoticeConf(pp == null || pp.notNoticeConf() ? df.getNoticeConf() : pp.getNoticeConf());
        rp.setTimingZone(pp == null || pp.notTimingZone() ? df.getTimingZone() : pp.getTimingZone());
        rp.setTimingType(pp == null || pp.notTimingType() ? df.getTimingType() : pp.getTimingType());
        rp.setResultKeep(pp == null || pp.notResultKeep() ? df.getResultKeep() : pp.getResultKeep());
        return rp;
    }

    @Override
    @Contract(value="_,true->!null")
    public TaskerProp database(long id, boolean nonnull) {
        TaskerProp conf = this.fetchProp(TaskerProp.class, t -> t.Id.eq((Object)id));
        if (conf == null && nonnull) {
            throw new IllegalArgumentException("database tiny-task is null, id=" + id);
        }
        return conf;
    }

    @Override
    @Contract(value="_,true->!null")
    public TaskerProp property(long id, boolean nonnull) {
        WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        Record2 r2 = (Record2)this.winTaskDefineDao.ctx().select(t.Propkey, t.TaskerBean).from((TableLike)t).where(t.Id.eq((Object)id)).fetchOne();
        if (r2 == null || StringUtils.isEmpty((CharSequence)((CharSequence)r2.value1())) || StringUtils.isEmpty((CharSequence)((CharSequence)r2.value2()))) {
            if (nonnull) {
                throw new IllegalArgumentException("database tiny-task is null, id=" + id);
            }
            return null;
        }
        TinyTasker anno = this.referAnno((String)r2.value1(), (String)r2.value2());
        AssertArgs.notNull((Object)anno, (String)"database without TinyTasker, id={}", (Object[])new Object[]{id});
        return this.property((String)r2.value1(), anno);
    }

    @Override
    @NotNull
    public LinkedHashMap<String, Diff.V<?>> diffProp(long id) {
        WinTaskDefine po = this.fetchProp(WinTaskDefine.class, t -> t.Id.eq((Object)id));
        AssertArgs.notNull((Object)po, (String)"database tiny-task is null, id={}", (Object[])new Object[]{id});
        TinyTasker anno = this.referAnno(po.getPropkey(), po.getTaskerBean());
        AssertArgs.notNull((Object)anno, (String)"database without tiny-task, id={}", (Object[])new Object[]{id});
        TaskerProp prop = this.property(po.getPropkey(), anno);
        return this.diff(po, prop);
    }

    private TinyTasker referAnno(String key, String entry) {
        TaskerExec tk = ExecHolder.getTasker(key, false);
        Method md = tk != null ? tk.getBeanMethod() : TaskerHelper.referMethod(entry);
        return md.getAnnotation(TinyTasker.class);
    }

    @Override
    @Transactional
    public boolean enable(long id, boolean enabled) {
        return (Boolean)this.journalService.submit((Enum)Jane.Enable, journal -> {
            WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
            int rc = this.winTaskDefineDao.ctx().update((Table)t).set(t.Enabled, (Object)enabled).set(t.CommitId, (Object)journal.getCommitId()).set(t.ModifyDt, (Object)journal.getCommitDt()).where(t.Id.eq((Object)id)).execute();
            return rc > 0;
        });
    }

    @Override
    @Transactional
    public boolean replace(long id, TaskerProp prop) {
        return this.updateProp(prop, null, id);
    }

    private TinyTaskConfService.Conf config(@NotNull Class<?> claz, @NotNull Object bean, @NotNull Method method, @Nullable Object para) {
        String noticeBean;
        boolean matched;
        boolean autorun;
        boolean enabled;
        long id;
        TaskerExec tasker;
        TinyTasker anno = method.getAnnotation(TinyTasker.class);
        if (anno == null) {
            throw new IllegalStateException("need @TinyTasker, tiny-task method=" + method.getName() + ", class=" + claz.getName());
        }
        String entry = TaskerHelper.tokenize(claz, method.getName());
        String key = StringUtils.isEmpty((CharSequence)anno.value()) ? entry : anno.value();
        TaskerProp prop = this.property(key, anno);
        if (prop.notTimingCron() && prop.notTimingIdle() && prop.notTimingRate()) {
            throw new IllegalStateException("need cron/idle/rate ,method=" + method.getName() + ", class=" + claz.getName() + ", prop=" + key);
        }
        log.info("find tiny-task, prop={}, entry={}", (Object)key, (Object)entry);
        if (StringUtils.isEmpty((CharSequence)prop.getTaskerName())) {
            prop.setTaskerName(claz.getSimpleName() + "#" + method.getName());
        }
        if (!method.equals((tasker = ExecHolder.getTasker(key, k -> new TaskerExec(claz, bean, method))).getBeanMethod())) {
            throw new IllegalStateException("diff method with same prop=" + key + ", entry1=" + claz.getName() + "#" + method.getName() + ", entry2=" + tasker.getBeanClass().getName() + "#" + tasker.getBeanMethod().getName());
        }
        prop.setTaskerBean(entry);
        prop.setTaskerPara(tasker.encodePara(para));
        WinTaskDefine po = this.fetchProp(WinTaskDefine.class, t -> t.TaskerBean.eq((Object)entry));
        if (po == null) {
            id = this.insertProp(prop, key);
            enabled = prop.isEnabled();
            autorun = prop.isAutorun();
            matched = true;
            noticeBean = prop.getNoticeBean();
            log.info("insert prop to database, version={}, id={}", (Object)prop.getVersion(), (Object)id);
        } else {
            id = po.getId();
            enabled = BoxedCastUtil.orTrue((Boolean)po.getEnabled());
            autorun = BoxedCastUtil.orTrue((Boolean)po.getAutorun());
            matched = this.hasApps(po.getTaskerApps()) && this.hasRuns(po.getTaskerRuns());
            noticeBean = po.getNoticeBean();
            log.debug("find database config, version={}, id={}, matched={}", new Object[]{prop.getVersion(), id, matched});
            LinkedHashMap<String, Diff.V<?>> df = this.diff(po, prop);
            if (!df.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append('\n');
                for (Map.Entry<String, Diff.V<?>> en : df.entrySet()) {
                    sb.append(en.getKey()).append(':');
                    sb.append("db=").append(en.getValue().getV1());
                    sb.append(", pp=").append(en.getValue().getV2());
                    sb.append('\n');
                }
                if (matched && po.getVersion() <= prop.getVersion()) {
                    this.updateProp(prop, key, id);
                    log.warn("update prop to database(low-ver), prop={}, diff={}", (Object)key, (Object)sb);
                } else if (matched) {
                    log.warn("diff from prop(low-ver) and database, prop={}, diff={}", (Object)key, (Object)sb);
                } else {
                    log.info("diff from prop and database but not matched, prop={}, diff={}", (Object)key, (Object)sb);
                }
            }
        }
        WinTaskDefine poKey = this.fetchProp(WinTaskDefine.class, t -> t.Propkey.eq((Object)key));
        if (poKey != null && !entry.equals(poKey.getTaskerBean())) {
            throw new IllegalStateException("diff TaskerBean with same prop=" + key + ", entry1=" + entry + ", entry2=" + poKey.getTaskerBean());
        }
        if (StringUtils.isNotEmpty((CharSequence)noticeBean)) {
            ExecHolder.getNotice(noticeBean, k -> {
                try {
                    Class cz = ClassUtils.forName((String)noticeBean, null);
                    SmallNotice nb = (SmallNotice)this.applicationContext.getBean(cz);
                    return new NoticeExec(nb);
                }
                catch (ClassNotFoundException e) {
                    log.error("failed to init notice bean=" + noticeBean, (Throwable)e);
                    throw new IllegalArgumentException(e);
                }
            });
        }
        return new TinyTaskConfService.Conf(id, key, enabled, autorun, matched);
    }

    private boolean hasApps(String apps) {
        if (StringUtils.isEmpty((CharSequence)apps)) {
            return true;
        }
        for (String s : PropHelper.commaArray((String)apps)) {
            if (!s.trim().equals(this.appName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasRuns(String runs) {
        if (StringUtils.isEmpty((CharSequence)runs)) {
            return true;
        }
        return !RuntimeMode.isRunMode((RunMode)RunMode.Nothing) && RuntimeMode.voteRunMode((String)runs);
    }

    private long insertProp(TaskerProp prop, String key) {
        return (Long)this.journalService.submit((Enum)Jane.Insert, journal -> {
            WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
            long id = this.lightIdService.getId((LightIdAware)t);
            WinTaskDefine po = this.genWinTaskDefine(prop, key, this.appName);
            po.setId(id);
            po.setNextLock(0);
            journal.create((JournalAware)po);
            this.winTaskDefineDao.insert(po);
            return id;
        });
    }

    private boolean updateProp(TaskerProp prop, String key, long id) {
        return (Boolean)this.journalService.submit((Enum)Jane.Update, journal -> {
            WinTaskDefine po = this.genWinTaskDefine(prop, key, null);
            po.setId(id);
            journal.modify((JournalAware)po);
            int rc = this.winTaskDefineDao.update(po, true);
            return rc > 0;
        });
    }

    @NotNull
    private WinTaskDefine genWinTaskDefine(TaskerProp prop, String key, String apps) {
        WinTaskDefine wtd = new WinTaskDefine();
        wtd.setEnabled(prop.isEnabled());
        wtd.setAutorun(prop.isAutorun());
        wtd.setVersion(prop.getVersion());
        wtd.setPropkey(key);
        wtd.setTaskerBean(prop.getTaskerBean());
        wtd.setTaskerPara(prop.getTaskerPara());
        wtd.setTaskerName(prop.getTaskerName());
        wtd.setTaskerFast(prop.isTaskerFast());
        String ta = prop.getTaskerApps();
        wtd.setTaskerApps(StringUtils.isEmpty((CharSequence)ta) ? apps : ta);
        wtd.setTaskerRuns(prop.getTaskerRuns());
        wtd.setNoticeBean(prop.getNoticeBean());
        wtd.setNoticeWhen(prop.getNoticeWhen());
        wtd.setNoticeConf(prop.getNoticeConf());
        wtd.setTimingZone(prop.getTimingZone());
        wtd.setTimingType(prop.getTimingType());
        wtd.setTimingCron(prop.getTimingCron());
        wtd.setTimingIdle(prop.getTimingIdle());
        wtd.setTimingRate(prop.getTimingRate());
        wtd.setTimingTune(prop.getTimingTune());
        wtd.setTimingMiss(prop.getTimingMiss());
        wtd.setTimingBeat(prop.getTimingBeat());
        wtd.setDuringFrom(prop.getDuringFrom());
        wtd.setDuringStop(prop.getDuringStop());
        wtd.setDuringExec(prop.getDuringExec());
        wtd.setDuringFail(prop.getDuringFail());
        wtd.setDuringDone(prop.getDuringDone());
        wtd.setDuringBoot(prop.getDuringBoot());
        wtd.setResultKeep(prop.getResultKeep());
        return wtd;
    }

    private <T> T fetchProp(Class<T> claz, Function<WinTaskDefineTable, Condition> cond) {
        WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        return (T)this.winTaskDefineDao.ctx().select(new SelectFieldOrAsterisk[]{t.Id, t.Propkey, t.Enabled, t.Autorun, t.Version, t.TaskerBean, t.TaskerPara, t.TaskerName, t.TaskerFast, t.TaskerApps, t.TaskerRuns, t.NoticeBean, t.NoticeWhen, t.NoticeConf, t.TimingZone, t.TimingType, t.TimingCron, t.TimingIdle, t.TimingRate, t.TimingTune, t.TimingMiss, t.TimingBeat, t.DuringFrom, t.DuringStop, t.DuringExec, t.DuringFail, t.DuringDone, t.DuringBoot, t.ResultKeep}).from((TableLike)t).where(cond.apply(t)).fetchOneInto(claz);
    }

    private LinkedHashMap<String, Diff.V<?>> diff(WinTaskDefine v1, TaskerProp v2) {
        LinkedHashMap result = new LinkedHashMap();
        this.diff(result, "enabled", v1.getEnabled(), v2.isEnabled());
        this.diff(result, "autorun", v1.getAutorun(), v2.isAutorun());
        this.diff(result, "version", v1.getVersion(), v2.getVersion());
        this.diff(result, "taskerBean", v1.getTaskerBean(), v2.getTaskerBean());
        this.diff(result, "taskerPara", v1.getTaskerPara(), v2.getTaskerPara());
        this.diff(result, "taskerName", v1.getTaskerName(), v2.getTaskerName());
        this.diff(result, "taskerFast", v1.getTaskerFast(), v2.isTaskerFast());
        this.diff(result, "taskerApps", v1.getTaskerApps(), v2.getTaskerApps());
        this.diff(result, "taskerRuns", v1.getTaskerRuns(), v2.getTaskerRuns());
        this.diff(result, "noticeBean", v1.getNoticeBean(), v2.getNoticeBean());
        this.diff(result, "noticeWhen", v1.getNoticeWhen(), v2.getNoticeWhen());
        this.diff(result, "noticeConf", v1.getNoticeConf(), v2.getNoticeConf());
        this.diff(result, "timingZone", v1.getTimingZone(), v2.getTimingZone());
        this.diff(result, "timingType", v1.getTimingType(), v2.getTimingType());
        this.diff(result, "timingCron", v1.getTimingCron(), v2.getTimingCron());
        this.diff(result, "timingIdle", v1.getTimingIdle(), v2.getTimingIdle());
        this.diff(result, "timingRate", v1.getTimingRate(), v2.getTimingRate());
        this.diff(result, "timingTune", v1.getTimingTune(), v2.getTimingTune());
        this.diff(result, "timingMiss", v1.getTimingMiss(), v2.getTimingMiss());
        this.diff(result, "timingBeat", v1.getTimingBeat(), v2.getTimingBeat());
        this.diff(result, "duringFrom", v1.getDuringFrom(), v2.getDuringFrom());
        this.diff(result, "duringStop", v1.getDuringStop(), v2.getDuringStop());
        this.diff(result, "duringExec", v1.getDuringExec(), v2.getDuringExec());
        this.diff(result, "duringFail", v1.getDuringFail(), v2.getDuringFail());
        this.diff(result, "duringDone", v1.getDuringDone(), v2.getDuringDone());
        this.diff(result, "duringBoot", v1.getDuringBoot(), v2.getDuringBoot());
        this.diff(result, "resultKeep", v1.getResultKeep(), v2.getResultKeep());
        return result;
    }

    public <K, T> void diff(Map<K, Diff.V<?>> map, K key, T t1, T t2) {
        if (!Objects.equals(t1, t2)) {
            map.put(key, Diff.v(t1, t2));
        }
    }

    @Value(value="${spring.application.name}")
    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Autowired
    @Generated
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Autowired
    @Generated
    public void setTinyTaskDefineProp(TinyTaskDefineProp tinyTaskDefineProp) {
        this.tinyTaskDefineProp = tinyTaskDefineProp;
    }

    @Autowired
    @Generated
    public void setWinTaskDefineDao(WinTaskDefineDao winTaskDefineDao) {
        this.winTaskDefineDao = winTaskDefineDao;
    }

    @Autowired
    @Generated
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }

    @Autowired
    @Generated
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    public static enum Jane {
        Insert,
        Update,
        Enable;

    }
}

