/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.scheduling.support.SimpleTriggerContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.data.U;
import pro.fessional.mirana.lock.JvmStaticGlobalLock;
import pro.fessional.mirana.pain.ThrowableUtil;
import pro.fessional.mirana.stat.JvmStat;
import pro.fessional.mirana.time.DateLocaling;
import pro.fessional.mirana.time.DateParser;
import pro.fessional.mirana.time.Sleep;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.convention.EmptySugar;
import pro.fessional.wings.faceless.convention.EmptyValue;
import pro.fessional.wings.faceless.database.helper.TransactionHelper;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.silencer.modulate.RunMode;
import pro.fessional.wings.silencer.modulate.RuntimeMode;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.support.PropHelper;
import pro.fessional.wings.slardar.async.TaskSchedulerHelper;
import pro.fessional.wings.slardar.jackson.JacksonHelper;
import pro.fessional.wings.tiny.task.database.autogen.tables.WinTaskDefineTable;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskDefineDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.daos.WinTaskResultDao;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskDefine;
import pro.fessional.wings.tiny.task.database.autogen.tables.pojos.WinTaskResult;
import pro.fessional.wings.tiny.task.schedule.exec.ExecHolder;
import pro.fessional.wings.tiny.task.schedule.exec.NoticeExec;
import pro.fessional.wings.tiny.task.schedule.exec.TaskerExec;
import pro.fessional.wings.tiny.task.service.TinyTaskExecService;
import pro.fessional.wings.tiny.task.spring.prop.TinyTaskExecProp;

@Service
@ConditionalWingsEnabled
public class TinyTaskExecServiceImpl
implements TinyTaskExecService,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyTaskExecServiceImpl.class);
    protected static final ConcurrentHashMap<Long, U.Three<ScheduledFuture<?>, Long, String>> Handle = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<Long, Boolean> Cancel = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<Long, Integer> Booted = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<Long, Boolean> Untune = new ConcurrentHashMap();
    private final AtomicInteger noticeCounter = new AtomicInteger(0);
    protected String appName;
    protected WinTaskDefineDao winTaskDefineDao;
    protected WinTaskResultDao winTaskResultDao;
    protected LightIdService lightIdService;
    protected JournalService journalService;
    protected TinyTaskExecProp execProp;
    protected volatile boolean isShutdownFast = false;
    protected volatile boolean isShutdownSlow = false;

    public void afterPropertiesSet() {
        this.isShutdownFast = false;
        this.isShutdownSlow = false;
    }

    @EventListener(value={ContextClosedEvent.class})
    public void destroy() {
        log.info("tiny-task shutdown for ContextClosedEvent");
        this.isShutdownFast = true;
        this.isShutdownSlow = true;
        for (Map.Entry<Long, U.Three<ScheduledFuture<?>, Long, String>> en : Handle.entrySet()) {
            U.Three<ScheduledFuture<?>, Long, String> tvl = en.getValue();
            ScheduledFuture task = (ScheduledFuture)tvl.one();
            log.info("try to cancal tiny-task for shutdown, id={}, key={}, next_sys={}", new Object[]{en.getKey(), tvl.three(), DateLocaling.sysLdt((long)((Long)tvl.two()))});
            task.cancel(false);
        }
        Handle.clear();
    }

    @Override
    public boolean launch(long id) {
        Cancel.remove(id);
        return this.relaunch(id);
    }

    @Override
    public boolean force(long id) {
        if (this.isShutdownFast && this.isShutdownSlow) {
            log.warn("cancel tiny-task for shutdown all on force, id={}", (Object)id);
            return false;
        }
        WinTaskDefine td = this.winTaskDefineDao.fetchOneById(id);
        if (td == null) {
            log.info("skip tiny-task for not found on force, id={}", (Object)id);
            return false;
        }
        boolean fast = BoxedCastUtil.orTrue((Boolean)td.getTaskerFast());
        if (fast && this.isShutdownFast || !fast && this.isShutdownSlow) {
            log.warn("cancal tiny-task for shutdown on force, fast={}, id={}", (Object)fast, (Object)id);
            return false;
        }
        ThreadPoolTaskScheduler scheduler = TaskSchedulerHelper.Scheduler((boolean)fast);
        if (scheduler.getScheduledExecutor().isShutdown()) {
            log.warn("cancal tiny-task for Executor shutdown on force, fast={}, id={}", (Object)fast, (Object)id);
            if (fast) {
                this.isShutdownFast = true;
            } else {
                this.isShutdownSlow = true;
            }
            return false;
        }
        scheduler.schedule(() -> {
            long execTms = ThreadNow.millis();
            long doneTms = -1L;
            long failTms = -1L;
            String taskerInfo = td.getPropkey() + " force";
            String noticeConf = td.getNoticeConf();
            Object taskMsg = "force tiny-task id=" + id;
            NoticeExec<?> notice = null;
            Set<String> ntcWhen = Collections.emptySet();
            try {
                Object result;
                TaskerExec tasker = ExecHolder.getTasker(td.getPropkey(), true);
                notice = ExecHolder.getNotice(td.getNoticeBean(), false);
                if (notice != null) {
                    ntcWhen = this.noticeWhen(td.getNoticeWhen());
                }
                this.postNotice(notice, noticeConf, ntcWhen, taskerInfo, (String)taskMsg, execTms, "exec");
                log.debug("tiny-task force exec, id={}", (Object)id);
                if (this.execProp.isDryrun()) {
                    long slp = Sleep.ignoreInterrupt((long)10L, (long)2000L);
                    result = "dryrun and sleep " + slp;
                    log.info("tiny-task force done, dryrun and sleep {} ms, id={}", (Object)slp, (Object)id);
                } else {
                    result = tasker.invoke(td.getTaskerPara(), true);
                    log.info("tiny-task force done, id={}", (Object)id);
                }
                doneTms = ThreadNow.millis();
                taskMsg = this.stringResult(result);
                this.postNotice(notice, noticeConf, ntcWhen, taskerInfo, (String)taskMsg, doneTms, "feed", "done");
            }
            catch (Exception e) {
                log.error("tiny-task force fail, id=" + id, (Throwable)e);
                failTms = ThreadNow.millis();
                taskMsg = ThrowableUtil.toString((Throwable)e);
                this.postNotice(notice, noticeConf, ntcWhen, taskerInfo, (String)taskMsg, failTms, "fail");
            }
            finally {
                try {
                    this.saveResult(id, td.getPropkey(), execTms, failTms, doneTms, (String)taskMsg, td.getDurFail());
                }
                catch (Exception e) {
                    log.error("failed to save tiny-task result, id=" + id, (Throwable)e);
                }
            }
        }, Instant.ofEpochMilli(ThreadNow.millis()));
        return true;
    }

    @Override
    public boolean cancel(long id) {
        Cancel.put(id, Boolean.TRUE);
        U.Three<ScheduledFuture<?>, Long, String> tvl = Handle.get(id);
        if (tvl == null) {
            log.info("cancel not found, id={}", (Object)id);
            return true;
        }
        boolean r = ((ScheduledFuture)tvl.one()).cancel(false);
        if (r) {
            Handle.remove(id);
        }
        log.info("cancel success, id={}, key={}, next_sys={}", new Object[]{id, tvl.three(), DateLocaling.sysLdt((long)((Long)tvl.two()))});
        return r;
    }

    @Override
    public Set<Long> running() {
        HashSet<Long> set = new HashSet<Long>();
        Enumeration<Long> en = Handle.keys();
        while (en.hasMoreElements()) {
            set.add(en.nextElement());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean relaunch(long id) {
        if (this.isShutdownFast && this.isShutdownSlow) {
            log.warn("cancel tiny-task for shutdown all on relaunch, id={}", (Object)id);
            return false;
        }
        Lock lock = JvmStaticGlobalLock.get((Object[])new Object[]{id});
        try {
            lock.lock();
            if (Handle.containsKey(id)) {
                log.info("skip tiny-task on launching, id={}", (Object)id);
                boolean bl = false;
                return bl;
            }
            WinTaskDefine td = this.winTaskDefineDao.fetchOneById(id);
            if (td == null) {
                log.info("skip tiny-task for not found on relaunch id={}", (Object)id);
                boolean bl = false;
                return bl;
            }
            String key = td.getPropkey();
            if (this.notEnable(td.getEnabled(), id, key) || this.notApps(td.getTaskerApps(), id, key) || this.notRuns(td.getTaskerRuns(), id, key)) {
                boolean bl = false;
                return bl;
            }
            long next = this.calcNextExec(td, ThreadNow.millis());
            if (next < 0L) {
                boolean bl = false;
                return bl;
            }
            this.saveNextExec(next, td);
            boolean fast = BoxedCastUtil.orTrue((Boolean)td.getTaskerFast());
            if (fast && this.isShutdownFast || !fast && this.isShutdownSlow) {
                log.warn("cancal tiny-task for shutdown on relaunch, fast={}, id={}", (Object)fast, (Object)id);
                boolean bl = false;
                return bl;
            }
            ThreadPoolTaskScheduler scheduler = TaskSchedulerHelper.Scheduler((boolean)fast);
            if (scheduler.getScheduledExecutor().isShutdown()) {
                log.warn("cancal tiny-task for Executor shutdown on relaunch, fast={}, id={}, prop={}", new Object[]{fast, id, key});
                if (fast) {
                    this.isShutdownFast = true;
                } else {
                    this.isShutdownSlow = true;
                }
                boolean bl = false;
                return bl;
            }
            log.info("prepare tiny-task id={}, prop={}", (Object)id, (Object)key);
            ScheduledFuture handle = scheduler.schedule(() -> {
                long execTms = ThreadNow.millis();
                try {
                    if (this.notNextLock(td, execTms)) {
                        log.warn("skip tiny-task for Not nextLock, should manually check and launch it, id={}, prop={}", (Object)id, (Object)key);
                        Handle.remove(id);
                        return;
                    }
                }
                catch (Exception e) {
                    log.warn("failed to check nextLock", (Throwable)e);
                    Handle.remove(id);
                    return;
                }
                long doneTms = -1L;
                long failTms = -1L;
                String taskerInfo = key + " launch";
                String noticeConf = td.getNoticeConf();
                Object exitMsg = "relaunch tiny-task key=" + key;
                NoticeExec<?> notice = null;
                Set<String> ntcWhen = Collections.emptySet();
                try {
                    Object result;
                    TaskerExec tasker = ExecHolder.getTasker(key, true);
                    notice = ExecHolder.getNotice(td.getNoticeBean(), false);
                    if (notice != null) {
                        ntcWhen = this.noticeWhen(td.getNoticeWhen());
                    }
                    this.postNotice(notice, noticeConf, ntcWhen, taskerInfo, (String)exitMsg, execTms, "exec");
                    log.info("tiny-task exec, id={}, prop={}", (Object)id, (Object)key);
                    if (this.execProp.isDryrun()) {
                        long slp = Sleep.ignoreInterrupt((long)10L, (long)2000L);
                        result = "dryrun and sleep " + slp;
                        log.info("tiny-task done, dryrun and sleep {} ms, id={}, prop={}", new Object[]{slp, id, key});
                    } else {
                        result = tasker.invoke(td.getTaskerPara(), true);
                        log.info("tiny-task done, id={}, prop={}", (Object)id, (Object)key);
                    }
                    doneTms = ThreadNow.millis();
                    exitMsg = this.stringResult(result);
                    this.postNotice(notice, noticeConf, ntcWhen, taskerInfo, (String)exitMsg, doneTms, "feed", "done");
                }
                catch (Exception e) {
                    Throwable c = ThrowableUtil.cause((Throwable)e, (int)1);
                    log.error("tiny-task fail, id=" + id + ", prop=" + key, c);
                    failTms = ThreadNow.millis();
                    exitMsg = ThrowableUtil.toString((Throwable)c);
                    this.postNotice(notice, noticeConf, ntcWhen, taskerInfo, (String)exitMsg, failTms, "fail");
                }
                finally {
                    try {
                        Handle.remove(id);
                        this.saveResult(id, key, execTms, failTms, doneTms, (String)exitMsg, td.getDurFail());
                    }
                    catch (Exception e) {
                        log.error("failed to save tiny-task result, id=" + id + ", prop=" + key, (Throwable)e);
                    }
                    if (this.canRelaunch(id, doneTms, failTms, td)) {
                        this.relaunch(id);
                    }
                }
            }, Instant.ofEpochMilli(next));
            Handle.put(id, U.of((Object)handle, (Object)next, (Object)key));
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean notEnable(Boolean b, long id, String key) {
        if (BoxedCastUtil.orTrue((Boolean)b)) {
            return false;
        }
        log.info("skip tiny-task for not enabled, id={}, prop={}", (Object)id, (Object)key);
        return true;
    }

    private boolean notApps(String apps, long id, String key) {
        if (StringUtils.isEmpty((CharSequence)apps)) {
            return false;
        }
        for (String s : PropHelper.commaArray((String)apps)) {
            if (!s.trim().equals(this.appName)) continue;
            return false;
        }
        log.info("skip tiny-task for not apps={}, cur={}, id={}, prop={}", new Object[]{apps, this.appName, id, key});
        return true;
    }

    private boolean notRuns(String runs, long id, String key) {
        if (StringUtils.isEmpty((CharSequence)runs)) {
            return false;
        }
        RunMode rmd = RuntimeMode.getRunMode();
        if (rmd == RunMode.Nothing) {
            log.info("skip tiny-task for not runs={}, cur is Nothing, id={}, prop={}", new Object[]{runs, id, key});
            return true;
        }
        if (!RuntimeMode.voteRunMode((String)runs)) {
            log.info("skip tiny-task for not runs={}, cur={}, id={}, prop={}", new Object[]{runs, rmd, id, key});
            return true;
        }
        return false;
    }

    private Set<String> noticeWhen(String nw) {
        if (nw == null || nw.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> rs = new HashSet<String>();
        for (String s : PropHelper.commaArray((String)nw)) {
            rs.add(s.trim().toLowerCase());
        }
        return rs;
    }

    protected String stringResult(Object result) {
        return JacksonHelper.string((Object)result);
    }

    protected void postNotice(NoticeExec<?> ntc, String cnf, Set<String> whs, String sub, String msg, long ms, String ... wh) {
        if (ntc == null) {
            return;
        }
        String key = null;
        boolean rtn = StringUtils.isNotEmpty((CharSequence)msg);
        for (String w : wh) {
            if (!whs.contains(w)) continue;
            if (w.equals("feed")) {
                if (!rtn || this.execProp.isDryrun()) continue;
                key = w;
                break;
            }
            key = w;
            break;
        }
        if (key == null) {
            return;
        }
        String sb = this.execProp.getNoticePrefix() + " " + sub + " " + key + " #" + this.noticeCounter.incrementAndGet();
        String bd = this.appName + "\n" + String.valueOf(ZonedDateTime.ofInstant(Instant.ofEpochMilli(ms), ThreadNow.sysZoneId()));
        if (rtn) {
            bd = bd + "\n\n" + msg;
        }
        ntc.postNotice(cnf, sb, bd);
    }

    private boolean notNextLock(WinTaskDefine td, long now) {
        WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        int rc = this.winTaskDefineDao.ctx().update((Table)t).set(t.NextLock, t.NextLock.add((Number)1)).set(t.LastExec, (Object)this.milliLdt(now, ThreadNow.sysZoneId())).where(t.Id.eq((Object)td.getId()).and(t.NextLock.eq((Object)td.getNextLock()))).execute();
        return rc <= 0;
    }

    private void saveNextExec(long next, WinTaskDefine td) {
        TransactionHelper.template((Propagation)Propagation.REQUIRES_NEW).execute(ignore -> this.journalService.commit((Enum)Jane.SaveNextExec, journal -> {
            WinTaskDefineTable t = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
            this.winTaskDefineDao.ctx().update((Table)t).set(t.CommitId, (Object)journal.getCommitId()).set(t.ModifyDt, (Object)journal.getCommitDt()).set(t.NextExec, (Object)this.milliLdt(next, ThreadNow.sysZoneId())).where(t.Id.eq((Object)td.getId())).execute();
        }));
    }

    private void saveResult(long id, String key, long exec, long fail, long done, String msg, int cf) {
        log.debug("saveResult, id={}", (Object)id);
        WinTaskDefineTable td = (WinTaskDefineTable)this.winTaskDefineDao.getTable();
        HashMap<Object, Comparable<ChronoLocalDateTime<Object>>> setter = new HashMap<Object, Comparable<ChronoLocalDateTime<Object>>>();
        long exitTms = Math.max(done, fail);
        ZoneId zidSys = ThreadNow.sysZoneId();
        LocalDateTime execLdt = this.milliLdt(exec, zidSys);
        LocalDateTime exitLdt = this.milliLdt(exitTms, zidSys);
        setter.put(td.LastExec, execLdt);
        setter.put(td.LastExit, exitLdt);
        setter.put(td.SumExec, (Comparable<ChronoLocalDateTime<Object>>)td.SumExec.add((Number)1));
        setter.put(td.NextExec, EmptyValue.DATE_TIME);
        if (fail > 0L) {
            setter.put(td.LastFail, Boolean.valueOf(true));
            setter.put(td.SumFail, (Comparable<ChronoLocalDateTime<Object>>)td.SumFail.add((Number)1));
            setter.put(td.DurFail, (Comparable<ChronoLocalDateTime<Object>>)(cf > 0 ? td.DurFail.add((Number)1) : Integer.valueOf(1)));
        } else {
            setter.put(td.LastFail, Boolean.valueOf(false));
            setter.put(td.SumDone, (Comparable<ChronoLocalDateTime<Object>>)td.SumDone.add((Number)1));
            setter.put(td.DurFail, Integer.valueOf(0));
        }
        WinTaskResult po = new WinTaskResult();
        po.setId(this.lightIdService.getId((LightIdAware)this.winTaskResultDao.getTable()));
        po.setTaskId(id);
        po.setTaskKey(key);
        po.setTaskApp(this.appName);
        po.setTaskPid(JvmStat.jvmPid());
        po.setExitData(msg);
        po.setExitFail(fail > 0L);
        po.setTimeExec(execLdt);
        po.setTimeExit(exitLdt);
        po.setTimeCost((int)(exitTms - exec));
        TransactionHelper.template((Propagation)Propagation.REQUIRES_NEW).execute(ignore -> this.journalService.commit((Enum)Jane.SaveResult, journal -> {
            setter.put(td.CommitId, (Comparable<ChronoLocalDateTime<Object>>)journal.getCommitId());
            setter.put(td.ModifyDt, journal.getCommitDt());
            this.winTaskDefineDao.ctx().update((Table)td).set(setter).where(td.Id.eq((Object)id)).execute();
            this.winTaskResultDao.insert(po);
        }));
    }

    private LocalDateTime milliLdt(long m, ZoneId zid) {
        if (m < 0L) {
            return EmptyValue.DATE_TIME;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(m), zid);
    }

    private boolean canRelaunch(long id, long doneTms, long failTms, WinTaskDefine td) {
        int bct;
        int duringExec = td.getDuringExec();
        int sumExec = td.getSumExec();
        if (duringExec > 0 && duringExec <= sumExec + 1) {
            log.info("remove tiny-task for duringExec={}, sumExec={}, id={}, prop={}", new Object[]{duringExec, sumExec, id, td.getPropkey()});
            return false;
        }
        int duringDone = td.getDuringDone();
        int sumDone = td.getSumDone();
        if (duringDone > 0 && duringDone <= (doneTms < 0L ? sumDone : sumDone + 1)) {
            log.info("remove tiny-task for duringDone={}, sumDone={}, id={}, prop={}", new Object[]{duringDone, sumDone, id, td.getPropkey()});
            return false;
        }
        int duringFail = td.getDuringFail();
        int durFail = td.getDurFail();
        if (duringFail > 0 && duringFail <= (failTms < 0L ? durFail : durFail + 1)) {
            log.info("remove tiny-task for duringFail={}, durFail={}, id={}, prop={}", new Object[]{duringFail, durFail, id, td.getPropkey()});
            return false;
        }
        if (Cancel.containsKey(id)) {
            log.info("remove tiny-task for canceled, id={}, prop={}", (Object)id, (Object)td.getPropkey());
            return false;
        }
        int duringBoot = td.getDuringBoot();
        if (duringBoot > 0 && (bct = Booted.compute(id, (ignored, v) -> v == null ? 1 : v + 1).intValue()) >= duringBoot) {
            log.info("remove tiny-task for duringBoot={}, id={}, prop={}", new Object[]{bct, id, td.getPropkey()});
            return false;
        }
        return true;
    }

    protected long calcNextExec(WinTaskDefine td, long now) {
        ZoneId zone;
        String zid = td.getTimingZone();
        ZoneId zoneId = zone = StringUtils.isEmpty((CharSequence)zid) ? ThreadNow.sysZoneId() : ZoneId.of(zid);
        if (this.notRanged(td, zone, now)) {
            return -1L;
        }
        Long id = td.getId();
        long timingMiss = td.getTimingMiss() * 1000L;
        long nextMs = DateLocaling.sysEpoch((LocalDateTime)td.getNextExec());
        if (timingMiss >= 0L && nextMs + timingMiss >= now) {
            log.info("launch misfire tiny-task, id={}, prop={}", (Object)id, (Object)td.getPropkey());
            return nextMs;
        }
        boolean zeroMiss = timingMiss <= 0L && timingMiss + now >= 0L;
        Trigger trigger = this.makeTrigger(td, zone);
        SimpleTriggerContext context = this.makeContext(td, zone, now);
        long nextExec = -1L;
        long n0 = -1L;
        while (true) {
            Instant next;
            if ((next = trigger.nextExecution((TriggerContext)context)) == null) {
                log.info("skip tiny-task for trigger not fire, id={}, prop={}", (Object)id, (Object)td.getPropkey());
                break;
            }
            long n1 = next.toEpochMilli();
            if (n1 >= now) {
                if (zeroMiss && n0 > 0L && now <= n0 + (n1 - n0) * 25L / 100L) {
                    log.info("launch tiny-task for miss=0, next={}, id={}, prop={}", new Object[]{next, id, td.getPropkey()});
                    nextExec = n0;
                    break;
                }
                log.info("launch tiny-task for next={}, id={}, prop={}", new Object[]{next, id, td.getPropkey()});
                nextExec = n1;
                break;
            }
            if (timingMiss > 0L && now <= n1 + timingMiss) {
                log.info("launch tiny-task for miss={}, next={}, id={}, prop={}", new Object[]{timingMiss, next, id, td.getPropkey()});
                nextExec = n1;
                break;
            }
            context.update(next, next, next);
            n0 = n1;
        }
        if (nextExec < 0L) {
            return -1L;
        }
        int timingTune = td.getTimingTune();
        if (timingTune != 0) {
            if (StringUtils.isNotEmpty((CharSequence)td.getTimingCron())) {
                nextExec += (long)timingTune * 1000L;
            } else {
                AtomicInteger first = new AtomicInteger(0);
                Untune.computeIfAbsent(id, k -> {
                    first.set(timingTune);
                    return false;
                });
                nextExec += (long)first.get() * 1000L;
            }
        }
        return nextExec;
    }

    private SimpleTriggerContext makeContext(WinTaskDefine td, ZoneId zone, long now) {
        Instant lastActual = null;
        if (EmptySugar.nonEmptyValue((LocalDateTime)td.getLastExec())) {
            lastActual = Instant.ofEpochMilli(DateLocaling.sysEpoch((LocalDateTime)td.getLastExec()));
        }
        Instant lastCompletion = null;
        if (EmptySugar.nonEmptyValue((LocalDateTime)td.getLastExit())) {
            lastCompletion = Instant.ofEpochMilli(DateLocaling.sysEpoch((LocalDateTime)td.getLastExit()));
        }
        return new SimpleTriggerContext(lastActual, lastActual, lastCompletion);
    }

    private Trigger makeTrigger(WinTaskDefine td, ZoneId zone) {
        String cron = td.getTimingCron();
        if (StringUtils.isNotEmpty((CharSequence)cron)) {
            log.info("use trigger cron={}, id={}, prop={}", new Object[]{cron, td.getId(), td.getPropkey()});
            return new CronTrigger(cron, zone);
        }
        int idle = td.getTimingIdle();
        if (idle > 0) {
            log.info("use trigger idle={}, id={}, prop={}", new Object[]{idle, td.getId(), td.getPropkey()});
            PeriodicTrigger trg = new PeriodicTrigger(Duration.ofSeconds(idle));
            trg.setFixedRate(false);
            return trg;
        }
        int rate = td.getTimingRate();
        if (rate > 0) {
            log.info("use trigger rate={}, id={}, prop={}", new Object[]{rate, td.getId(), td.getPropkey()});
            PeriodicTrigger trg = new PeriodicTrigger(Duration.ofSeconds(rate));
            trg.setFixedRate(true);
            return trg;
        }
        throw new IllegalArgumentException("no cron/idle/rate to make trigger");
    }

    private boolean notRanged(WinTaskDefine td, ZoneId zone, long now) {
        LocalDateTime ldt;
        long ms;
        LocalDateTime ldt2;
        long ms2;
        String duringFrom = td.getDuringFrom();
        if (StringUtils.isNotEmpty((CharSequence)duringFrom) && (ms2 = DateLocaling.useEpoch((LocalDateTime)(ldt2 = DateParser.parseDateTime((CharSequence)duringFrom)), (ZoneId)zone)) > now) {
            log.info("skip tiny-task for duringFrom={}, id={}, prop={}", new Object[]{duringFrom, td.getId(), td.getPropkey()});
            return true;
        }
        String duringStop = td.getDuringStop();
        if (StringUtils.isNotEmpty((CharSequence)duringStop) && (ms = DateLocaling.useEpoch((LocalDateTime)(ldt = DateParser.parseDateTime((CharSequence)duringStop)), (ZoneId)zone)) < now) {
            log.info("skip tiny-task for duringStop={}, id={}, prop={}", new Object[]{duringStop, td.getId(), td.getPropkey()});
            return true;
        }
        int duringExec = td.getDuringExec();
        if (duringExec > 0 && duringExec <= td.getSumExec()) {
            log.info("skip tiny-task for duringExec={}, sumExec={}, id={}, prop={}", new Object[]{duringExec, td.getSumExec(), td.getId(), td.getPropkey()});
            return true;
        }
        int duringDone = td.getDuringDone();
        if (duringDone > 0 && duringDone <= td.getSumDone()) {
            log.info("skip tiny-task for duringDone={}, sumDone={}, id={}, prop={}", new Object[]{duringDone, td.getSumDone(), td.getId(), td.getPropkey()});
            return true;
        }
        int duringFail = td.getDuringFail();
        if (duringFail > 0 && duringFail <= td.getDurFail()) {
            log.info("skip tiny-task for duringFail={}, durFail={}, id={}, prop={}", new Object[]{duringFail, td.getDurFail(), td.getId(), td.getPropkey()});
            return true;
        }
        return false;
    }

    @Value(value="${spring.application.name}")
    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Autowired
    @Generated
    public void setWinTaskDefineDao(WinTaskDefineDao winTaskDefineDao) {
        this.winTaskDefineDao = winTaskDefineDao;
    }

    @Autowired
    @Generated
    public void setWinTaskResultDao(WinTaskResultDao winTaskResultDao) {
        this.winTaskResultDao = winTaskResultDao;
    }

    @Autowired
    @Generated
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }

    @Autowired
    @Generated
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    @Autowired
    @Generated
    public void setExecProp(TinyTaskExecProp execProp) {
        this.execProp = execProp;
    }

    public static enum Jane {
        SaveNextExec,
        SaveResult;

    }
}

