/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.task.service.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.async.TaskSchedulerHelper;
import pro.fessional.wings.tiny.task.service.TinyTaskConfService;
import pro.fessional.wings.tiny.task.service.TinyTaskExecService;
import pro.fessional.wings.tiny.task.service.TinyTaskService;

@Service
@ConditionalWingsEnabled
public class TinyTaskServiceImpl
implements TinyTaskService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyTaskServiceImpl.class);
    protected TinyTaskConfService tinyTaskConfService;
    protected TinyTaskExecService tinyTaskExecService;

    @Override
    @NotNull
    public ThreadPoolTaskScheduler referScheduler(boolean fast) {
        return TaskSchedulerHelper.Scheduler((boolean)fast);
    }

    @Override
    @NotNull
    public Set<TinyTaskService.Task> schedule(@NotNull Object taskerBean) {
        Set<TinyTaskConfService.Conf> conf = this.tinyTaskConfService.config(taskerBean);
        HashSet<TinyTaskService.Task> rst = new HashSet<TinyTaskService.Task>();
        for (TinyTaskConfService.Conf cnf : conf) {
            if (cnf.isEnabled() && cnf.isAutorun() && cnf.isMatched()) {
                boolean cd = this.tinyTaskExecService.launch(cnf.getId());
                log.info("schedule bean tiny-task {}, scheduled={}", (Object)cnf, (Object)cd);
                rst.add(new TinyTaskService.Task(cnf.getId(), cnf.getKey(), cd));
                continue;
            }
            log.info("skip bean tiny-task {}", (Object)cnf);
        }
        return rst;
    }

    @Override
    public TinyTaskService.Task schedule(@NotNull Object taskerBean, @NotNull Method taskerCall, @Nullable Object taskerPara) {
        boolean cd;
        TinyTaskConfService.Conf cnf = this.tinyTaskConfService.config(taskerBean, taskerCall, taskerPara);
        if (cnf.isEnabled()) {
            cd = this.tinyTaskExecService.launch(cnf.getId());
            log.info("schedule method tiny-task {}, scheduled={}", (Object)cnf, (Object)cd);
        } else {
            cd = false;
            log.info("skip method tiny-task {}", (Object)cnf);
        }
        return new TinyTaskService.Task(cnf.getId(), cnf.getKey(), cd);
    }

    @Autowired
    @Generated
    public void setTinyTaskConfService(TinyTaskConfService tinyTaskConfService) {
        this.tinyTaskConfService = tinyTaskConfService;
    }

    @Autowired
    @Generated
    public void setTinyTaskExecService(TinyTaskExecService tinyTaskExecService) {
        this.tinyTaskExecService = tinyTaskExecService;
    }
}

