/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.conf.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.wings.faceless.database.WingsTableCudHandler;
import pro.fessional.wings.warlock.caching.CacheConst;
import pro.fessional.wings.warlock.caching.CacheEventHelper;
import pro.fessional.wings.warlock.database.autogen.tables.WinConfRuntimeTable;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinConfRuntimeDao;
import pro.fessional.wings.warlock.database.autogen.tables.pojos.WinConfRuntime;
import pro.fessional.wings.warlock.event.cache.TableChangeEvent;
import pro.fessional.wings.warlock.service.conf.RuntimeConfService;

@CacheConfig(cacheNames={"service~RuntimeConfService!"}, cacheManager="MemoryCacheManager")
public class RuntimeConfServiceImpl
implements RuntimeConfService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuntimeConfServiceImpl.class);
    public static final String PropHandler = "prop";
    public static final String JsonHandler = "json";
    public static final String KryoHandler = "kryo";
    protected WinConfRuntimeDao winConfRuntimeDao;
    protected WingsTableCudHandler wingsTableCudHandler;
    private final Map<String, ConversionService> handlerMap = new LinkedHashMap<String, ConversionService>();
    protected RuntimeConfServiceImpl selfLazy;

    public void putHandler(String type, ConversionService handler) {
        this.handlerMap.put(type, handler);
    }

    @Override
    public <T> T getObject(String key, TypeDescriptor type) {
        return this.selfLazy.getObjectCache(key, type);
    }

    @Override
    public void setObject(String key, Object value) {
        WinConfRuntimeTable t = (WinConfRuntimeTable)this.winConfRuntimeDao.getTable();
        String handler = (String)this.winConfRuntimeDao.fetchOne(String.class, (Table)t, t.Key.eq((Object)key), new QueryPart[]{t.Handler});
        ConversionService service = this.handlerMap.get(handler);
        String str = (String)service.convert(value, String.class);
        AssertArgs.notNull((Object)str, (String)"can not covert value to string, key={}", (Object[])new Object[]{key});
        int rc = this.winConfRuntimeDao.ctx().update((Table)t).set((Field)t.Current, (Object)str).set((Field)t.Previous, (Field)t.Current).where(t.Key.eq((Object)key)).execute();
        if (rc > 0) {
            this.wingsTableCudHandler.handle(this.getClass(), WingsTableCudHandler.Cud.Update, (Table)t, () -> {
                HashMap<String, List<String>> field = new HashMap<String, List<String>>();
                field.put(t.Key.getName(), List.of(key));
                field.put(t.Current.getName(), List.of(str));
                return field;
            });
        }
    }

    @Override
    public boolean newObject(String key, Object value, String comment, String handler) {
        if (key == null || key.isEmpty() || value == null || handler == null) {
            return false;
        }
        ConversionService service = this.handlerMap.get(handler);
        if (service == null || !service.canConvert(value.getClass(), String.class)) {
            return false;
        }
        String str = (String)service.convert(value, String.class);
        AssertArgs.notNull((Object)str, (String)"can not covert value to string, key={}", (Object[])new Object[]{key});
        WinConfRuntime pojo = new WinConfRuntime();
        pojo.setKey(key);
        pojo.setCurrent(str);
        pojo.setPrevious("");
        pojo.setInitial(str);
        pojo.setComment(StringUtils.trimToEmpty((String)comment));
        pojo.setHandler(handler);
        int rc = this.winConfRuntimeDao.insertInto((Object)pojo, false);
        log.debug("rc={}, key={}, han={}, val={}", new Object[]{rc, key, handler, str});
        if (rc > 0) {
            WingsTableCudHandler.Cud type = rc == 1 ? WingsTableCudHandler.Cud.Create : WingsTableCudHandler.Cud.Update;
            WinConfRuntimeTable t = (WinConfRuntimeTable)this.winConfRuntimeDao.getTable();
            this.wingsTableCudHandler.handle(this.getClass(), type, (Table)t, () -> {
                HashMap<String, List<String>> field = new HashMap<String, List<String>>();
                field.put(t.Key.getName(), List.of(key));
                field.put(t.Current.getName(), List.of(str));
                return field;
            });
        }
        return rc >= 1;
    }

    @Override
    public boolean newObject(String key, Object value, String comment) {
        for (String handler : new ArrayList<String>(this.handlerMap.keySet())) {
            if (!this.newObject(key, value, comment, handler)) continue;
            return true;
        }
        return false;
    }

    @Cacheable
    public <T> T getObjectCache(String key, TypeDescriptor type) {
        if (this.winConfRuntimeDao.notTableExist()) {
            log.warn("winConfRuntimeDao.notTableExist, key={}", (Object)key);
            return null;
        }
        WinConfRuntimeTable t = (WinConfRuntimeTable)this.winConfRuntimeDao.getTable();
        Record2 r2 = (Record2)this.winConfRuntimeDao.ctx().select((SelectField)t.Current, (SelectField)t.Handler).from((TableLike)t).where(t.Key.eq((Object)key)).fetchOne();
        if (r2 != null) {
            ConversionService service = this.handlerMap.get(r2.value2());
            Object obj = service.convert(r2.value1(), TypeDescriptor.valueOf(String.class), type);
            return (T)obj;
        }
        return null;
    }

    @EventListener
    @CacheEvict(allEntries=true, condition="#result")
    public boolean evictAllConfCache(TableChangeEvent event) {
        String tb = CacheEventHelper.receiveTable((TableChangeEvent)event, (Collection)CacheConst.RuntimeConfService.EventTables, (int)12);
        if (tb != null) {
            log.debug("evictAllConfCache by {}, {}", (Object)tb, (Object)event);
            return true;
        }
        return false;
    }

    @Autowired
    @Generated
    public void setWinConfRuntimeDao(WinConfRuntimeDao winConfRuntimeDao) {
        this.winConfRuntimeDao = winConfRuntimeDao;
    }

    @Autowired
    @Generated
    public void setWingsTableCudHandler(WingsTableCudHandler wingsTableCudHandler) {
        this.wingsTableCudHandler = wingsTableCudHandler;
    }

    @Autowired
    @Lazy
    @Generated
    public void setSelfLazy(RuntimeConfServiceImpl selfLazy) {
        this.selfLazy = selfLazy;
    }
}

