/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.perm.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jooq.Field;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.event.EventListener;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.data.CodeEnum;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.pain.CodeException;
import pro.fessional.wings.faceless.database.WingsTableCudHandler;
import pro.fessional.wings.faceless.service.journal.JournalAware;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.warlock.caching.CacheConst;
import pro.fessional.wings.warlock.caching.CacheEventHelper;
import pro.fessional.wings.warlock.database.autogen.tables.WinRoleEntryTable;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinRoleEntryDao;
import pro.fessional.wings.warlock.database.autogen.tables.pojos.WinRoleEntry;
import pro.fessional.wings.warlock.errcode.CommonErrorEnum;
import pro.fessional.wings.warlock.event.cache.TableChangeEvent;
import pro.fessional.wings.warlock.service.perm.WarlockPermNormalizer;
import pro.fessional.wings.warlock.service.perm.WarlockRoleService;

public class WarlockRoleServiceImpl
implements WarlockRoleService {
    private static final Logger log = LoggerFactory.getLogger(WarlockRoleServiceImpl.class);
    protected final Caching warlockRoleServiceCaching;

    public Map<Long, String> loadRoleAll() {
        return this.warlockRoleServiceCaching.loadRoleAll();
    }

    public long create(@NotNull String name, String remark) {
        return this.warlockRoleServiceCaching.create(name, remark);
    }

    public void modify(long roleId, String remark) {
        this.warlockRoleServiceCaching.modify(roleId, remark);
    }

    public WarlockRoleServiceImpl(Caching warlockRoleServiceCaching) {
        this.warlockRoleServiceCaching = warlockRoleServiceCaching;
    }

    @CacheConfig(cacheNames={"service~WarlockRoleService!"}, cacheManager="MemoryCacheManager")
    public static class Caching {
        private static final Logger log = LoggerFactory.getLogger(Caching.class);
        protected WinRoleEntryDao winRoleEntryDao;
        protected LightIdService lightIdService;
        protected JournalService journalService;
        protected WarlockPermNormalizer permNormalizer;
        protected WingsTableCudHandler wingsTableCudHandler;

        @Cacheable
        public Map<Long, String> loadRoleAll() {
            if (this.winRoleEntryDao.notTableExist()) {
                return Collections.emptyMap();
            }
            WinRoleEntryTable t = (WinRoleEntryTable)this.winRoleEntryDao.getTable();
            Map all = this.winRoleEntryDao.ctx().select((SelectField)t.Id, (SelectField)t.Name).from((TableLike)t).where(t.getOnlyLive()).fetch().intoMap(Record2::value1, it -> this.permNormalizer.role((String)it.value2()));
            log.debug("loadRoleAll size={}", (Object)all.size());
            return all;
        }

        @EventListener
        @CacheEvict(allEntries=true, condition="#result")
        public boolean evictRoleAllCache(TableChangeEvent event) {
            String tb = CacheEventHelper.receiveTable((TableChangeEvent)event, (Collection)CacheConst.WarlockRoleService.EventTables);
            if (tb != null) {
                log.debug("evictRoleAllCache by {}, {}", (Object)tb, (Object)event);
                return true;
            }
            return false;
        }

        public long create(@NotNull String name, String remark) {
            if (!StringUtils.hasText((String)name)) {
                throw new CodeException((CodeEnum)CommonErrorEnum.AssertEmpty1, new Object[]{"role.name"});
            }
            WinRoleEntryTable t = (WinRoleEntryTable)this.winRoleEntryDao.getTable();
            Long rid = (Long)this.journalService.submit((Enum)WarlockRoleService.Jane.Create, (Object)name, (Object)remark, commit -> {
                long id = this.lightIdService.getId((LightIdAware)t);
                WinRoleEntry po = new WinRoleEntry();
                po.setId(Long.valueOf(id));
                po.setName(name);
                po.setRemark(Null.notNull((CharSequence)remark));
                commit.create((JournalAware)po);
                try {
                    this.winRoleEntryDao.insert((Object)po);
                }
                catch (Exception e) {
                    log.error("failed to insert role entry. name=" + name + ", remark=" + remark, (Throwable)e);
                    throw new CodeException((Throwable)e, (CodeEnum)CommonErrorEnum.AssertState2, new Object[]{"role.name", name});
                }
                return id;
            });
            this.wingsTableCudHandler.handle(this.getClass(), WingsTableCudHandler.Cud.Create, (Table)t, () -> {
                HashMap<String, List<Long>> field = new HashMap<String, List<Long>>();
                field.put(t.Id.getName(), List.of(rid));
                return field;
            });
            return rid;
        }

        public void modify(long roleId, String remark) {
            WinRoleEntryTable t = (WinRoleEntryTable)this.winRoleEntryDao.getTable();
            int rct = (Integer)this.journalService.submit((Enum)WarlockRoleService.Jane.Modify, (Object)roleId, (Object)remark, commit -> {
                int rc = this.winRoleEntryDao.ctx().update((Table)t).set((Field)t.CommitId, (Object)commit.getCommitId()).set((Field)t.ModifyDt, (Object)commit.getCommitDt()).set((Field)t.Remark, (Object)remark).where(t.Id.eq((Object)roleId)).execute();
                log.info("modify role remark. roleId={}, affect={}", (Object)roleId, (Object)rc);
                return rc;
            });
            if (rct > 0) {
                this.wingsTableCudHandler.handle(this.getClass(), WingsTableCudHandler.Cud.Update, (Table)t, () -> {
                    HashMap<String, List<Long>> field = new HashMap<String, List<Long>>();
                    field.put(t.Id.getName(), List.of(Long.valueOf(roleId)));
                    return field;
                });
            }
        }

        @Autowired
        public void setWinRoleEntryDao(WinRoleEntryDao winRoleEntryDao) {
            this.winRoleEntryDao = winRoleEntryDao;
        }

        @Autowired
        public void setLightIdService(LightIdService lightIdService) {
            this.lightIdService = lightIdService;
        }

        @Autowired
        public void setJournalService(JournalService journalService) {
            this.journalService = journalService;
        }

        @Autowired
        public void setPermNormalizer(WarlockPermNormalizer permNormalizer) {
            this.permNormalizer = permNormalizer;
        }

        @Autowired
        public void setWingsTableCudHandler(WingsTableCudHandler wingsTableCudHandler) {
            this.wingsTableCudHandler = wingsTableCudHandler;
        }
    }
}

