/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.user.impl;

import org.jetbrains.annotations.NotNull;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DAOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.mirana.page.PageQuery;
import pro.fessional.mirana.page.PageResult;
import pro.fessional.wings.faceless.database.jooq.helper.PageJooqHelper;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.slardar.context.Now;
import pro.fessional.wings.slardar.context.TerminalAttribute;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.context.TerminalContextAware;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;
import pro.fessional.wings.warlock.database.autogen.tables.WinUserLoginTable;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinUserLoginDao;
import pro.fessional.wings.warlock.database.autogen.tables.pojos.WinUserLogin;
import pro.fessional.wings.warlock.service.user.WarlockUserLoginService;

public class WarlockUserLoginServiceImpl
implements WarlockUserLoginService,
TerminalContextAware {
    private static final Logger log = LoggerFactory.getLogger(WarlockUserLoginServiceImpl.class);
    protected WinUserLoginDao winUserLoginDao;
    protected WingsAuthTypeParser wingsAuthTypeParser;
    protected LightIdService lightIdService;

    @NotNull
    public PageResult<WarlockUserLoginService.Item> list(long userId, PageQuery query) {
        if (this.winUserLoginDao.notTableExist()) {
            return PageResult.empty();
        }
        WinUserLoginTable t = (WinUserLoginTable)this.winUserLoginDao.getTable();
        return PageJooqHelper.use((DAOImpl)this.winUserLoginDao, (PageQuery)query).count().from(new TableLike[]{t}).whereTrue().order(new OrderField[]{t.LoginDt.desc()}).fetch((SelectField)t.AuthType, (SelectField)t.LoginIp, (SelectField)t.LoginDt, (SelectField)t.Terminal, (SelectField)t.Failed).into(WarlockUserLoginService.Item.class);
    }

    public void auth(WarlockUserLoginService.Auth auth) {
        if (this.winUserLoginDao.notTableExist()) {
            return;
        }
        WinUserLogin po = new WinUserLogin();
        po.setId(Long.valueOf(this.lightIdService.getId((LightIdAware)this.winUserLoginDao.getTable())));
        po.setUserId(Long.valueOf(auth.getUserId()));
        po.setLoginDt(Now.localDateTime());
        po.setDetails(auth.getDetails());
        po.setFailed(Boolean.valueOf(auth.isFailed()));
        String at = this.wingsAuthTypeParser.parse(auth.getAuthType());
        po.setAuthType(at);
        TerminalContext.Context tc = this.getTerminalContext();
        po.setLoginIp((String)tc.getTerminal(TerminalAttribute.TerminalAddr));
        po.setTerminal((String)tc.getTerminal(TerminalAttribute.TerminalAgent));
        this.winUserLoginDao.insert((Object)po);
    }

    @Autowired
    public void setWinUserLoginDao(WinUserLoginDao winUserLoginDao) {
        this.winUserLoginDao = winUserLoginDao;
    }

    @Autowired
    public void setWingsAuthTypeParser(WingsAuthTypeParser wingsAuthTypeParser) {
        this.wingsAuthTypeParser = wingsAuthTypeParser;
    }

    @Autowired
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }
}

