/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.grant.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jooq.Condition;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.wings.faceless.service.journal.JournalAware;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.warlock.database.autogen.tables.WinRoleGrantTable;
import pro.fessional.wings.warlock.database.autogen.tables.WinUserGrantTable;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinRoleGrantDao;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinUserGrantDao;
import pro.fessional.wings.warlock.database.autogen.tables.records.WinRoleGrantRecord;
import pro.fessional.wings.warlock.database.autogen.tables.records.WinUserGrantRecord;
import pro.fessional.wings.warlock.enums.autogen.GrantType;
import pro.fessional.wings.warlock.service.grant.WarlockGrantService;

public class WarlockGrantServiceImpl
implements WarlockGrantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WarlockGrantServiceImpl.class);
    protected JournalService journalService;
    protected WinRoleGrantDao winRoleGrantDao;
    protected WinUserGrantDao winUserGrantDao;

    public void grantRole(long roleId, @NotNull GrantType type, @NotNull Collection<Long> grant) {
        if (grant.isEmpty()) {
            return;
        }
        this.journalService.commit((Enum)WarlockGrantService.Jane.Grant, (Object)roleId, grant, commit -> {
            ArrayList<WinRoleGrantRecord> pos = new ArrayList<WinRoleGrantRecord>(grant.size());
            for (Long g : grant) {
                WinRoleGrantRecord rd = new WinRoleGrantRecord();
                rd.setReferRole(Long.valueOf(roleId));
                rd.setGrantType(type);
                rd.setGrantEntry(g);
                commit.create((JournalAware)rd);
                pos.add(rd);
            }
            this.winRoleGrantDao.batchInsert(pos, 100, true);
        });
    }

    public void purgeRole(long roleId, @NotNull GrantType type, @NotNull Collection<Long> grant) {
        if (grant.isEmpty()) {
            return;
        }
        this.journalService.commit((Enum)WarlockGrantService.Jane.Purge, (Object)roleId, grant, commit -> {
            WinRoleGrantTable t = (WinRoleGrantTable)this.winRoleGrantDao.getTable();
            Condition cond = t.ReferRole.eq((Object)roleId).and(t.GrantType.eq((Object)type)).and(t.GrantEntry.in(grant));
            this.winRoleGrantDao.delete((Table)t, cond);
        });
    }

    public void grantUser(long userId, @NotNull GrantType type, @NotNull Collection<Long> grant) {
        if (grant.isEmpty()) {
            return;
        }
        this.journalService.commit((Enum)WarlockGrantService.Jane.Grant, (Object)userId, grant, commit -> {
            ArrayList<WinUserGrantRecord> pos = new ArrayList<WinUserGrantRecord>(grant.size());
            for (Long g : grant) {
                WinUserGrantRecord rd = new WinUserGrantRecord();
                rd.setReferUser(Long.valueOf(userId));
                rd.setGrantType(type);
                rd.setGrantEntry(g);
                commit.create((JournalAware)rd);
                pos.add(rd);
            }
            this.winUserGrantDao.batchInsert(pos, 100, true);
        });
    }

    public void purgeUser(long userId, @NotNull GrantType type, @NotNull Collection<Long> grant) {
        if (grant.isEmpty()) {
            return;
        }
        this.journalService.commit((Enum)WarlockGrantService.Jane.Purge, (Object)userId, grant, commit -> {
            WinUserGrantTable t = (WinUserGrantTable)this.winUserGrantDao.getTable();
            Condition cond = t.ReferUser.eq((Object)userId).and(t.GrantType.eq((Object)type)).and(t.GrantEntry.in(grant));
            this.winUserGrantDao.delete((Table)t, cond);
        });
    }

    public Map<Long, Set<Long>> entryUser(@NotNull GrantType type, @NotNull Collection<Long> userId) {
        if (this.winUserGrantDao.notTableExist()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>();
        WinUserGrantTable t = (WinUserGrantTable)this.winUserGrantDao.getTable();
        Result rs = this.winUserGrantDao.ctx().select((SelectField)t.GrantEntry, (SelectField)t.ReferUser).from((TableLike)t).where(t.GrantType.eq((Object)type).and(t.ReferUser.in(userId))).fetch();
        for (Record2 r2 : rs) {
            Set set = result.computeIfAbsent((Long)r2.value1(), k -> new HashSet());
            set.add((Long)r2.value2());
        }
        return result;
    }

    public Map<Long, Set<Long>> entryRole(@NotNull GrantType type, @NotNull Collection<Long> roleId) {
        if (this.winRoleGrantDao.notTableExist()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>();
        WinRoleGrantTable t = (WinRoleGrantTable)this.winRoleGrantDao.getTable();
        Result rs = this.winRoleGrantDao.ctx().select((SelectField)t.GrantEntry, (SelectField)t.ReferRole).from((TableLike)t).where(t.GrantType.eq((Object)type).and(t.ReferRole.in(roleId))).fetch();
        for (Record2 r2 : rs) {
            Set set = result.computeIfAbsent((Long)r2.value1(), k -> new HashSet());
            set.add((Long)r2.value2());
        }
        return result;
    }

    @Autowired
    @Generated
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    @Autowired
    @Generated
    public void setWinRoleGrantDao(WinRoleGrantDao winRoleGrantDao) {
        this.winRoleGrantDao = winRoleGrantDao;
    }

    @Autowired
    @Generated
    public void setWinUserGrantDao(WinUserGrantDao winUserGrantDao) {
        this.winUserGrantDao = winUserGrantDao;
    }
}

