/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.perm.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Field;
import org.jooq.Record3;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.event.EventListener;
import pro.fessional.wings.faceless.database.WingsTableCudHandler;
import pro.fessional.wings.faceless.service.journal.JournalAware;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.warlock.caching.CacheConst;
import pro.fessional.wings.warlock.caching.CacheEventHelper;
import pro.fessional.wings.warlock.database.autogen.tables.WinPermEntryTable;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinPermEntryDao;
import pro.fessional.wings.warlock.database.autogen.tables.pojos.WinPermEntry;
import pro.fessional.wings.warlock.event.cache.TableChangeEvent;
import pro.fessional.wings.warlock.service.grant.PermGrantHelper;
import pro.fessional.wings.warlock.service.perm.WarlockPermService;

public class WarlockPermServiceImpl
implements WarlockPermService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WarlockPermServiceImpl.class);
    protected final Caching warlockPermServiceCaching;

    public Map<Long, String> loadPermAll() {
        return this.warlockPermServiceCaching.loadPermAll();
    }

    public void create(@NotNull String scopes, @NotNull Collection<WarlockPermService.Act> acts) {
        this.warlockPermServiceCaching.create(scopes, acts);
    }

    public void modify(long permId, @NotNull String remark) {
        this.warlockPermServiceCaching.modify(permId, remark);
    }

    @Generated
    public WarlockPermServiceImpl(Caching warlockPermServiceCaching) {
        this.warlockPermServiceCaching = warlockPermServiceCaching;
    }

    @CacheConfig(cacheNames={"service~WarlockPermService!"}, cacheManager="MemoryCacheManager")
    public static class Caching {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Caching.class);
        protected WinPermEntryDao winPermEntryDao;
        protected LightIdService lightIdService;
        protected JournalService journalService;
        protected WingsTableCudHandler wingsTableCudHandler;

        @Cacheable
        public Map<Long, String> loadPermAll() {
            if (this.winPermEntryDao.notTableExist()) {
                return Collections.emptyMap();
            }
            WinPermEntryTable t = (WinPermEntryTable)this.winPermEntryDao.getTable();
            Map all = this.winPermEntryDao.ctx().select((SelectField)t.Id, (SelectField)t.Scopes, (SelectField)t.Action).from((TableLike)t).where(t.getOnlyLive()).fetch().intoMap(Record3::value1, it -> PermGrantHelper.unitePermit((String)((String)it.value2()), (String)((String)it.value3())));
            log.debug("loadPermAll size={}", (Object)all.size());
            return all;
        }

        @EventListener
        @CacheEvict(allEntries=true, condition="#result")
        public boolean evictPermAllCache(@Nullable TableChangeEvent event) {
            String tb = CacheEventHelper.receiveTable((TableChangeEvent)event, (Collection)CacheConst.WarlockPermService.EventTables);
            if (tb != null) {
                log.debug("evictPermAllCache by {}, {}", (Object)tb, (Object)event);
                return true;
            }
            return false;
        }

        public void create(@NotNull String scopes, @NotNull Collection<WarlockPermService.Act> acts) {
            if (acts.isEmpty()) {
                return;
            }
            WinPermEntryTable t = (WinPermEntryTable)this.winPermEntryDao.getTable();
            ArrayList pos = new ArrayList(acts.size());
            this.journalService.commit((Enum)WarlockPermService.Jane.Create, (Object)scopes, commit -> {
                for (WarlockPermService.Act act : acts) {
                    WinPermEntry po = new WinPermEntry();
                    po.setId(Long.valueOf(this.lightIdService.getId((LightIdAware)t)));
                    po.setScopes(scopes);
                    po.setAction(act.getAction());
                    po.setRemark(act.getRemark());
                    commit.create((JournalAware)po);
                    pos.add(po);
                }
                log.info("insert perm scope={}, action count={}", (Object)scopes, (Object)acts.size());
                this.winPermEntryDao.insert((Collection)pos);
            });
            this.wingsTableCudHandler.handle(this.getClass(), WingsTableCudHandler.Cud.Create, (Table)t, () -> {
                HashMap<String, List<Long>> field = new HashMap<String, List<Long>>();
                field.put(t.Id.getName(), pos.stream().map(WinPermEntry::getId).toList());
                return field;
            });
        }

        public void modify(long permId, @NotNull String remark) {
            WinPermEntryTable t = (WinPermEntryTable)this.winPermEntryDao.getTable();
            int rct = (Integer)this.journalService.submit((Enum)WarlockPermService.Jane.Modify, (Object)permId, commit -> {
                int rc = this.winPermEntryDao.ctx().update((Table)t).set((Field)t.CommitId, (Object)commit.getCommitId()).set((Field)t.ModifyDt, (Object)commit.getCommitDt()).set((Field)t.Remark, (Object)remark).where(t.Id.eq((Object)permId)).execute();
                log.info("modify perm remark. permId={}, affect={}", (Object)permId, (Object)rc);
                return rc;
            });
            if (rct > 0) {
                this.wingsTableCudHandler.handle(this.getClass(), WingsTableCudHandler.Cud.Update, (Table)t, () -> {
                    HashMap<String, List<Long>> field = new HashMap<String, List<Long>>();
                    field.put(t.Id.getName(), List.of(Long.valueOf(permId)));
                    return field;
                });
            }
        }

        @Autowired
        @Generated
        public void setWinPermEntryDao(WinPermEntryDao winPermEntryDao) {
            this.winPermEntryDao = winPermEntryDao;
        }

        @Autowired
        @Generated
        public void setLightIdService(LightIdService lightIdService) {
            this.lightIdService = lightIdService;
        }

        @Autowired
        @Generated
        public void setJournalService(JournalService journalService) {
            this.journalService = journalService;
        }

        @Autowired
        @Generated
        public void setWingsTableCudHandler(WingsTableCudHandler wingsTableCudHandler) {
            this.wingsTableCudHandler = wingsTableCudHandler;
        }
    }
}

