/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.user.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.annotation.Transactional;
import pro.fessional.mirana.best.TypedReg;
import pro.fessional.mirana.data.CodeEnum;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.data.Z;
import pro.fessional.mirana.pain.CodeException;
import pro.fessional.wings.faceless.service.journal.JournalAware;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.slardar.context.AttributeHolder;
import pro.fessional.wings.slardar.security.PasssaltEncoder;
import pro.fessional.wings.slardar.security.PasswordHelper;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;
import pro.fessional.wings.warlock.constants.WarlockGlobalAttribute;
import pro.fessional.wings.warlock.database.autogen.tables.WinUserAuthnTable;
import pro.fessional.wings.warlock.database.autogen.tables.WinUserBasisTable;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinUserAuthnDao;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinUserBasisDao;
import pro.fessional.wings.warlock.database.autogen.tables.pojos.WinUserAuthn;
import pro.fessional.wings.warlock.enums.autogen.UserStatus;
import pro.fessional.wings.warlock.errcode.CommonErrorEnum;
import pro.fessional.wings.warlock.service.auth.WarlockDangerService;
import pro.fessional.wings.warlock.service.user.WarlockUserAuthnService;
import pro.fessional.wings.warlock.spring.prop.WarlockSecurityProp;

public class WarlockUserAuthnServiceImpl
implements WarlockUserAuthnService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WarlockUserAuthnServiceImpl.class);
    protected WinUserAuthnDao winUserAuthnDao;
    protected WinUserBasisDao winUserBasisDao;
    protected WingsAuthTypeParser wingsAuthTypeParser;
    protected PasswordEncoder passwordEncoder;
    protected PasssaltEncoder passsaltEncoder;
    protected JournalService journalService;
    protected LightIdService lightIdService;
    protected WarlockSecurityProp warlockSecurityProp;
    protected WarlockDangerService warlockDangerService;

    @Transactional
    public long create(long userId, @NotNull WarlockUserAuthnService.Authn authn) {
        Enum authType = authn.getAuthType();
        return (Long)this.journalService.submit((Enum)WarlockUserAuthnService.Jane.Create, (Object)userId, (Object)authType, commit -> {
            long id = this.lightIdService.getId((LightIdAware)this.winUserAuthnDao.getTable());
            WinUserAuthn auth = new WinUserAuthn();
            auth.setId(Long.valueOf(id));
            auth.setUserId(Long.valueOf(userId));
            auth.setAuthType(this.wingsAuthTypeParser.parse(authType));
            auth.setUsername(authn.getUsername());
            String salt = (String)AttributeHolder.tryAttr((TypedReg)WarlockGlobalAttribute.SaltByUid, (Object)userId);
            PasswordHelper helper = new PasswordHelper(this.passwordEncoder, this.passsaltEncoder);
            auth.setPassword(helper.hash(authn.getPassword(), salt));
            auth.setExtraPara(Null.notNull((CharSequence)authn.getExtraPara()));
            auth.setExtraUser(Null.notNull((CharSequence)authn.getExtraUser()));
            if (authn.getExpiredDt() == null) {
                Duration expire = this.warlockSecurityProp.getAutoregExpired();
                auth.setExpiredDt(commit.getCommitDt().plusSeconds(expire.getSeconds()));
            } else {
                auth.setExpiredDt(authn.getExpiredDt());
            }
            auth.setFailedCnt((Integer)Z.notNullSafe((Object)0, (Object)authn.getFailedCnt()));
            auth.setFailedMax((Integer)Z.notNullSafe((Object)this.warlockSecurityProp.getAutoregMaxFailed(), (Object)authn.getFailedMax()));
            commit.create((JournalAware)auth);
            try {
                this.winUserAuthnDao.insert((Object)auth);
            }
            catch (Exception e) {
                log.error("failed to insert authn " + String.valueOf(authn), (Throwable)e);
                throw new CodeException((Throwable)e, (CodeEnum)CommonErrorEnum.DataExisted);
            }
            return id;
        });
    }

    @Transactional
    public void modify(long userId, @NotNull WarlockUserAuthnService.Authn authn) {
        Enum authType = authn.getAuthType();
        this.journalService.commit((Enum)WarlockUserAuthnService.Jane.Modify, (Object)userId, (Object)authType, commit -> {
            WinUserAuthnTable t = (WinUserAuthnTable)this.winUserAuthnDao.getTable();
            Condition cond = t.onlyLive(t.AuthType.eq((Object)this.wingsAuthTypeParser.parse(authType)).and(t.UserId.eq((Object)userId)));
            HashMap<TableField, Object> setter = new HashMap<TableField, Object>();
            if (authn.getPassword() != null) {
                PasswordHelper helper = new PasswordHelper(this.passwordEncoder, this.passsaltEncoder);
                String slat = (String)AttributeHolder.tryAttr((TypedReg)WarlockGlobalAttribute.SaltByUid, (Object)userId);
                setter.put(t.Password, helper.hash(authn.getPassword(), slat));
            }
            setter.put(t.Username, authn.getUsername());
            setter.put(t.ExtraPara, authn.getExtraPara());
            setter.put(t.ExtraUser, authn.getExtraUser());
            setter.put(t.ExpiredDt, authn.getExpiredDt());
            setter.put(t.FailedCnt, authn.getFailedCnt());
            setter.put(t.FailedMax, authn.getFailedMax());
            setter.put(t.CommitId, commit.getCommitId());
            setter.put(t.ModifyDt, commit.getCommitDt());
            int rc = this.winUserAuthnDao.update((Table)t, setter, cond, true);
            if (rc != 1) {
                log.warn("failed to modify authn. uid={}, type={}, affect={}", new Object[]{userId, authType, rc});
                throw new CodeException((CodeEnum)CommonErrorEnum.DataNotFound);
            }
        });
    }

    @Transactional
    public void renew(long userId, @NotNull WarlockUserAuthnService.Renew renew) {
        String otherInfo = "by userId and auth-type=" + String.valueOf(renew.getAuthType());
        this.journalService.commit((Enum)WarlockUserAuthnService.Jane.Renew, (Object)userId, (Object)otherInfo, commit -> {
            String at = this.wingsAuthTypeParser.parse(renew.getAuthType());
            WinUserAuthnTable t = (WinUserAuthnTable)this.winUserAuthnDao.getTable();
            Condition cond = t.onlyLive(t.AuthType.eq((Object)at).and(t.UserId.eq((Object)userId)));
            HashMap<TableField, Object> setter = new HashMap<TableField, Object>();
            if (renew.getPassword() != null) {
                String slat = (String)AttributeHolder.tryAttr((TypedReg)WarlockGlobalAttribute.SaltByUid, (Object)userId);
                PasswordHelper helper = new PasswordHelper(this.passwordEncoder, this.passsaltEncoder);
                setter.put(t.Password, helper.hash(renew.getPassword(), slat));
            }
            if (renew.getExpiredDt() != null) {
                setter.put(t.ExpiredDt, renew.getExpiredDt());
            } else {
                Duration expire = this.warlockSecurityProp.getAutoregExpired();
                setter.put(t.ExpiredDt, commit.getCommitDt().plusSeconds(expire.getSeconds()));
            }
            if (renew.getFailedMax() != null) {
                setter.put(t.FailedMax, renew.getFailedMax());
            } else {
                setter.put(t.FailedMax, this.warlockSecurityProp.getAutoregMaxFailed());
            }
            if (renew.getFailedCnt() != null) {
                setter.put(t.FailedCnt, renew.getFailedCnt());
            } else {
                setter.put(t.FailedCnt, 0);
            }
            setter.put(t.CommitId, commit.getCommitId());
            setter.put(t.ModifyDt, commit.getCommitDt());
            int rc = this.winUserAuthnDao.update((Table)t, setter, cond, true);
            if (rc != 1) {
                log.warn("failed to renew {}, key={}, affect={}", new Object[]{otherInfo, userId, rc});
                throw new CodeException((CodeEnum)CommonErrorEnum.DataNotFound);
            }
        });
    }

    public void dander(long userId, boolean danger, Enum<?> ... authType) {
        if (this.winUserBasisDao.notTableExist()) {
            return;
        }
        this.journalService.commit((Enum)WarlockUserAuthnService.Jane.Danger, (Object)userId, (Object)danger, commit -> {
            WinUserBasisTable tu = (WinUserBasisTable)this.winUserBasisDao.getTable();
            this.winUserBasisDao.ctx().update((Table)tu).set((Field)tu.Status, (Object)(danger ? UserStatus.DANGER : UserStatus.ACTIVE)).set((Field)tu.CommitId, (Object)commit.getCommitId()).set((Field)tu.ModifyDt, (Object)commit.getCommitDt()).where(tu.Id.eq((Object)userId)).execute();
            if (!danger && !this.winUserAuthnDao.notTableExist()) {
                WinUserAuthnTable ta = (WinUserAuthnTable)this.winUserAuthnDao.getTable();
                Condition cond = ta.UserId.eq((Object)userId);
                if (authType.length != 0) {
                    ArrayList<String> ats = new ArrayList<String>(authType.length);
                    for (Enum en : authType) {
                        ats.add(this.wingsAuthTypeParser.parse(en));
                    }
                    cond = cond.and(ta.AuthType.in(ats));
                }
                this.winUserAuthnDao.ctx().update((Table)ta).set((Field)ta.FailedCnt, (Object)0).set((Field)ta.CommitId, (Object)commit.getCommitId()).set((Field)ta.ModifyDt, (Object)commit.getCommitDt()).where(cond).execute();
                Result r2 = this.winUserAuthnDao.ctx().select((SelectField)ta.AuthType, (SelectField)ta.Username).from((TableLike)ta).where(cond).fetch();
                for (Record2 r : r2) {
                    this.warlockDangerService.allow(this.wingsAuthTypeParser.parse((String)r.value1()), (String)r.value2());
                }
            }
        });
    }

    @NotNull
    public List<WarlockUserAuthnService.Item> list(long userId) {
        if (this.winUserAuthnDao.notTableExist()) {
            return Collections.emptyList();
        }
        WinUserAuthnTable t = (WinUserAuthnTable)this.winUserAuthnDao.getTable();
        return this.winUserAuthnDao.fetchLive(WarlockUserAuthnService.Item.class, (Table)t, new QueryPart[]{t.Username, t.AuthType, t.ExpiredDt, t.FailedCnt});
    }

    @Autowired
    @Generated
    public void setWinUserAuthnDao(WinUserAuthnDao winUserAuthnDao) {
        this.winUserAuthnDao = winUserAuthnDao;
    }

    @Autowired
    @Generated
    public void setWinUserBasisDao(WinUserBasisDao winUserBasisDao) {
        this.winUserBasisDao = winUserBasisDao;
    }

    @Autowired
    @Generated
    public void setWingsAuthTypeParser(WingsAuthTypeParser wingsAuthTypeParser) {
        this.wingsAuthTypeParser = wingsAuthTypeParser;
    }

    @Autowired
    @Generated
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Autowired
    @Generated
    public void setPasssaltEncoder(PasssaltEncoder passsaltEncoder) {
        this.passsaltEncoder = passsaltEncoder;
    }

    @Autowired
    @Generated
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    @Autowired
    @Generated
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }

    @Autowired
    @Generated
    public void setWarlockSecurityProp(WarlockSecurityProp warlockSecurityProp) {
        this.warlockSecurityProp = warlockSecurityProp;
    }

    @Autowired
    @Generated
    public void setWarlockDangerService(WarlockDangerService warlockDangerService) {
        this.warlockDangerService = warlockDangerService;
    }
}

