/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.user.impl;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.mirana.best.TypedReg;
import pro.fessional.mirana.code.RandCode;
import pro.fessional.mirana.data.CodeEnum;
import pro.fessional.mirana.data.Z;
import pro.fessional.wings.faceless.database.helper.DaoAssert;
import pro.fessional.wings.faceless.service.journal.JournalAware;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.slardar.context.AttributeHolder;
import pro.fessional.wings.slardar.context.TerminalAttribute;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.event.EventPublishHelper;
import pro.fessional.wings.slardar.event.attr.AttributeRidEvent;
import pro.fessional.wings.warlock.constants.WarlockGlobalAttribute;
import pro.fessional.wings.warlock.database.autogen.tables.WinUserBasisTable;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinUserBasisDao;
import pro.fessional.wings.warlock.database.autogen.tables.pojos.WinUserBasis;
import pro.fessional.wings.warlock.enums.autogen.UserGender;
import pro.fessional.wings.warlock.enums.autogen.UserStatus;
import pro.fessional.wings.warlock.errcode.CommonErrorEnum;
import pro.fessional.wings.warlock.service.user.WarlockUserBasisService;

public class WarlockUserBasisServiceImpl
implements WarlockUserBasisService,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WarlockUserBasisServiceImpl.class);
    protected WinUserBasisDao winUserBasisDao;
    protected LightIdService lightIdService;
    protected JournalService journalService;

    public void afterPropertiesSet() {
        if (this.winUserBasisDao.notTableExist()) {
            return;
        }
        log.info("warlock conf SaltByUid for GlobalAttributeHolder");
        AttributeHolder.regLoader((TypedReg)WarlockGlobalAttribute.SaltByUid, k -> {
            WinUserBasisTable t = (WinUserBasisTable)this.winUserBasisDao.getTable();
            return (String)this.winUserBasisDao.ctx().select((SelectField)t.Passsalt).from((TableLike)t).where(t.Id.eq(k)).fetchOneInto(String.class);
        });
        log.info("warlock conf LocaleByUid for GlobalAttributeHolder");
        AttributeHolder.regLoader((TypedReg)TerminalAttribute.LocaleByUid, k -> {
            WinUserBasisTable t = (WinUserBasisTable)this.winUserBasisDao.getTable();
            return (Locale)this.winUserBasisDao.ctx().select((SelectField)t.Locale).from((TableLike)t).where(t.Id.eq(k)).fetchOneInto(Locale.class);
        });
        log.info("warlock conf ZoneIdByUid for GlobalAttributeHolder");
        AttributeHolder.regLoader((TypedReg)TerminalAttribute.ZoneIdByUid, k -> {
            WinUserBasisTable t = (WinUserBasisTable)this.winUserBasisDao.getTable();
            return (ZoneId)this.winUserBasisDao.ctx().select((SelectField)t.Zoneid).from((TableLike)t).where(t.Id.eq(k)).fetchOneInto(ZoneId.class);
        });
    }

    public long create(@NotNull WarlockUserBasisService.Basis user) {
        return (Long)this.journalService.submit((Enum)WarlockUserBasisService.Jane.Create, (Object)user.getNickname(), commit -> {
            WinUserBasisTable tu = (WinUserBasisTable)this.winUserBasisDao.getTable();
            long uid = this.lightIdService.getId((LightIdAware)tu);
            WinUserBasis po = new WinUserBasis();
            po.setId(Long.valueOf(uid));
            po.setNickname(user.getNickname());
            String passsalt = RandCode.human((int)40);
            AttributeHolder.putAttr((TypedReg)WarlockGlobalAttribute.SaltByUid, (Object)uid, (Object)passsalt);
            po.setPasssalt(passsalt);
            po.setAvatar((String)Z.notNullSafe((Object)"", (Object)user.getAvatar()));
            po.setGender((UserGender)Z.notNullSafe((Object)UserGender.UNKNOWN, (Object)user.getGender()));
            po.setLocale((Locale)Z.notNullSafe(TerminalContext::defaultLocale, (Object)user.getLocale()));
            po.setZoneid((ZoneId)Z.notNullSafe(TerminalContext::defaultZoneId, (Object)user.getZoneId()));
            po.setRemark((String)Z.notNullSafe((Object)"", (Object)user.getRemark()));
            po.setStatus((UserStatus)Z.notNullSafe((Object)UserStatus.UNINIT, (Object)user.getStatus()));
            commit.create((JournalAware)po);
            this.winUserBasisDao.insert((Object)po);
            return uid;
        });
    }

    public void modify(long userId, @NotNull WarlockUserBasisService.Basis user) {
        Integer rc = (Integer)this.journalService.submit((Enum)WarlockUserBasisService.Jane.Modify, (Object)userId, commit -> {
            WinUserBasisTable tu = (WinUserBasisTable)this.winUserBasisDao.getTable();
            HashMap<TableField, Object> setter = new HashMap<TableField, Object>();
            setter.put(tu.Nickname, user.getNickname());
            setter.put(tu.Gender, user.getGender());
            setter.put(tu.Avatar, user.getAvatar());
            setter.put(tu.Locale, user.getLocale());
            setter.put(tu.Zoneid, user.getZoneId());
            setter.put(tu.Remark, user.getRemark());
            setter.put(tu.Status, user.getStatus());
            setter.put(tu.CommitId, commit.getCommitId());
            setter.put(tu.ModifyDt, commit.getCommitDt());
            return this.winUserBasisDao.update((Table)tu, setter, tu.Id.eq((Object)userId), true);
        });
        DaoAssert.assertEq1((int)rc, (CodeEnum)CommonErrorEnum.DataNotFound);
        AttributeRidEvent event = new AttributeRidEvent();
        event.rid(TerminalAttribute.LocaleByUid, (Object[])new Long[]{userId});
        event.rid(TerminalAttribute.ZoneIdByUid, (Object[])new Long[]{userId});
        EventPublishHelper.AsyncWidely.publishEvent((Object)event);
    }

    @Autowired
    @Generated
    public void setWinUserBasisDao(WinUserBasisDao winUserBasisDao) {
        this.winUserBasisDao = winUserBasisDao;
    }

    @Autowired
    @Generated
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }

    @Autowired
    @Generated
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }
}

