/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.controller.admin;

import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;
import pro.fessional.wings.warlock.service.user.WarlockUserAuthnService;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.warlock.mvc-auth")
public class AdminAuthnController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminAuthnController.class);
    protected WarlockUserAuthnService warlockUserAuthnService;
    protected WingsAuthTypeParser wingsAuthTypeParser;

    @Operation(summary="set/unset user danger status and failed count", description="# Usage\nset/unset user danger status and failed count\n## Params\n* @param userId - the user\n* @param danger - set danger or unset\n* @param authType - auth type to reset\n## Returns\n* @return {401} if not authed\n* @return {200} ok or redirect\n")
    @PostMapping(value={"${wings.warlock.urlmap.admin-authn-danger}"})
    @ResponseBody
    public R<Void> adminAuthnDanger(@RequestBody Ins ins) {
        List<String> tps = ins.getAuthType();
        if (tps == null || tps.isEmpty()) {
            this.warlockUserAuthnService.dander(ins.getUserId(), ins.isDanger(), new Enum[0]);
        } else {
            Enum[] types = new Enum[tps.size()];
            int idx = 0;
            for (String tp : tps) {
                types[idx++] = this.wingsAuthTypeParser.parse(tp);
            }
            this.warlockUserAuthnService.dander(ins.getUserId(), ins.isDanger(), types);
        }
        return R.OK();
    }

    @Autowired
    @Generated
    public void setWarlockUserAuthnService(WarlockUserAuthnService warlockUserAuthnService) {
        this.warlockUserAuthnService = warlockUserAuthnService;
    }

    @Autowired
    @Generated
    public void setWingsAuthTypeParser(WingsAuthTypeParser wingsAuthTypeParser) {
        this.wingsAuthTypeParser = wingsAuthTypeParser;
    }

    public static class Ins {
        private long userId;
        private boolean danger;
        private List<String> authType;

        @Generated
        public Ins() {
        }

        @Generated
        public long getUserId() {
            return this.userId;
        }

        @Generated
        public boolean isDanger() {
            return this.danger;
        }

        @Generated
        public List<String> getAuthType() {
            return this.authType;
        }

        @Generated
        public void setUserId(long userId) {
            this.userId = userId;
        }

        @Generated
        public void setDanger(boolean danger) {
            this.danger = danger;
        }

        @Generated
        public void setAuthType(List<String> authType) {
            this.authType = authType;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ins)) {
                return false;
            }
            Ins other = (Ins)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUserId() != other.getUserId()) {
                return false;
            }
            if (this.isDanger() != other.isDanger()) {
                return false;
            }
            List<String> this$authType = this.getAuthType();
            List<String> other$authType = other.getAuthType();
            return !(this$authType == null ? other$authType != null : !((Object)this$authType).equals(other$authType));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Ins;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $userId = this.getUserId();
            result = result * 59 + (int)($userId >>> 32 ^ $userId);
            result = result * 59 + (this.isDanger() ? 79 : 97);
            List<String> $authType = this.getAuthType();
            result = result * 59 + ($authType == null ? 43 : ((Object)$authType).hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "AdminAuthnController.Ins(userId=" + this.getUserId() + ", danger=" + this.isDanger() + ", authType=" + String.valueOf(this.getAuthType()) + ")";
        }
    }
}

