/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth.impl;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.mirana.best.TypedReg;
import pro.fessional.mirana.i18n.CodeEnum;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.slardar.context.AttributeHolder;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.errcode.AuthnErrorEnum;
import pro.fessional.wings.slardar.security.WingsAuthTypeParser;
import pro.fessional.wings.warlock.constants.WarlockGlobalAttribute;
import pro.fessional.wings.warlock.database.autogen.tables.WinUserAuthnTable;
import pro.fessional.wings.warlock.database.autogen.tables.WinUserBasisTable;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinUserAuthnDao;
import pro.fessional.wings.warlock.database.autogen.tables.daos.WinUserBasisDao;
import pro.fessional.wings.warlock.security.error.FailureWaitingInternalAuthenticationServiceException;
import pro.fessional.wings.warlock.service.auth.WarlockAuthnService;
import pro.fessional.wings.warlock.service.auth.WarlockDangerService;
import pro.fessional.wings.warlock.service.auth.impl.ComboWarlockAuthnService;
import pro.fessional.wings.warlock.service.user.WarlockUserAuthnService;
import pro.fessional.wings.warlock.service.user.WarlockUserLoginService;
import pro.fessional.wings.warlock.spring.prop.WarlockDangerProp;

public class DefaultDaoAuthnCombo
implements ComboWarlockAuthnService.Combo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDaoAuthnCombo.class);
    public static final int ORDER = -30000000;
    private int order = -30000000;
    protected WinUserBasisDao winUserBasisDao;
    protected WinUserAuthnDao winUserAuthnDao;
    protected WingsAuthTypeParser wingsAuthTypeParser;
    protected WarlockUserLoginService warlockUserLoginService;
    protected WarlockUserAuthnService warlockUserAuthnService;
    protected JournalService journalService;
    protected WarlockDangerProp warlockDangerProp;
    protected WarlockDangerService warlockDangerService;

    public WarlockAuthnService.Details load(@NotNull Enum<?> authType, String username) {
        int block = this.warlockDangerService.check(authType, username);
        if (block > 0) {
            throw new FailureWaitingInternalAuthenticationServiceException(block, (CodeEnum)AuthnErrorEnum.FailureWaiting1, new Object[]{block});
        }
        if (this.winUserBasisDao.notTableExist() || this.winUserAuthnDao.notTableExist()) {
            return null;
        }
        WinUserBasisTable user = (WinUserBasisTable)this.winUserBasisDao.getAlias();
        WinUserAuthnTable auth = (WinUserAuthnTable)this.winUserAuthnDao.getAlias();
        String at = this.wingsAuthTypeParser.parse(authType);
        Condition cond = user.Id.eq((Field)auth.UserId).and(auth.AuthType.eq((Object)at)).and(auth.Username.eq((Object)username)).and(user.getOnlyLive()).and(auth.getOnlyLive());
        return this.selectDetails(user, auth, authType, cond);
    }

    public WarlockAuthnService.Details load(@NotNull Enum<?> authType, long userId) {
        if (this.winUserBasisDao.notTableExist() || this.winUserAuthnDao.notTableExist()) {
            return null;
        }
        WinUserBasisTable user = (WinUserBasisTable)this.winUserBasisDao.getAlias();
        WinUserAuthnTable auth = (WinUserAuthnTable)this.winUserAuthnDao.getAlias();
        String at = this.wingsAuthTypeParser.parse(authType);
        Condition cond = user.Id.eq((Field)auth.UserId).and(auth.AuthType.eq((Object)at)).and(auth.UserId.eq((Object)userId)).and(user.getOnlyLive()).and(auth.getOnlyLive());
        return this.selectDetails(user, auth, authType, cond);
    }

    public void onSuccess(@NotNull Enum<?> authType, long userId, String details) {
        if (this.winUserAuthnDao.notTableExist()) {
            return;
        }
        String at = this.wingsAuthTypeParser.parse(authType);
        this.journalService.commit((Enum)WarlockAuthnService.Jane.Success, (Object)userId, (Object)("success login auth-type=" + at), commit -> {
            WarlockUserLoginService.Auth la = new WarlockUserLoginService.Auth();
            la.setAuthType(authType);
            la.setUserId(userId);
            la.setDetails(details);
            la.setFailed(false);
            this.warlockUserLoginService.auth(la);
            WinUserAuthnTable ta = (WinUserAuthnTable)this.winUserAuthnDao.getTable();
            this.winUserAuthnDao.ctx().update((Table)ta).set((Field)ta.FailedCnt, (Object)0).set((Field)ta.CommitId, (Object)commit.getCommitId()).set((Field)ta.ModifyDt, (Object)commit.getCommitDt()).where(ta.UserId.eq((Object)userId).and(ta.AuthType.eq((Object)at))).execute();
        });
        String username = TerminalContext.get().getUsername();
        this.warlockDangerService.allow(authType, username);
    }

    public void onFailure(@NotNull Enum<?> authType, String username, String details) {
        if (username == null || username.isEmpty() || this.winUserAuthnDao.notTableExist()) {
            return;
        }
        String at = this.wingsAuthTypeParser.parse(authType);
        WinUserAuthnTable ta = (WinUserAuthnTable)this.winUserAuthnDao.getTable();
        Record4 auth = (Record4)this.winUserAuthnDao.ctx().select((SelectField)ta.UserId, (SelectField)ta.FailedCnt, (SelectField)ta.FailedMax, (SelectField)ta.Id).from((TableLike)ta).where(ta.Username.eq((Object)username).and(ta.AuthType.eq((Object)at)).and(ta.getOnlyLive())).fetchOne();
        if (auth == null) {
            log.debug("ignore login failure by not found auth-type={}, username={}", (Object)at, (Object)username);
            return;
        }
        long uid = (Long)auth.value1();
        int cnt = (Integer)auth.value2();
        long aid = (Long)auth.value4();
        int max = (Integer)auth.value3();
        int second = (int)(this.warlockDangerProp.getRetryStep().toSeconds() * (long)cnt);
        this.warlockDangerService.block(authType, username, second);
        if (cnt > max) {
            log.debug("ignore login failure by reach max-count={}, auth-type={}, username={}", new Object[]{max, at, username});
            return;
        }
        this.journalService.commit((Enum)WarlockAuthnService.Jane.Failure, (Object)uid, (Object)("failed login auth-id=" + aid), commit -> {
            if (this.warlockDangerProp.isMaxFailure() && cnt >= max) {
                log.info("danger user by reach max-count={}, auth-type={}, username={}", new Object[]{max, at, username});
                this.warlockUserAuthnService.dander(uid, true, new Enum[0]);
            }
            this.winUserAuthnDao.ctx().update((Table)ta).set((Field)ta.FailedCnt, ta.FailedCnt.add((Number)1)).set((Field)ta.CommitId, (Object)commit.getCommitId()).set((Field)ta.ModifyDt, (Object)commit.getCommitDt()).where(ta.Id.eq((Object)aid)).execute();
            WarlockUserLoginService.Auth la = new WarlockUserLoginService.Auth();
            la.setAuthType(authType);
            la.setUserId(uid);
            la.setDetails(details);
            la.setFailed(true);
            this.warlockUserLoginService.auth(la);
        });
    }

    private WarlockAuthnService.Details selectDetails(WinUserBasisTable user, WinUserAuthnTable auth, Enum<?> authType, Condition cond) {
        WarlockAuthnService.Details details = (WarlockAuthnService.Details)this.winUserAuthnDao.ctx().select((SelectField)auth.UserId, (SelectField)user.Nickname, (SelectField)user.Locale, (SelectField)user.Zoneid.as("zoneId"), (SelectField)user.Status, (SelectField)auth.Username, (SelectField)auth.Password, (SelectField)auth.ExpiredDt).from(new TableLike[]{user, auth}).where(cond).fetchOneInto(WarlockAuthnService.Details.class);
        if (details != null) {
            details.setAuthType(authType);
            String passsalt = (String)AttributeHolder.tryAttr((TypedReg)WarlockGlobalAttribute.SaltByUid, (Object)details.getUserId());
            details.setPasssalt(passsalt);
        }
        return details;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public WinUserBasisDao getWinUserBasisDao() {
        return this.winUserBasisDao;
    }

    @Generated
    public WinUserAuthnDao getWinUserAuthnDao() {
        return this.winUserAuthnDao;
    }

    @Generated
    public WingsAuthTypeParser getWingsAuthTypeParser() {
        return this.wingsAuthTypeParser;
    }

    @Generated
    public WarlockUserLoginService getWarlockUserLoginService() {
        return this.warlockUserLoginService;
    }

    @Generated
    public WarlockUserAuthnService getWarlockUserAuthnService() {
        return this.warlockUserAuthnService;
    }

    @Generated
    public JournalService getJournalService() {
        return this.journalService;
    }

    @Generated
    public WarlockDangerProp getWarlockDangerProp() {
        return this.warlockDangerProp;
    }

    @Generated
    public WarlockDangerService getWarlockDangerService() {
        return this.warlockDangerService;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Autowired
    @Generated
    public void setWinUserBasisDao(WinUserBasisDao winUserBasisDao) {
        this.winUserBasisDao = winUserBasisDao;
    }

    @Autowired
    @Generated
    public void setWinUserAuthnDao(WinUserAuthnDao winUserAuthnDao) {
        this.winUserAuthnDao = winUserAuthnDao;
    }

    @Autowired
    @Generated
    public void setWingsAuthTypeParser(WingsAuthTypeParser wingsAuthTypeParser) {
        this.wingsAuthTypeParser = wingsAuthTypeParser;
    }

    @Autowired
    @Generated
    public void setWarlockUserLoginService(WarlockUserLoginService warlockUserLoginService) {
        this.warlockUserLoginService = warlockUserLoginService;
    }

    @Autowired
    @Generated
    public void setWarlockUserAuthnService(WarlockUserAuthnService warlockUserAuthnService) {
        this.warlockUserAuthnService = warlockUserAuthnService;
    }

    @Autowired
    @Generated
    public void setJournalService(JournalService journalService) {
        this.journalService = journalService;
    }

    @Autowired
    @Generated
    public void setWarlockDangerProp(WarlockDangerProp warlockDangerProp) {
        this.warlockDangerProp = warlockDangerProp;
    }

    @Autowired
    @Generated
    public void setWarlockDangerService(WarlockDangerService warlockDangerService) {
        this.warlockDangerService = warlockDangerService;
    }
}

