/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.controller.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import pro.fessional.mirana.bits.HmacHelp;
import pro.fessional.mirana.bits.MdHelp;
import pro.fessional.mirana.io.CircleInputStream;
import pro.fessional.mirana.io.InputStreams;
import pro.fessional.mirana.text.FormatUtil;
import pro.fessional.wings.slardar.context.Now;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.context.TerminalInterceptor;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;
import pro.fessional.wings.slardar.servlet.stream.CirclePart;
import pro.fessional.wings.slardar.webmvc.SimpleResponse;
import pro.fessional.wings.warlock.service.auth.WarlockTicketService;
import pro.fessional.wings.warlock.spring.prop.WarlockApiAuthProp;

public abstract class AbstractApiAuthController {
    public static final int MD5_LEN = 32;
    public static final int SHA1_LEN = 40;
    public static final int HMAC_LEN = 64;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean compatible = true;
    protected WarlockApiAuthProp apiAuthProp;
    protected WarlockTicketService ticketService;
    protected TerminalInterceptor terminalInterceptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestMapping(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        WarlockTicketService.Pass pass = null;
        String cid = request.getHeader(this.apiAuthProp.getClientHeader());
        if (cid != null) {
            WarlockTicketService.Term term = this.ticketService.decode(cid);
            if (term != null) {
                pass = this.ticketService.findPass(term.getClientId());
            } else if (this.compatible) {
                pass = this.ticketService.findPass(cid);
            }
        }
        if (pass == null) {
            this.responseText(response, this.apiAuthProp.getErrorClient());
            return;
        }
        ApiEntity entity = this.validate(request, pass.getSecret());
        if (entity.error != null) {
            this.responseText(response, this.apiAuthProp.getErrorSignature(), entity.error);
            return;
        }
        request.setAttribute("WINGS.ATTR.USER_ID", (Object)pass.getUserId());
        TerminalContext.Context ctx = this.terminalInterceptor.loginTerminal(request);
        boolean handled = false;
        try {
            entity.terminal = ctx;
            if (this.handle(request, entity)) {
                this.responseBody(response, entity, pass);
                handled = true;
            }
        }
        catch (Exception e) {
            this.log.warn("unhandled api exception", (Throwable)e);
        }
        finally {
            this.terminalInterceptor.logoutTerminal(request);
        }
        if (!handled) {
            this.responseText(response, this.apiAuthProp.getErrorUnhandled());
        }
    }

    protected void responseBody(@NotNull HttpServletResponse response, @NotNull ApiEntity entity, @NotNull WarlockTicketService.Pass pass) {
        response.setHeader(this.apiAuthProp.getClientHeader(), pass.getClient());
        String timestamp = entity.timestamp.isEmpty() ? String.valueOf(Now.millis()) : entity.timestamp;
        response.setHeader(this.apiAuthProp.getTimestampHeader(), timestamp);
        for (Map.Entry<String, String> en : entity.resHead.entrySet()) {
            response.setHeader(en.getKey(), en.getValue());
        }
        int sgnLen = entity.signature.length();
        String secret = pass.getSecret();
        if (entity.resFile == null) {
            String body = entity.resText;
            String data = body + secret + timestamp;
            String signature = this.signature(data, sgnLen, secret);
            if (!signature.isEmpty()) {
                response.setHeader(this.apiAuthProp.getSignatureHeader(), signature);
            }
            response.setContentType("application/json");
            this.responseText(response, HttpStatus.OK.value(), body);
        } else {
            String data;
            InputStream body;
            int size = entity.resFile.available();
            int sumLen = 0;
            if ((long)size < this.apiAuthProp.getDigestMax().toBytes()) {
                for (Map.Entry<String, String> en : entity.reqPara.entrySet()) {
                    if (!en.getKey().endsWith(".sum")) continue;
                    sumLen = en.getValue().length();
                    break;
                }
                if (sumLen == 0) {
                    sumLen = entity.digest.length();
                }
            }
            if (sumLen == 32 || sumLen == 40) {
                body = new CircleInputStream(entity.resFile);
                String digest = this.digest(body, sumLen);
                data = digest + secret + timestamp;
                response.setHeader(this.apiAuthProp.getDigestHeader(), digest);
            } else {
                body = entity.resFile;
                data = secret + timestamp;
            }
            String signature = this.signature(data, sgnLen, secret);
            if (!signature.isEmpty()) {
                response.setHeader(this.apiAuthProp.getSignatureHeader(), signature);
            }
            ResponseHelper.downloadFile((HttpServletResponse)response, (String)entity.resText, (InputStream)body);
        }
    }

    protected void responseText(@NotNull HttpServletResponse response, @NotNull SimpleResponse body) {
        this.responseText(response, body.getHttpStatus(), body.getResponseBody());
    }

    protected void responseText(@NotNull HttpServletResponse response, @NotNull SimpleResponse body, @Nullable ApiError code) {
        String responseBody = body.getResponseBody();
        if (code != null) {
            responseBody = responseBody.replace("{code}", code.name());
        }
        this.responseText(response, body.getHttpStatus(), responseBody);
    }

    protected void responseText(@NotNull HttpServletResponse response, int status, @NotNull String body) {
        response.setStatus(status);
        PrintWriter writer = response.getWriter();
        writer.write(body);
        writer.close();
    }

    @NotNull
    public ApiEntity parse(@NotNull HttpServletRequest request, boolean mustSign) {
        Collection<Object> pts;
        String tms;
        String sum;
        ApiEntity entity = new ApiEntity();
        String sgn = request.getHeader(this.apiAuthProp.getSignatureHeader());
        if (sgn == null || sgn.isEmpty()) {
            if (mustSign) {
                entity.error = ApiError.SignatureMissing;
                return entity;
            }
        } else {
            entity.signature = sgn;
        }
        if ((sum = request.getHeader(this.apiAuthProp.getDigestHeader())) != null) {
            entity.digest = sum;
        }
        if ((tms = request.getHeader(this.apiAuthProp.getTimestampHeader())) != null) {
            entity.timestamp = tms;
        }
        TreeMap<String, String> par = new TreeMap<String, String>();
        for (Map.Entry en : request.getParameterMap().entrySet()) {
            CharSequence[] vls = (String[])en.getValue();
            if (vls == null || vls.length == 0) {
                par.put((String)en.getKey(), "");
                continue;
            }
            if (vls.length == 1) {
                par.put((String)en.getKey(), vls[0]);
                continue;
            }
            par.put((String)en.getKey(), String.join((CharSequence)"", vls));
        }
        entity.reqPara = par;
        Collection<Object> collection = pts = request.getContentType().contains("multipart/form-data") ? request.getParts() : Collections.emptyList();
        if (pts.isEmpty()) {
            entity.reqBody = InputStreams.readText((InputStream)request.getInputStream());
        } else {
            HashMap<String, Part> prt = new HashMap<String, Part>();
            String jbn = this.apiAuthProp.getFileJsonBody();
            for (Part part : pts) {
                String name = part.getName();
                if (par.containsKey(name)) continue;
                if (name.equals(jbn)) {
                    entity.reqBody = InputStreams.readText((InputStream)part.getInputStream());
                    continue;
                }
                prt.put(name, part);
            }
            entity.reqFile = prt;
        }
        return entity;
    }

    @NotNull
    public ApiEntity validate(@NotNull HttpServletRequest request, @NotNull String secret) {
        String sum;
        String data;
        boolean mustSign = this.apiAuthProp.isMustSignature();
        ApiEntity entity = this.parse(request, mustSign);
        if (entity.error != null) {
            return entity;
        }
        String para = FormatUtil.sortParam(entity.reqPara);
        if (entity.reqFile.isEmpty()) {
            data = para + entity.reqBody + secret + entity.timestamp;
        } else {
            for (Map.Entry<String, Part> en : entity.reqFile.entrySet()) {
                String name = en.getKey();
                Part pt = en.getValue();
                Part cpt = this.checkDigest(entity.reqPara.get(name + ".sum"), pt);
                if (cpt == null) {
                    entity.error = ApiError.DigestFileInvalid;
                    return entity;
                }
                if (cpt == pt) continue;
                en.setValue(cpt);
            }
            data = para + secret + entity.timestamp;
        }
        int sumLen = entity.digest.length();
        if (sumLen > 0 && !entity.digest.equalsIgnoreCase(sum = this.digest(entity.reqBody, sumLen))) {
            entity.error = ApiError.DigestBodyInvalid;
            return entity;
        }
        String sign = this.signature(data, entity.signature.length(), secret);
        if (mustSign && !sign.equalsIgnoreCase(entity.signature)) {
            entity.error = ApiError.SignatureInvalid;
        }
        return entity;
    }

    private Part checkDigest(String sum, Part pt) {
        String dig;
        if (sum == null || sum.isEmpty()) {
            return pt;
        }
        int len = sum.length();
        if (len == 32 || len == 40) {
            pt = new CirclePart(pt);
            dig = this.digest(pt.getInputStream(), len);
        } else {
            dig = "";
        }
        return sum.equalsIgnoreCase(dig) ? pt : null;
    }

    @NotNull
    public String digest(InputStream data, int len) {
        if (len == 32) {
            return MdHelp.md5.sum(data);
        }
        if (len == 40) {
            return MdHelp.sha1.sum(data);
        }
        return "";
    }

    @NotNull
    public String digest(String data, int len) {
        if (len == 32) {
            return MdHelp.md5.sum(data);
        }
        if (len == 40) {
            return MdHelp.sha1.sum(data);
        }
        return "";
    }

    @NotNull
    public String signature(String data, int len, String secret) {
        if (len == 32) {
            return MdHelp.md5.sum(data);
        }
        if (len == 40) {
            return MdHelp.sha1.sum(data);
        }
        if (len == 64) {
            HmacHelp h256 = HmacHelp.sha256((byte[])secret.getBytes(StandardCharsets.UTF_8));
            return h256.sum(data);
        }
        return "";
    }

    public abstract boolean handle(@NotNull HttpServletRequest var1, @NotNull ApiEntity var2) throws Exception;

    public void setCompatible(boolean compatible) {
        this.compatible = compatible;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    @Autowired
    public void setApiAuthProp(WarlockApiAuthProp apiAuthProp) {
        this.apiAuthProp = apiAuthProp;
    }

    @Autowired
    public void setTicketService(WarlockTicketService ticketService) {
        this.ticketService = ticketService;
    }

    @Autowired
    public void setTerminalInterceptor(TerminalInterceptor terminalInterceptor) {
        this.terminalInterceptor = terminalInterceptor;
    }

    public static class ApiEntity {
        @NotNull
        private String timestamp = "";
        @NotNull
        private String signature = "";
        @NotNull
        private String digest = "";
        @NotNull
        private TerminalContext.Context terminal = TerminalContext.Null;
        @NotNull
        private Map<String, String> reqPara = Collections.emptyMap();
        @NotNull
        private String reqBody = "";
        @NotNull
        private Map<String, Part> reqFile = Collections.emptyMap();
        private ApiError error = null;
        @NotNull
        private String resText = "";
        @Nullable
        private InputStream resFile = null;
        @NotNull
        private Map<String, String> resHead = Collections.emptyMap();

        @NotNull
        public String getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public String getSignature() {
            return this.signature;
        }

        @NotNull
        public String getDigest() {
            return this.digest;
        }

        @NotNull
        public TerminalContext.Context getTerminal() {
            return this.terminal;
        }

        @NotNull
        public Map<String, String> getReqPara() {
            return this.reqPara;
        }

        @NotNull
        public String getReqBody() {
            return this.reqBody;
        }

        @NotNull
        public Map<String, Part> getReqFile() {
            return this.reqFile;
        }

        public ApiError getError() {
            return this.error;
        }

        @NotNull
        public String getResText() {
            return this.resText;
        }

        @Nullable
        public InputStream getResFile() {
            return this.resFile;
        }

        @NotNull
        public Map<String, String> getResHead() {
            return this.resHead;
        }

        public void setTimestamp(@NotNull String timestamp) {
            if (timestamp == null) {
                throw new NullPointerException("timestamp is marked non-null but is null");
            }
            this.timestamp = timestamp;
        }

        public void setSignature(@NotNull String signature) {
            if (signature == null) {
                throw new NullPointerException("signature is marked non-null but is null");
            }
            this.signature = signature;
        }

        public void setDigest(@NotNull String digest) {
            if (digest == null) {
                throw new NullPointerException("digest is marked non-null but is null");
            }
            this.digest = digest;
        }

        public void setTerminal(@NotNull TerminalContext.Context terminal) {
            if (terminal == null) {
                throw new NullPointerException("terminal is marked non-null but is null");
            }
            this.terminal = terminal;
        }

        public void setReqPara(@NotNull Map<String, String> reqPara) {
            if (reqPara == null) {
                throw new NullPointerException("reqPara is marked non-null but is null");
            }
            this.reqPara = reqPara;
        }

        public void setReqBody(@NotNull String reqBody) {
            if (reqBody == null) {
                throw new NullPointerException("reqBody is marked non-null but is null");
            }
            this.reqBody = reqBody;
        }

        public void setReqFile(@NotNull Map<String, Part> reqFile) {
            if (reqFile == null) {
                throw new NullPointerException("reqFile is marked non-null but is null");
            }
            this.reqFile = reqFile;
        }

        public void setError(ApiError error) {
            this.error = error;
        }

        public void setResText(@NotNull String resText) {
            if (resText == null) {
                throw new NullPointerException("resText is marked non-null but is null");
            }
            this.resText = resText;
        }

        public void setResFile(@Nullable InputStream resFile) {
            this.resFile = resFile;
        }

        public void setResHead(@NotNull Map<String, String> resHead) {
            if (resHead == null) {
                throw new NullPointerException("resHead is marked non-null but is null");
            }
            this.resHead = resHead;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiEntity)) {
                return false;
            }
            ApiEntity other = (ApiEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            String this$digest = this.getDigest();
            String other$digest = other.getDigest();
            if (this$digest == null ? other$digest != null : !this$digest.equals(other$digest)) {
                return false;
            }
            TerminalContext.Context this$terminal = this.getTerminal();
            TerminalContext.Context other$terminal = other.getTerminal();
            if (this$terminal == null ? other$terminal != null : !this$terminal.equals(other$terminal)) {
                return false;
            }
            Map<String, String> this$reqPara = this.getReqPara();
            Map<String, String> other$reqPara = other.getReqPara();
            if (this$reqPara == null ? other$reqPara != null : !((Object)this$reqPara).equals(other$reqPara)) {
                return false;
            }
            String this$reqBody = this.getReqBody();
            String other$reqBody = other.getReqBody();
            if (this$reqBody == null ? other$reqBody != null : !this$reqBody.equals(other$reqBody)) {
                return false;
            }
            Map<String, Part> this$reqFile = this.getReqFile();
            Map<String, Part> other$reqFile = other.getReqFile();
            if (this$reqFile == null ? other$reqFile != null : !((Object)this$reqFile).equals(other$reqFile)) {
                return false;
            }
            ApiError this$error = this.getError();
            ApiError other$error = other.getError();
            if (this$error == null ? other$error != null : !((Object)((Object)this$error)).equals((Object)other$error)) {
                return false;
            }
            String this$resText = this.getResText();
            String other$resText = other.getResText();
            if (this$resText == null ? other$resText != null : !this$resText.equals(other$resText)) {
                return false;
            }
            InputStream this$resFile = this.getResFile();
            InputStream other$resFile = other.getResFile();
            if (this$resFile == null ? other$resFile != null : !this$resFile.equals(other$resFile)) {
                return false;
            }
            Map<String, String> this$resHead = this.getResHead();
            Map<String, String> other$resHead = other.getResHead();
            return !(this$resHead == null ? other$resHead != null : !((Object)this$resHead).equals(other$resHead));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ApiEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            String $digest = this.getDigest();
            result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
            TerminalContext.Context $terminal = this.getTerminal();
            result = result * 59 + ($terminal == null ? 43 : $terminal.hashCode());
            Map<String, String> $reqPara = this.getReqPara();
            result = result * 59 + ($reqPara == null ? 43 : ((Object)$reqPara).hashCode());
            String $reqBody = this.getReqBody();
            result = result * 59 + ($reqBody == null ? 43 : $reqBody.hashCode());
            Map<String, Part> $reqFile = this.getReqFile();
            result = result * 59 + ($reqFile == null ? 43 : ((Object)$reqFile).hashCode());
            ApiError $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)((Object)$error)).hashCode());
            String $resText = this.getResText();
            result = result * 59 + ($resText == null ? 43 : $resText.hashCode());
            InputStream $resFile = this.getResFile();
            result = result * 59 + ($resFile == null ? 43 : $resFile.hashCode());
            Map<String, String> $resHead = this.getResHead();
            result = result * 59 + ($resHead == null ? 43 : ((Object)$resHead).hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "AbstractApiAuthController.ApiEntity(timestamp=" + this.getTimestamp() + ", signature=" + this.getSignature() + ", digest=" + this.getDigest() + ", terminal=" + String.valueOf(this.getTerminal()) + ", reqPara=" + String.valueOf(this.getReqPara()) + ", reqBody=" + this.getReqBody() + ", reqFile=" + String.valueOf(this.getReqFile()) + ", error=" + String.valueOf((Object)this.getError()) + ", resText=" + this.getResText() + ", resFile=" + String.valueOf(this.getResFile()) + ", resHead=" + String.valueOf(this.getResHead()) + ")";
        }
    }

    public static enum ApiError {
        SignatureMissing,
        SignatureInvalid,
        DigestFileInvalid,
        DigestBodyInvalid;

    }
}

