/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.controller.mock;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.concur.DoubleKill;
import pro.fessional.wings.slardar.concur.FirstBlood;
import pro.fessional.wings.slardar.concur.Righter;
import pro.fessional.wings.slardar.concur.impl.RighterContext;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.warlock.mvc-mock")
public class MockSampleController {
    private static final Logger log = LoggerFactory.getLogger(MockSampleController.class);

    @Operation(summary="Get captcha image, handle by interceptor", description="# Usage\nThe GET is mainly used to get and refresh the CAPTCHA image.\nIf Accept contains `base64`, it returns the image in base64 format.\nsee mockCaptchaPost (POST method) and FirstBloodImageHandler\n## Params\n* @param quest-captcha-image - Captcha, to check captcha or get a new captcha\n## Returns\n* @return {200} captcha not matched, new image stream or base64 string\n* @return {200} captcha matched, empty body\n")
    @GetMapping(value={"${wings.warlock.urlmap.mock-captcha}"})
    @ResponseBody
    @FirstBlood
    public R<String> mockCaptchaGet(@RequestParam(value="quest-captcha-image") String quest, @RequestHeader(value="Accept", defaultValue="*") String accept) {
        return R.ok((String)("should NOT return this, Please use POST. Quest=" + quest + ", Accept=" + accept));
    }

    @Operation(summary="Get captcha image, handle by interceptor", description="# Usage\nThe client accesses this URL normally, and the captcha image is handled by the interceptor\n(1) Server returns json with 406(Not Acceptable) if CAPTCHA is required\n(2) Client gets Client-Ticket token in header and cookie and sends it every time\n(3) Client adds quest-captcha-image={vcode} after the URL to get the CAPTCHA image (can be used directly)\n(4) Client adds check-captcha-image={vcode} after the URL to submit the CAPTCHA\n(5) Server auto checks Client-Ticket and check-captcha-image\n## Params\n* @param data - test data, return if pass\n* @param check-captcha-image - submit captcha to check\n## Returns\n* @return {200} pass captcha, response by the protected URL\n* @return {406} trigger captcha, return `{\"success\":false,\"message\":\"need a verify code\"}`\n")
    @PostMapping(value={"${wings.warlock.urlmap.mock-captcha}"})
    @ResponseBody
    @FirstBlood
    public R<String> mockCaptchaPost(@RequestParam(value="data", required=false) String data, @RequestParam(value="check-captcha-image", required=false) String check) {
        return R.ok((String)("check=" + check), (Object)data);
    }

    @Operation(summary="Avoid double click, need 2 fast requests", description="# Usage\n(1) 1st request, set `sleep` second, and waiting for response\n(2) 2nd request during (1), will response 202(Accepted)\n## Params\n* @param sleep - sleep to simulate slow operation\n## Returns\n* @return {200 | Result(sleep)} return the sleep\n* @return {202 | Result(false, data)} in 2nd request, return task id\n")
    @PostMapping(value={"${wings.warlock.urlmap.mock-doubler}"})
    @ResponseBody
    @DoubleKill(principal=false, expression="#root.method")
    public R<Integer> mockDoubler(@RequestParam(value="sleep", required=false) Integer sleep) throws InterruptedException {
        if (sleep == null || sleep <= 0) {
            sleep = 30;
        }
        Thread.sleep((long)sleep.intValue() * 1000L);
        return R.okData((Object)sleep);
    }

    @Operation(summary="Tamper-proof, GET edit header (Right-Editor)", description="# Usage\n(1) GET the edit header, default key is `Right-Editor`\n(2) see mockRighterSave (POST method)\n## Params\n* @param data - data to audit\n## Returns\n* @return {200 | Result(data)} data\n")
    @GetMapping(value={"${wings.warlock.urlmap.mock-righter}"})
    @ResponseBody
    @Righter(value=false)
    public R<String> mockRighterView(@RequestParam(value="data") String data) {
        RighterContext.setAllow((Object)data);
        return R.okData((Object)data);
    }

    @Operation(summary="Tamper-proof, Submit changed data with Edit Header (Right-Editor)", description="# Usage\n(1) see GET\n(2) submit changed data with the Edit Header\n## Params\n* @param Right-Editor - Edit header, from the GET response\n## Returns\n* @return {200 | Result(data)} return the data send in GET\n* @return {409 | Result(false)} Right-Editor if audit fails\n")
    @PostMapping(value={"${wings.warlock.urlmap.mock-righter}"})
    @ResponseBody
    @Righter
    public R<String> mockRighterSave(@RequestHeader(value="Right-Editor") String hd) {
        String data = (String)RighterContext.getAudit((boolean)true);
        return R.ok((String)hd, (Object)data);
    }

    @Operation(summary="Echo test, output what you input", description="# Usage\nResponse the input status, header, cookie and RequestBody\n## Params\n* @param [status=200] - http status, default 200\n* @param [header] - http header k1=v1, `=` seperated\n* @param [cookie] - http cookie k1=v1, `=` seperated\n* @param [httponly] - cookie name that is httponly, e.g. k1\n* @param [secure] - cookie name that is https, e.g. k1\n* @param - request body\n## Returns\n* @return {200 | Result(data)} response what input\n")
    @PostMapping(value={"${wings.warlock.urlmap.mock-echo0o0}"})
    public void mockEcho(@RequestParam(value="status", required=false, defaultValue="200") int status, @RequestParam(value="header", required=false) Set<String> header, @RequestParam(value="cookie", required=false) Set<String> cookie, @RequestParam(value="httponly", required=false) Set<String> httponly, @RequestParam(value="secure", required=false) Set<String> secure, @RequestBody(required=false) String body, HttpServletResponse response) throws IOException {
        String[] kv;
        if (header != null) {
            for (String g : header) {
                kv = g.split("=", 2);
                if (kv.length != 2) continue;
                response.setHeader(kv[0].trim(), kv[1].trim());
            }
        }
        if (cookie != null) {
            if (httponly == null) {
                httponly = Collections.emptySet();
            }
            if (secure == null) {
                secure = Collections.emptySet();
            }
            for (String g : cookie) {
                kv = g.split("=", 2);
                if (kv.length != 2) continue;
                String k = kv[0].trim();
                Cookie ck = new Cookie(k, kv[1].trim());
                ck.setHttpOnly(httponly.contains(k));
                ck.setSecure(secure.contains(k));
                response.addCookie(ck);
            }
        }
        response.setStatus(status);
        if (body != null) {
            response.getWriter().print(body);
        }
    }
}

