/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.controller.user;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.session.Session;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.fessional.mirana.data.R;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.context.SecurityContextUtil;
import pro.fessional.wings.slardar.security.WingsUserDetails;
import pro.fessional.wings.slardar.session.SessionTokenEncoder;
import pro.fessional.wings.slardar.session.WingsSessionHelper;

@RestController
@ConditionalWingsEnabled(abs="wings.enabled.warlock.mvc-user")
public class AuthedUserController {
    private static final Logger log = LoggerFactory.getLogger(AuthedUserController.class);
    private WingsSessionHelper wingsSessionHelper;
    private SessionTokenEncoder sessionTokenEncoder;

    @Operation(summary="Get authed info of current user", description="# Usage\nOnly logined user\n## Returns\n* @return {200 | Result(Dto)} logined user and basis info\n* @return {200 | Result(false)} not logined and the URL without perm\n* @return {401} logined and no perm to the URL")
    @PostMapping(value={"${wings.warlock.urlmap.user-authed-user}"})
    public R<Dto> authedUser(HttpServletRequest request) {
        WingsUserDetails wd = SecurityContextUtil.getUserDetails((boolean)false);
        if (wd == null) {
            return R.NG();
        }
        Dto dto = new Dto();
        this.fillDetail(wd, dto);
        HttpSession session = request.getSession(false);
        if (session != null) {
            String sid = session.getId();
            if (this.sessionTokenEncoder != null) {
                sid = this.sessionTokenEncoder.encode(sid, request);
            }
            dto.setToken(sid);
        }
        return R.okData((Object)dto);
    }

    private void fillDetail(WingsUserDetails wd, Dto dto) {
        Enum at = wd.getAuthType();
        if (at != null) {
            dto.setAuthtype(at.name());
        }
        dto.setNickname(wd.getNickname());
        dto.setUsername(wd.getUsername());
        dto.setLocale(wd.getLocale().toLanguageTag());
        ZoneId zid = wd.getZoneId();
        dto.setZoneid(zid.getId());
        dto.setOffset(ZonedDateTime.now(zid).getOffset().getTotalSeconds());
    }

    @Operation(summary="Check the perm/role (case-insensitive) of the current user and returns the existing", description="# Usage\nalias takes precedence over perm, and auto logout if check fails.\n## Params\n* @param ins.alias - alias as map value for historical legacy\n* @param ins.perms - perm/role original name\n* @param ins.check - perm/role to check\n* @param ins.any - check any or all\n## Returns\n* @return {200 | Result(string[])} logined and perms\n* @return {200 | Result(false)} not logined and the URL without perm\n* @return {200 | Result(false,string[])} check fail, return failed perm and invalidate session\n* @return {401} logined and no perm to the URL")
    @PostMapping(value={"${wings.warlock.urlmap.user-authed-perm}"})
    public R<Set<String>> authedPerm(HttpServletRequest request, @RequestBody Ins ins) {
        Map<String, String> alias;
        Set<String> perms;
        WingsUserDetails wd = SecurityContextUtil.getUserDetails((boolean)false);
        if (wd == null) {
            return R.NG();
        }
        Set<String> ck = ins.getCheck();
        Set pm = wd.getAuthorities().stream().map(it -> it.getAuthority().toLowerCase()).collect(Collectors.toSet());
        if (ck != null && !ck.isEmpty()) {
            HashSet<String> ng = new HashSet<String>();
            for (String s : ck) {
                if (pm.contains(s.toLowerCase())) continue;
                ng.add(s);
            }
            int ns = ng.size();
            if (ns > 0 && !ins.any || ins.any && ns == ck.size()) {
                request.getSession().invalidate();
                return R.ngData(ng);
            }
        }
        if ((perms = ins.getPerms()) == null) {
            perms = Collections.emptySet();
        }
        if ((alias = ins.getAlias()) == null) {
            alias = Collections.emptyMap();
        }
        if (perms.isEmpty() && alias.isEmpty()) {
            return R.OK();
        }
        HashMap<String, String> ci = new HashMap<String, String>();
        for (String string : perms) {
            ci.put(string.toLowerCase(), string);
        }
        for (Map.Entry entry : alias.entrySet()) {
            ci.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
        }
        HashSet<String> res = new HashSet<String>();
        for (String p : pm) {
            String a = (String)ci.get(p);
            if (a == null) continue;
            res.add(a);
        }
        return R.okData(res);
    }

    @Operation(summary="List all session of current user", description="# Usage\nOnly the logined user\n## Returns\n* @return {200 | Result(Dto)} logined and basis info\n* @return {200 | Result(false)} not logined and the URL without perm\n* @return {401} logined and no perm to the URL")
    @PostMapping(value={"${wings.warlock.urlmap.user-list-session}"})
    public R<List<Ses>> listSession() {
        WingsUserDetails details = SecurityContextUtil.getUserDetails((boolean)false);
        if (details == null) {
            return R.NG();
        }
        List sessions = this.wingsSessionHelper.findByUserId(Long.valueOf(details.getUserId()));
        List sess = sessions.stream().map(it -> {
            Ses ses = new Ses();
            ses.setToken(it.getId());
            ses.setExpired(it.isExpired());
            ses.setLastAccess(it.getLastAccessedTime().atZone(details.getZoneId()));
            SecurityContext ctx = this.wingsSessionHelper.getSecurityContext((Session)it);
            WingsUserDetails dtl = SecurityContextUtil.getUserDetails((SecurityContext)ctx);
            if (dtl != null) {
                this.fillDetail(dtl, ses);
            }
            return ses;
        }).collect(Collectors.toList());
        return R.okData(sess);
    }

    @Operation(summary="drop the session of current user by id", description="# Usage\nOnly the logined user\n## Params\n* @param sid - sessionId/token to drop\n## Returns\n* @return {200 | Result(Dto)} logined\n* @return {200 | Result(false)} not logined and the URL without perm\n* @return {401} logined and no perm to the URL")
    @PostMapping(value={"${wings.warlock.urlmap.user-drop-session}"})
    public R<Boolean> dropSession(@RequestBody Sid sid) {
        boolean b = this.wingsSessionHelper.dropSession(sid.sid);
        return R.okData((Object)b);
    }

    @Autowired
    public void setWingsSessionHelper(WingsSessionHelper wingsSessionHelper) {
        this.wingsSessionHelper = wingsSessionHelper;
    }

    @Autowired(required=false)
    public void setSessionTokenEncoder(SessionTokenEncoder sessionTokenEncoder) {
        this.sessionTokenEncoder = sessionTokenEncoder;
    }

    @Schema(description="Basic info of login user")
    public static class Dto {
        @Schema(description="nickname", example="trydofor")
        private String nickname;
        @Schema(description="username", example="trydofor")
        private String username;
        @Schema(description="language, see java.util.Locale", example="zh-CN")
        private String locale;
        @Schema(description="timezone, see java.time.ZoneId", example="Asia/Shanghai")
        private String zoneid;
        @Schema(description="time offset in second to UTD", example="28800")
        private int offset;
        @Schema(description="auth type of current session", example="EMAIL")
        private String authtype;
        @Schema(description="auth token of current session", example="fd7a5475-bd3b-4086-96b0-b95d11cf1d3c")
        private String token;

        public String getNickname() {
            return this.nickname;
        }

        public String getUsername() {
            return this.username;
        }

        public String getLocale() {
            return this.locale;
        }

        public String getZoneid() {
            return this.zoneid;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getAuthtype() {
            return this.authtype;
        }

        public String getToken() {
            return this.token;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public void setZoneid(String zoneid) {
            this.zoneid = zoneid;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void setAuthtype(String authtype) {
            this.authtype = authtype;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dto)) {
                return false;
            }
            Dto other = (Dto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            String this$nickname = this.getNickname();
            String other$nickname = other.getNickname();
            if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$locale = this.getLocale();
            String other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
                return false;
            }
            String this$zoneid = this.getZoneid();
            String other$zoneid = other.getZoneid();
            if (this$zoneid == null ? other$zoneid != null : !this$zoneid.equals(other$zoneid)) {
                return false;
            }
            String this$authtype = this.getAuthtype();
            String other$authtype = other.getAuthtype();
            if (this$authtype == null ? other$authtype != null : !this$authtype.equals(other$authtype)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Dto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOffset();
            String $nickname = this.getNickname();
            result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
            String $zoneid = this.getZoneid();
            result = result * 59 + ($zoneid == null ? 43 : $zoneid.hashCode());
            String $authtype = this.getAuthtype();
            result = result * 59 + ($authtype == null ? 43 : $authtype.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "AuthedUserController.Dto(nickname=" + this.getNickname() + ", username=" + this.getUsername() + ", locale=" + this.getLocale() + ", zoneid=" + this.getZoneid() + ", offset=" + this.getOffset() + ", authtype=" + this.getAuthtype() + ", token=" + this.getToken() + ")";
        }
    }

    @Schema(description="Check the perm/role of login user")
    public static class Ins {
        @Schema(description="original as key, alias as value", example="{\"ROLE_SYSTEM\":\"OLD_SYSTEM\"}")
        private Map<String, String> alias;
        @Schema(description="set of perm/role", example="[\"ROLE_ADMIN\",\"ROLE_SYSTEM\"]")
        private Set<String> perms;
        @Schema(description="perm/role to check, if not contain (all/any), then invalidate session", example="[\"ROLE_ADMIN\"]")
        private Set<String> check;
        @Schema(description="check any or all", example="true")
        private boolean any = false;

        public Map<String, String> getAlias() {
            return this.alias;
        }

        public Set<String> getPerms() {
            return this.perms;
        }

        public Set<String> getCheck() {
            return this.check;
        }

        public boolean isAny() {
            return this.any;
        }

        public void setAlias(Map<String, String> alias) {
            this.alias = alias;
        }

        public void setPerms(Set<String> perms) {
            this.perms = perms;
        }

        public void setCheck(Set<String> check) {
            this.check = check;
        }

        public void setAny(boolean any) {
            this.any = any;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ins)) {
                return false;
            }
            Ins other = (Ins)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAny() != other.isAny()) {
                return false;
            }
            Map<String, String> this$alias = this.getAlias();
            Map<String, String> other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
                return false;
            }
            Set<String> this$perms = this.getPerms();
            Set<String> other$perms = other.getPerms();
            if (this$perms == null ? other$perms != null : !((Object)this$perms).equals(other$perms)) {
                return false;
            }
            Set<String> this$check = this.getCheck();
            Set<String> other$check = other.getCheck();
            return !(this$check == null ? other$check != null : !((Object)this$check).equals(other$check));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Ins;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAny() ? 79 : 97);
            Map<String, String> $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
            Set<String> $perms = this.getPerms();
            result = result * 59 + ($perms == null ? 43 : ((Object)$perms).hashCode());
            Set<String> $check = this.getCheck();
            result = result * 59 + ($check == null ? 43 : ((Object)$check).hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "AuthedUserController.Ins(alias=" + String.valueOf(this.getAlias()) + ", perms=" + String.valueOf(this.getPerms()) + ", check=" + String.valueOf(this.getCheck()) + ", any=" + this.isAny() + ")";
        }
    }

    public static class Sid {
        private String sid;

        public String getSid() {
            return this.sid;
        }

        public void setSid(String sid) {
            this.sid = sid;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sid)) {
                return false;
            }
            Sid other = (Sid)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sid = this.getSid();
            String other$sid = other.getSid();
            return !(this$sid == null ? other$sid != null : !this$sid.equals(other$sid));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Sid;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sid = this.getSid();
            result = result * 59 + ($sid == null ? 43 : $sid.hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "AuthedUserController.Sid(sid=" + this.getSid() + ")";
        }
    }

    @Schema(description="Session info of logined user")
    public static class Ses
    extends Dto {
        @Schema(description="Whether expired", example="true")
        private boolean expired;
        @Schema(description="Latest access time", example="true")
        private ZonedDateTime lastAccess;

        public boolean isExpired() {
            return this.expired;
        }

        public ZonedDateTime getLastAccess() {
            return this.lastAccess;
        }

        public void setExpired(boolean expired) {
            this.expired = expired;
        }

        public void setLastAccess(ZonedDateTime lastAccess) {
            this.lastAccess = lastAccess;
        }

        @Override
        @NotNull
        public String toString() {
            return "AuthedUserController.Ses(expired=" + this.isExpired() + ", lastAccess=" + String.valueOf(this.getLastAccess()) + ")";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ses)) {
                return false;
            }
            Ses other = (Ses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.isExpired() != other.isExpired()) {
                return false;
            }
            ZonedDateTime this$lastAccess = this.getLastAccess();
            ZonedDateTime other$lastAccess = other.getLastAccess();
            return !(this$lastAccess == null ? other$lastAccess != null : !((Object)this$lastAccess).equals(other$lastAccess));
        }

        @Override
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Ses;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.isExpired() ? 79 : 97);
            ZonedDateTime $lastAccess = this.getLastAccess();
            result = result * 59 + ($lastAccess == null ? 43 : ((Object)$lastAccess).hashCode());
            return result;
        }
    }
}

