/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.errorhandle;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.data.DataResult;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.data.R;
import pro.fessional.mirana.pain.CodeException;
import pro.fessional.mirana.pain.HttpStatusException;
import pro.fessional.mirana.text.JsonTemplate;
import pro.fessional.wings.slardar.context.LocaleZoneIdUtil;
import pro.fessional.wings.slardar.context.TerminalContextException;
import pro.fessional.wings.slardar.errcode.AuthnErrorEnum;
import pro.fessional.wings.slardar.errcode.AuthzErrorEnum;
import pro.fessional.wings.slardar.webmvc.SimpleExceptionResolver;
import pro.fessional.wings.slardar.webmvc.SimpleResponse;

public class DefaultExceptionResolver
extends SimpleExceptionResolver<Exception> {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionResolver.class);
    protected final MessageSource messageSource;
    protected final ObjectMapper objectMapper;

    public DefaultExceptionResolver(SimpleResponse defaultResponse, MessageSource messageSource, ObjectMapper objectMapper) {
        super(defaultResponse);
        this.messageSource = messageSource;
        this.objectMapper = objectMapper;
    }

    protected SimpleResponse resolve(Exception exception) {
        try {
            for (Throwable tmp = exception; tmp != null; tmp = tmp.getCause()) {
                if (tmp instanceof HttpStatusException) {
                    HttpStatusException ex = (HttpStatusException)tmp;
                    return this.handle(ex);
                }
                if (tmp instanceof TerminalContextException) {
                    TerminalContextException ex = (TerminalContextException)tmp;
                    return this.handleUnauthorized((Exception)ex);
                }
                if (tmp instanceof CodeException) {
                    CodeException ex = (CodeException)tmp;
                    return this.handle(ex);
                }
                if (tmp instanceof DataResult) {
                    DataResult ex = (DataResult)tmp;
                    return this.handle(ex);
                }
                if (tmp instanceof AuthenticationException) {
                    AuthenticationException ex = (AuthenticationException)tmp;
                    return this.handleUnauthorized((Exception)ex);
                }
                if (!(tmp instanceof AccessDeniedException)) continue;
                AccessDeniedException ex = (AccessDeniedException)tmp;
                return this.handleAccessDenied((Exception)ex);
            }
        }
        catch (Exception e) {
            DummyBlock.ignore((Throwable)e);
        }
        log.error("unhandled exception, response default", (Throwable)exception);
        return this.defaultResponse;
    }

    protected SimpleResponse handle(DataResult<?> dre) {
        R ng = R.ng((String)dre.getMessage(), (String)dre.getCode(), (Object)dre.getData());
        String body = this.objectMapper.writeValueAsString((Object)ng);
        return new SimpleResponse(this.defaultResponse.getHttpStatus(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handle(HttpStatusException cex) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            obj.putVal("code", (Object)cex.getCode());
            obj.putVal("message", (Object)this.resolveMessage((CodeException)cex));
        });
        return new SimpleResponse(cex.getStatus(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handle(CodeException cex) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            obj.putVal("code", (Object)cex.getCode());
            obj.putVal("message", (Object)this.resolveMessage(cex));
        });
        return new SimpleResponse(this.defaultResponse.getHttpStatus(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handleUnauthorized(Exception ex) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            String code = AuthnErrorEnum.Unauthorized.getCode();
            obj.putVal("code", (Object)code);
            obj.putVal("message", (Object)this.resolveMessage(code, new Object[0]));
        });
        return new SimpleResponse(HttpStatus.UNAUTHORIZED.value(), this.defaultResponse.getContentType(), body);
    }

    protected SimpleResponse handleAccessDenied(Exception ex) {
        String body = JsonTemplate.obj(obj -> {
            obj.putVal("success", (Object)false);
            String code = AuthzErrorEnum.AccessDenied.getCode();
            obj.putVal("code", (Object)code);
            obj.putVal("message", (Object)this.resolveMessage(code, new Object[0]));
        });
        return new SimpleResponse(HttpStatus.FORBIDDEN.value(), this.defaultResponse.getContentType(), body);
    }

    protected String resolveMessage(CodeException ce) {
        String code = ce.getI18nCode();
        if (code == null) {
            code = ce.getMessage();
        }
        if (code == null || code.isEmpty()) {
            return null;
        }
        return this.resolveMessage(code, Null.notNull((Object[])ce.getI18nArgs()));
    }

    protected String resolveMessage(String code, Object ... args) {
        Locale locale = (Locale)LocaleZoneIdUtil.LocaleNonnull.get();
        return this.messageSource.getMessage(code, args, locale);
    }
}

