/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.util.StringUtils;
import pro.fessional.wings.slardar.servlet.response.ResponseHelper;
import pro.fessional.wings.slardar.spring.prop.SlardarSessionProp;
import pro.fessional.wings.warlock.security.SafeHttpHelper;
import pro.fessional.wings.warlock.security.handler.NonceLoginSuccessHandler;
import pro.fessional.wings.warlock.spring.prop.WarlockJustAuthProp;
import pro.fessional.wings.warlock.spring.prop.WarlockSecurityProp;

public class LoginSuccessHandler
extends NonceLoginSuccessHandler
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(LoginSuccessHandler.class);
    protected WarlockSecurityProp warlockSecurityProp;
    protected WarlockJustAuthProp warlockJustAuthProp;
    protected SlardarSessionProp slardarSessionProp;

    @Override
    protected void onResponse(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @NotNull Authentication aun, @Nullable String sid, long uid, @Nullable String state) throws IOException, ServletException {
        if (state != null && !state.isEmpty()) {
            if (state.startsWith("/") || this.isSafeRedirect(state)) {
                log.debug("redirect to {}", (Object)state);
                res.sendRedirect(state);
            } else {
                this.writeResponseBody(state, req, res, aun, sid, uid, state);
            }
        } else if (this.warlockSecurityProp.isLoginSuccessRedirect()) {
            super.onResponse(req, res, aun, sid, uid, state);
        } else {
            this.writeResponseBody(this.warlockSecurityProp.getLoginSuccessBody(), req, res, aun, sid, uid, state);
        }
    }

    protected boolean isSafeRedirect(String state) {
        return SafeHttpHelper.isSafeRedirect(state, this.warlockJustAuthProp.getSafeHost());
    }

    protected void writeResponseBody(@NotNull String body, @NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @NotNull Authentication aun, @Nullable String sid, long uid, @Nullable String state) {
        ResponseHelper.writeBodyUtf8((HttpServletResponse)res, (String)body);
    }

    public void afterPropertiesSet() {
        if (this.warlockSecurityProp != null && this.warlockSecurityProp.isLoginSuccessRedirect()) {
            String ld = this.warlockSecurityProp.getLoginSuccessRedirectDefault();
            if (StringUtils.hasText((String)ld)) {
                this.setDefaultTargetUrl(ld);
            }
            String lp = this.warlockSecurityProp.getLoginSuccessRedirectParam();
            if (StringUtils.hasText((String)ld)) {
                this.setTargetUrlParameter(lp);
            }
        }
    }

    @Autowired
    public void setWarlockSecurityProp(WarlockSecurityProp warlockSecurityProp) {
        this.warlockSecurityProp = warlockSecurityProp;
    }

    @Autowired
    public void setWarlockJustAuthProp(WarlockJustAuthProp warlockJustAuthProp) {
        this.warlockJustAuthProp = warlockJustAuthProp;
    }

    @Autowired
    public void setSlardarSessionProp(SlardarSessionProp slardarSessionProp) {
        this.slardarSessionProp = slardarSessionProp;
    }
}

