/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import pro.fessional.wings.slardar.context.SecurityContextUtil;
import pro.fessional.wings.warlock.security.justauth.AuthStateBuilder;
import pro.fessional.wings.warlock.security.session.NonceTokenSessionHelper;

public class NonceLoginSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(NonceLoginSuccessHandler.class);
    protected AuthStateBuilder authStateBuilder;

    public final void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        HttpSession session = request.getSession(false);
        String sid = null;
        long uid = SecurityContextUtil.getUserId();
        String state = request.getParameter("state");
        if (session != null) {
            sid = session.getId();
            if (state != null) {
                NonceTokenSessionHelper.bindNonceSession(state, sid);
                log.debug("parse client state={}, uid={}", (Object)state, (Object)uid);
            }
        }
        this.onResponse(request, response, authentication, sid, uid, this.authStateBuilder.parseState(request));
    }

    protected void onResponse(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @NotNull Authentication aun, @Nullable String sid, long uid, @Nullable String state) throws ServletException, IOException {
        super.onAuthenticationSuccess(req, res, aun);
    }

    @Autowired
    public void setAuthStateBuilder(AuthStateBuilder authStateBuilder) {
        this.authStateBuilder = authStateBuilder;
    }
}

