/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.justauth;

import com.xkcoding.http.config.HttpConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;
import me.zhyd.oauth.config.AuthConfig;
import pro.fessional.mirana.text.StringTemplate;

public class AuthConfigWrapper
extends AuthConfig {
    public static final String RedirectUriHost = "{host}";
    public static final String RedirectUriScheme = "{scheme}";
    public static final String RedirectUriAuthType = "{authType}";
    public static final String RedirectUriAuthZone = "{authZone}";
    private final AuthConfig config;
    private final HttpServletRequest request;
    private final Set<String> safeHost;

    public static AuthConfig tryWrap(AuthConfig config, Set<String> safeHost) {
        String uri = config.getRedirectUri();
        if (uri != null && (uri.contains(RedirectUriHost) || uri.contains(RedirectUriScheme) || uri.contains(RedirectUriAuthType) || uri.contains(RedirectUriAuthZone))) {
            return new AuthConfigWrapper(config, safeHost, null);
        }
        return config;
    }

    public AuthConfigWrapper(AuthConfig config, Set<String> safeHost, HttpServletRequest request) {
        this.config = config;
        this.request = request;
        this.safeHost = safeHost;
    }

    public AuthConfig wrap(HttpServletRequest request) {
        return new AuthConfigWrapper(this.config, this.safeHost, request);
    }

    public String getRedirectUri() {
        String key;
        String uri = this.config.getRedirectUri();
        if (this.request == null) {
            return uri;
        }
        String host = this.request.getHeader("Host");
        if (this.safeHost != null && (key = this.request.getParameter("host")) != null && this.safeHost.contains(key)) {
            host = key;
        }
        return StringTemplate.dyn((String)uri).bindStr(RedirectUriHost, (Object)host).bindStr(RedirectUriScheme, (Object)this.request.getScheme()).bindStr(RedirectUriAuthType, (Object)this.request.getParameter("authType")).bindStr(RedirectUriAuthZone, (Object)this.request.getParameter("authZone")).toString();
    }

    public String getAuthServerId() {
        return this.config.getAuthServerId();
    }

    public String getClientId() {
        return this.config.getClientId();
    }

    public String getClientSecret() {
        return this.config.getClientSecret();
    }

    @Deprecated
    public String getAlipayPublicKey() {
        return this.config.getAlipayPublicKey();
    }

    public boolean isUnionId() {
        return this.config.isUnionId();
    }

    public String getStackOverflowKey() {
        return this.config.getStackOverflowKey();
    }

    public String getAgentId() {
        return this.config.getAgentId();
    }

    public String getUsertype() {
        return this.config.getUsertype();
    }

    public String getDomainPrefix() {
        return this.config.getDomainPrefix();
    }

    public HttpConfig getHttpConfig() {
        return this.config.getHttpConfig();
    }

    public boolean isIgnoreCheckState() {
        return this.config.isIgnoreCheckState();
    }

    public List<String> getScopes() {
        return this.config.getScopes();
    }

    public String getDeviceId() {
        return this.config.getDeviceId();
    }

    public Integer getClientOsType() {
        return this.config.getClientOsType();
    }

    public String getPackId() {
        return this.config.getPackId();
    }

    public boolean isPkce() {
        return this.config.isPkce();
    }

    public boolean isIgnoreCheckRedirectUri() {
        return this.config.isIgnoreCheckRedirectUri();
    }

    public String getTenantId() {
        return this.config.getTenantId();
    }

    public void setClientId(String clientId) {
        this.config.setClientId(clientId);
    }

    public void setClientSecret(String clientSecret) {
        this.config.setClientSecret(clientSecret);
    }

    public void setRedirectUri(String redirectUri) {
        this.config.setRedirectUri(redirectUri);
    }

    @Deprecated
    public void setAlipayPublicKey(String alipayPublicKey) {
        this.config.setAlipayPublicKey(alipayPublicKey);
    }

    public void setUnionId(boolean unionId) {
        this.config.setUnionId(unionId);
    }

    public void setStackOverflowKey(String stackOverflowKey) {
        this.config.setStackOverflowKey(stackOverflowKey);
    }

    public void setAgentId(String agentId) {
        this.config.setAgentId(agentId);
    }

    public void setUsertype(String usertype) {
        this.config.setUsertype(usertype);
    }

    public void setDomainPrefix(String domainPrefix) {
        this.config.setDomainPrefix(domainPrefix);
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.config.setHttpConfig(httpConfig);
    }

    public void setIgnoreCheckState(boolean ignoreCheckState) {
        this.config.setIgnoreCheckState(ignoreCheckState);
    }

    public void setScopes(List<String> scopes) {
        this.config.setScopes(scopes);
    }

    public void setDeviceId(String deviceId) {
        this.config.setDeviceId(deviceId);
    }

    public void setClientOsType(Integer clientOsType) {
        this.config.setClientOsType(clientOsType);
    }

    public void setPackId(String packId) {
        this.config.setPackId(packId);
    }

    public void setPkce(boolean pkce) {
        this.config.setPkce(pkce);
    }

    public void setAuthServerId(String authServerId) {
        this.config.setAuthServerId(authServerId);
    }

    public void setIgnoreCheckRedirectUri(boolean ignoreCheckRedirectUri) {
        this.config.setIgnoreCheckRedirectUri(ignoreCheckRedirectUri);
    }

    public void setTenantId(String tenantId) {
        this.config.setTenantId(tenantId);
    }

    private static interface DelegateExclude {
        public String getRedirectUri();
    }
}

