/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.justauth;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthAlipayRequest;
import me.zhyd.oauth.request.AuthAliyunRequest;
import me.zhyd.oauth.request.AuthBaiduRequest;
import me.zhyd.oauth.request.AuthCodingRequest;
import me.zhyd.oauth.request.AuthDingTalkRequest;
import me.zhyd.oauth.request.AuthDouyinRequest;
import me.zhyd.oauth.request.AuthElemeRequest;
import me.zhyd.oauth.request.AuthFacebookRequest;
import me.zhyd.oauth.request.AuthFeishuRequest;
import me.zhyd.oauth.request.AuthGiteeRequest;
import me.zhyd.oauth.request.AuthGithubRequest;
import me.zhyd.oauth.request.AuthGitlabRequest;
import me.zhyd.oauth.request.AuthGoogleRequest;
import me.zhyd.oauth.request.AuthHuaweiRequest;
import me.zhyd.oauth.request.AuthJdRequest;
import me.zhyd.oauth.request.AuthKujialeRequest;
import me.zhyd.oauth.request.AuthLinkedinRequest;
import me.zhyd.oauth.request.AuthMeituanRequest;
import me.zhyd.oauth.request.AuthMiRequest;
import me.zhyd.oauth.request.AuthMicrosoftRequest;
import me.zhyd.oauth.request.AuthOschinaRequest;
import me.zhyd.oauth.request.AuthPinterestRequest;
import me.zhyd.oauth.request.AuthQqRequest;
import me.zhyd.oauth.request.AuthRenrenRequest;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.request.AuthStackOverflowRequest;
import me.zhyd.oauth.request.AuthTaobaoRequest;
import me.zhyd.oauth.request.AuthTeambitionRequest;
import me.zhyd.oauth.request.AuthToutiaoRequest;
import me.zhyd.oauth.request.AuthTwitterRequest;
import me.zhyd.oauth.request.AuthWeChatEnterpriseQrcodeRequest;
import me.zhyd.oauth.request.AuthWeChatEnterpriseWebRequest;
import me.zhyd.oauth.request.AuthWeChatMpRequest;
import me.zhyd.oauth.request.AuthWeChatOpenRequest;
import me.zhyd.oauth.request.AuthWeiboRequest;
import me.zhyd.oauth.request.AuthXmlyRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import pro.fessional.mirana.flow.FlowEnum;
import pro.fessional.wings.slardar.security.impl.ComboWingsAuthDetailsSource;
import pro.fessional.wings.slardar.security.impl.DefaultWingsAuthDetails;
import pro.fessional.wings.warlock.security.justauth.AuthConfigWrapper;
import pro.fessional.wings.warlock.security.session.NonceTokenSessionHelper;

public class JustAuthRequestBuilder
implements ComboWingsAuthDetailsSource.Combo<DefaultWingsAuthDetails> {
    private static final Logger log = LoggerFactory.getLogger(JustAuthRequestBuilder.class);
    public static final int ORDER = -30000000;
    private int order = -30000000;
    private Map<Enum<?>, AuthConfig> authConfigMap = Collections.emptyMap();
    private AuthStateCache authStateCache;
    private List<SuccessHandler> successHandlers = new ArrayList<SuccessHandler>();

    public DefaultWingsAuthDetails buildDetails(@NotNull Enum<?> authType, @NotNull HttpServletRequest request) {
        AuthRequest ar = this.buildRequest(authType, request);
        if (ar == null) {
            return null;
        }
        AuthCallback callback = new AuthCallback();
        callback.setAuth_code(request.getParameter("auth_code"));
        callback.setAuthorization_code(request.getParameter("authorization_code"));
        callback.setCode(request.getParameter("code"));
        callback.setOauth_token(request.getParameter("oauth_token"));
        callback.setOauth_verifier(request.getParameter("oauth_verifier"));
        String state = request.getParameter("state");
        callback.setState(state);
        try {
            AuthResponse response = ar.login(callback);
            Object data = response.getData();
            if (data instanceof AuthUser) {
                SuccessHandler hdl;
                FlowEnum flw;
                AuthUser authUser = (AuthUser)data;
                DefaultWingsAuthDetails detail = new DefaultWingsAuthDetails(data);
                Iterator<SuccessHandler> iterator = this.successHandlers.iterator();
                while (iterator.hasNext() && (flw = (hdl = iterator.next()).handle(authType, request, authUser, detail)) != FlowEnum.Break) {
                    if (flw == FlowEnum.Return) {
                        return detail;
                    }
                    if (flw != FlowEnum.Throw) continue;
                    throw new InternalAuthenticationServiceException(hdl.getClass().getName() + " want throw");
                }
                return detail;
            }
            log.warn("failed to Oauth authType={}, response type={}", authType, (Object)(data == null ? "null" : data.getClass().getName()));
            throw new InsufficientAuthenticationException("failed to Oauth authType=" + String.valueOf(authType));
        }
        catch (InternalAuthenticationServiceException e) {
            throw e;
        }
        catch (Exception e) {
            NonceTokenSessionHelper.invalidNonce(state);
            throw e;
        }
    }

    public AuthRequest buildRequest(Enum<?> authType, HttpServletRequest request) {
        if (!(authType instanceof AuthSource)) {
            return null;
        }
        AuthConfig config = this.authConfigMap.get(authType);
        if (config == null) {
            return null;
        }
        if (config instanceof AuthConfigWrapper) {
            config = ((AuthConfigWrapper)config).wrap(request);
        }
        return switch ((AuthDefaultSource)authType) {
            case AuthDefaultSource.GITHUB -> new AuthGithubRequest(config, this.authStateCache);
            case AuthDefaultSource.WEIBO -> new AuthWeiboRequest(config, this.authStateCache);
            case AuthDefaultSource.GITEE -> new AuthGiteeRequest(config, this.authStateCache);
            case AuthDefaultSource.DINGTALK -> new AuthDingTalkRequest(config, this.authStateCache);
            case AuthDefaultSource.BAIDU -> new AuthBaiduRequest(config, this.authStateCache);
            case AuthDefaultSource.CODING -> new AuthCodingRequest(config, this.authStateCache);
            case AuthDefaultSource.OSCHINA -> new AuthOschinaRequest(config, this.authStateCache);
            case AuthDefaultSource.ALIPAY -> new AuthAlipayRequest(config, this.authStateCache);
            case AuthDefaultSource.QQ -> new AuthQqRequest(config, this.authStateCache);
            case AuthDefaultSource.WECHAT_MP -> new AuthWeChatMpRequest(config, this.authStateCache);
            case AuthDefaultSource.WECHAT_OPEN -> new AuthWeChatOpenRequest(config, this.authStateCache);
            case AuthDefaultSource.WECHAT_ENTERPRISE -> new AuthWeChatEnterpriseQrcodeRequest(config, this.authStateCache);
            case AuthDefaultSource.WECHAT_ENTERPRISE_WEB -> new AuthWeChatEnterpriseWebRequest(config, this.authStateCache);
            case AuthDefaultSource.TAOBAO -> new AuthTaobaoRequest(config, this.authStateCache);
            case AuthDefaultSource.GOOGLE -> new AuthGoogleRequest(config, this.authStateCache);
            case AuthDefaultSource.FACEBOOK -> new AuthFacebookRequest(config, this.authStateCache);
            case AuthDefaultSource.DOUYIN -> new AuthDouyinRequest(config, this.authStateCache);
            case AuthDefaultSource.LINKEDIN -> new AuthLinkedinRequest(config, this.authStateCache);
            case AuthDefaultSource.MICROSOFT -> new AuthMicrosoftRequest(config, this.authStateCache);
            case AuthDefaultSource.MI -> new AuthMiRequest(config, this.authStateCache);
            case AuthDefaultSource.TOUTIAO -> new AuthToutiaoRequest(config, this.authStateCache);
            case AuthDefaultSource.TEAMBITION -> new AuthTeambitionRequest(config, this.authStateCache);
            case AuthDefaultSource.RENREN -> new AuthRenrenRequest(config, this.authStateCache);
            case AuthDefaultSource.PINTEREST -> new AuthPinterestRequest(config, this.authStateCache);
            case AuthDefaultSource.STACK_OVERFLOW -> new AuthStackOverflowRequest(config, this.authStateCache);
            case AuthDefaultSource.HUAWEI -> new AuthHuaweiRequest(config, this.authStateCache);
            case AuthDefaultSource.GITLAB -> new AuthGitlabRequest(config, this.authStateCache);
            case AuthDefaultSource.KUJIALE -> new AuthKujialeRequest(config, this.authStateCache);
            case AuthDefaultSource.ELEME -> new AuthElemeRequest(config, this.authStateCache);
            case AuthDefaultSource.MEITUAN -> new AuthMeituanRequest(config, this.authStateCache);
            case AuthDefaultSource.TWITTER -> new AuthTwitterRequest(config, this.authStateCache);
            case AuthDefaultSource.FEISHU -> new AuthFeishuRequest(config, this.authStateCache);
            case AuthDefaultSource.JD -> new AuthJdRequest(config, this.authStateCache);
            case AuthDefaultSource.ALIYUN -> new AuthAliyunRequest(config, this.authStateCache);
            case AuthDefaultSource.XMLY -> new AuthXmlyRequest(config, this.authStateCache);
            default -> null;
        };
    }

    public int getOrder() {
        return this.order;
    }

    public Map<Enum<?>, AuthConfig> getAuthConfigMap() {
        return this.authConfigMap;
    }

    public AuthStateCache getAuthStateCache() {
        return this.authStateCache;
    }

    public List<SuccessHandler> getSuccessHandlers() {
        return this.successHandlers;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setAuthConfigMap(Map<Enum<?>, AuthConfig> authConfigMap) {
        this.authConfigMap = authConfigMap;
    }

    @Autowired
    public void setAuthStateCache(AuthStateCache authStateCache) {
        this.authStateCache = authStateCache;
    }

    @Autowired
    @Lazy
    public void setSuccessHandlers(List<SuccessHandler> successHandlers) {
        this.successHandlers = successHandlers;
    }

    public static interface SuccessHandler
    extends Ordered {
        default public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public FlowEnum handle(@NotNull Enum<?> var1, @NotNull HttpServletRequest var2, AuthUser var3, DefaultWingsAuthDetails var4);
    }
}

