/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.security.userdetails;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.model.AuthUser;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.wings.slardar.fastjson.FastJsonHelper;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.warlock.enums.autogen.UserGender;
import pro.fessional.wings.warlock.enums.autogen.UserStatus;
import pro.fessional.wings.warlock.service.auth.impl.DefaultUserAuthnAutoReg;
import pro.fessional.wings.warlock.service.user.WarlockUserAuthnService;
import pro.fessional.wings.warlock.service.user.WarlockUserBasisService;

public class JustAuthUserAuthnAutoReg
extends DefaultUserAuthnAutoReg {
    private static final Logger log = LoggerFactory.getLogger(JustAuthUserAuthnAutoReg.class);

    @Override
    protected Long beforeSave(WarlockUserBasisService.Basis basis, String username, WingsAuthDetails details) {
        AuthUser user = (AuthUser)details.getRealData();
        AssertArgs.notNull((Object)user, (String)"need JustAuth User");
        basis.setNickname(user.getNickname());
        basis.setAvatar(user.getAvatar());
        AuthUserGender aug = user.getGender();
        if (aug == AuthUserGender.FEMALE) {
            basis.setGender(UserGender.FEMALE);
        } else if (aug == AuthUserGender.MALE) {
            basis.setGender(UserGender.MALE);
        } else {
            basis.setGender(UserGender.UNKNOWN);
        }
        basis.setRemark(user.getRemark());
        basis.setStatus(UserStatus.ACTIVE);
        log.debug("nickName={}, Gender={}", (Object)user.getNickname(), (Object)aug);
        return null;
    }

    @Override
    protected Long beforeSave(WarlockUserAuthnService.Authn authn, String username, WingsAuthDetails details, long userId) {
        AuthUser user = (AuthUser)details.getRealData();
        AssertArgs.notNull((Object)user, (String)"need JustAuth User");
        authn.setUsername(user.getUuid());
        authn.setExtraPara(JSON.toJSONString((Object)user.getToken(), (JSONWriter.Feature[])FastJsonHelper.DefaultWriter()));
        authn.setExtraUser(JSON.toJSONString((Object)user.getRawUserInfo(), (JSONWriter.Feature[])FastJsonHelper.DefaultWriter()));
        log.debug("uuid={}, userId={}", (Object)user.getUuid(), (Object)userId);
        return null;
    }

    @Override
    public boolean accept(@NotNull Enum<?> authType, String username, WingsAuthDetails details) {
        return details.getRealData() instanceof AuthUser;
    }
}

