/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.warlock.service.auth;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.wings.faceless.convention.EmptySugar;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.security.WingsAuthDetails;
import pro.fessional.wings.slardar.security.impl.DefaultWingsUserDetails;
import pro.fessional.wings.warlock.enums.autogen.UserStatus;

public interface WarlockAuthnService {
    @Nullable
    public Details load(@NotNull Enum<?> var1, String var2);

    @Nullable
    public Details load(@NotNull Enum<?> var1, long var2);

    @Nullable
    public Details register(@NotNull Enum<?> var1, String var2, WingsAuthDetails var3);

    public void auth(DefaultWingsUserDetails var1, Details var2);

    public void onSuccess(@NotNull Enum<?> var1, long var2, String var4);

    public void onFailure(@NotNull Enum<?> var1, String var2, String var3);

    public static enum Jane {
        AutoSave,
        Success,
        Failure;

    }

    public static class Details {
        private long userId;
        private String nickname;
        private Locale locale = TerminalContext.defaultLocale();
        private ZoneId zoneId = TerminalContext.defaultZoneId();
        private UserStatus status;
        private Enum<?> authType;
        private String username;
        private String password;
        private String passsalt;
        private LocalDateTime expiredDt;

        public boolean isUninit() {
            return EmptySugar.asEmptyValue((LocalDateTime)this.expiredDt);
        }

        @NotNull
        public DetailsBuilder toBuilder() {
            return new DetailsBuilder().userId(this.userId).nickname(this.nickname).locale(this.locale).zoneId(this.zoneId).status(this.status).authType(this.authType).username(this.username).password(this.password).passsalt(this.passsalt).expiredDt(this.expiredDt);
        }

        public long getUserId() {
            return this.userId;
        }

        public String getNickname() {
            return this.nickname;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public UserStatus getStatus() {
            return this.status;
        }

        public Enum<?> getAuthType() {
            return this.authType;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPasssalt() {
            return this.passsalt;
        }

        public LocalDateTime getExpiredDt() {
            return this.expiredDt;
        }

        public void setUserId(long userId) {
            this.userId = userId;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public void setStatus(UserStatus status) {
            this.status = status;
        }

        public void setAuthType(Enum<?> authType) {
            this.authType = authType;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setPasssalt(String passsalt) {
            this.passsalt = passsalt;
        }

        public void setExpiredDt(LocalDateTime expiredDt) {
            this.expiredDt = expiredDt;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Details)) {
                return false;
            }
            Details other = (Details)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUserId() != other.getUserId()) {
                return false;
            }
            String this$nickname = this.getNickname();
            String other$nickname = other.getNickname();
            if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
                return false;
            }
            Locale this$locale = this.getLocale();
            Locale other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
                return false;
            }
            ZoneId this$zoneId = this.getZoneId();
            ZoneId other$zoneId = other.getZoneId();
            if (this$zoneId == null ? other$zoneId != null : !((Object)this$zoneId).equals(other$zoneId)) {
                return false;
            }
            UserStatus this$status = this.getStatus();
            UserStatus other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            Enum<?> this$authType = this.getAuthType();
            Enum<?> other$authType = other.getAuthType();
            if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$passsalt = this.getPasssalt();
            String other$passsalt = other.getPasssalt();
            if (this$passsalt == null ? other$passsalt != null : !this$passsalt.equals(other$passsalt)) {
                return false;
            }
            LocalDateTime this$expiredDt = this.getExpiredDt();
            LocalDateTime other$expiredDt = other.getExpiredDt();
            return !(this$expiredDt == null ? other$expiredDt != null : !((Object)this$expiredDt).equals(other$expiredDt));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Details;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $userId = this.getUserId();
            result = result * 59 + (int)($userId >>> 32 ^ $userId);
            String $nickname = this.getNickname();
            result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
            Locale $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
            ZoneId $zoneId = this.getZoneId();
            result = result * 59 + ($zoneId == null ? 43 : ((Object)$zoneId).hashCode());
            UserStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            Enum<?> $authType = this.getAuthType();
            result = result * 59 + ($authType == null ? 43 : $authType.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $passsalt = this.getPasssalt();
            result = result * 59 + ($passsalt == null ? 43 : $passsalt.hashCode());
            LocalDateTime $expiredDt = this.getExpiredDt();
            result = result * 59 + ($expiredDt == null ? 43 : ((Object)$expiredDt).hashCode());
            return result;
        }

        @NotNull
        public String toString() {
            return "WarlockAuthnService.Details(userId=" + this.getUserId() + ", nickname=" + this.getNickname() + ", locale=" + String.valueOf(this.getLocale()) + ", zoneId=" + String.valueOf(this.getZoneId()) + ", status=" + String.valueOf(this.getStatus()) + ", authType=" + String.valueOf(this.getAuthType()) + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", passsalt=" + this.getPasssalt() + ", expiredDt=" + String.valueOf(this.getExpiredDt()) + ")";
        }

        public Details() {
        }

        public Details(long userId, String nickname, Locale locale, ZoneId zoneId, UserStatus status, Enum<?> authType, String username, String password, String passsalt, LocalDateTime expiredDt) {
            this.userId = userId;
            this.nickname = nickname;
            this.locale = locale;
            this.zoneId = zoneId;
            this.status = status;
            this.authType = authType;
            this.username = username;
            this.password = password;
            this.passsalt = passsalt;
            this.expiredDt = expiredDt;
        }

        public static class DetailsBuilder {
            private long userId;
            private String nickname;
            private Locale locale;
            private ZoneId zoneId;
            private UserStatus status;
            private Enum<?> authType;
            private String username;
            private String password;
            private String passsalt;
            private LocalDateTime expiredDt;

            DetailsBuilder() {
            }

            @NotNull
            public DetailsBuilder userId(long userId) {
                this.userId = userId;
                return this;
            }

            @NotNull
            public DetailsBuilder nickname(String nickname) {
                this.nickname = nickname;
                return this;
            }

            @NotNull
            public DetailsBuilder locale(Locale locale) {
                this.locale = locale;
                return this;
            }

            @NotNull
            public DetailsBuilder zoneId(ZoneId zoneId) {
                this.zoneId = zoneId;
                return this;
            }

            @NotNull
            public DetailsBuilder status(UserStatus status) {
                this.status = status;
                return this;
            }

            @NotNull
            public DetailsBuilder authType(Enum<?> authType) {
                this.authType = authType;
                return this;
            }

            @NotNull
            public DetailsBuilder username(String username) {
                this.username = username;
                return this;
            }

            @NotNull
            public DetailsBuilder password(String password) {
                this.password = password;
                return this;
            }

            @NotNull
            public DetailsBuilder passsalt(String passsalt) {
                this.passsalt = passsalt;
                return this;
            }

            @NotNull
            public DetailsBuilder expiredDt(LocalDateTime expiredDt) {
                this.expiredDt = expiredDt;
                return this;
            }

            @NotNull
            public Details build() {
                return new Details(this.userId, this.nickname, this.locale, this.zoneId, this.status, this.authType, this.username, this.password, this.passsalt, this.expiredDt);
            }

            @NotNull
            public String toString() {
                return "WarlockAuthnService.Details.DetailsBuilder(userId=" + this.userId + ", nickname=" + this.nickname + ", locale=" + String.valueOf(this.locale) + ", zoneId=" + String.valueOf(this.zoneId) + ", status=" + String.valueOf(this.status) + ", authType=" + String.valueOf(this.authType) + ", username=" + this.username + ", password=" + this.password + ", passsalt=" + this.passsalt + ", expiredDt=" + String.valueOf(this.expiredDt) + ")";
            }
        }
    }
}

